/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.utils;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import mods.battlegear2.api.IShield;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.inventory.InventoryPlayerBattle;
import mods.battlegear2.items.ItemShield;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class BattlegearUtils {
    private static String[] itemBlackListMethodNames = World.class.getName().equals("net.minecraft.world.World") ? new String[]{"onItemUse", "onItemRightClick"} : new String[]{BattlegearTranslator.getMapedMethodName("Item", "func_77648_a"), BattlegearTranslator.getMapedMethodName("Item", "func_77659_a")};
    private static Class[][] itemBlackListMethodParams = new Class[][]{{ItemStack.class, EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}, {ItemStack.class, World.class, EntityPlayer.class}};
    private static boolean[] weapons;
    private static boolean[] mainHandDualWeapons;
    private static boolean[] offhandDualWeapons;

    public static boolean isBlockingWithShield(EntityPlayer player) {
        return player.func_70093_af() && player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemShield;
    }

    public static boolean isPlayerInBattlemode(EntityPlayer player) {
        return player.field_71071_by instanceof InventoryPlayerBattle && ((InventoryPlayerBattle)player.field_71071_by).isBattlemode();
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack, int offset) {
        ((InventoryPlayerBattle)player.field_71071_by).setInventorySlotContents(player.field_71071_by.field_70461_c + offset, stack, false);
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack) {
        BattlegearUtils.setPlayerCurrentItem(player, stack, 0);
    }

    public static boolean isWeapon(int id) {
        if (Item.field_77698_e[id] instanceof IBattlegearWeapon) {
            return true;
        }
        return weapons[id];
    }

    public static boolean isMainHand(int id) {
        if (Item.field_77698_e[id] instanceof IBattlegearWeapon) {
            return ((IBattlegearWeapon)Item.field_77698_e[id]).willAllowOffhandWeapon();
        }
        return mainHandDualWeapons[id];
    }

    public static boolean isOffHand(int id) {
        if (Item.field_77698_e[id] instanceof IBattlegearWeapon) {
            return ((IBattlegearWeapon)Item.field_77698_e[id]).isOffhandHandDualWeapon();
        }
        if (Item.field_77698_e[id] instanceof IShield) {
            return true;
        }
        return offhandDualWeapons[id];
    }

    public static boolean allowsShield(int itemID) {
        if (Item.field_77698_e[itemID] instanceof IBattlegearWeapon) {
            return ((IBattlegearWeapon)Item.field_77698_e[itemID]).willAllowShield();
        }
        return mainHandDualWeapons[itemID];
    }

    public static void scanAndProcessItems() {
        weapons = new boolean[Item.field_77698_e.length];
        mainHandDualWeapons = new boolean[Item.field_77698_e.length];
        offhandDualWeapons = new boolean[Item.field_77698_e.length];
        for (int i = 0; i < Item.field_77698_e.length; ++i) {
            boolean valid;
            Item item = Item.field_77698_e[i];
            BattlegearUtils.weapons[i] = false;
            BattlegearUtils.mainHandDualWeapons[i] = false;
            BattlegearUtils.offhandDualWeapons[i] = false;
            if (item == null) continue;
            if (i == Block.field_72069_aq.field_71990_ca) {
                BattlegearUtils.offhandDualWeapons[i] = true;
            }
            boolean bl = valid = item.func_77639_j() == 1 && item.func_77645_m();
            if (!valid) continue;
            boolean bl2 = BattlegearUtils.weapons[i] = item instanceof ItemSword || item instanceof ItemBow || item instanceof ItemTool;
            if (!weapons[i]) continue;
            boolean rightClickFunction = BattlegearUtils.checkForRightClickFunction(item);
            BattlegearUtils.offhandDualWeapons[i] = !(item instanceof ItemTool) && !(item instanceof ItemBow) && !rightClickFunction;
            BattlegearUtils.mainHandDualWeapons[i] = !(item instanceof ItemBow) && !rightClickFunction;
        }
    }

    public static boolean checkForRightClickFunction(Item item) {
        try {
            if (item.func_77661_b(null) == EnumAction.block || item.func_77661_b(null) == EnumAction.none) {
                Class<?> c = item.getClass();
                while (!(c.equals(Item.class) || c.equals(ItemTool.class) || c.equals(ItemSword.class))) {
                    try {
                        try {
                            c.getDeclaredMethod(itemBlackListMethodNames[0], itemBlackListMethodParams[0]);
                            return true;
                        }
                        catch (NoSuchMethodException ignored) {
                            try {
                                c.getDeclaredMethod(itemBlackListMethodNames[1], itemBlackListMethodParams[1]);
                                return true;
                            }
                            catch (NoSuchMethodException ignored2) {
                            }
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        // empty catch block
                    }
                    c = c.getSuperclass();
                }
                return false;
            }
            return true;
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public static ItemStack readItemStack(ByteArrayDataInput par0DataInputStream) throws IOException {
        ItemStack itemstack = null;
        short short1 = par0DataInputStream.readShort();
        if (short1 >= 0) {
            byte b0 = par0DataInputStream.readByte();
            short short2 = par0DataInputStream.readShort();
            itemstack = new ItemStack((int)short1, (int)b0, (int)short2);
            itemstack.field_77990_d = BattlegearUtils.readNBTTagCompound(par0DataInputStream);
        }
        return itemstack;
    }

    public static NBTTagCompound readNBTTagCompound(ByteArrayDataInput par0DataInputStream) throws IOException {
        short short1 = par0DataInputStream.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        par0DataInputStream.readFully(abyte);
        return CompressedStreamTools.func_74792_a((byte[])abyte);
    }

    public static void writeItemStack(ByteArrayDataOutput par1DataOutputStream, ItemStack par0ItemStack) throws IOException {
        if (par0ItemStack == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            par1DataOutputStream.writeShort(par0ItemStack.field_77993_c);
            par1DataOutputStream.writeByte(par0ItemStack.field_77994_a);
            par1DataOutputStream.writeShort(par0ItemStack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (par0ItemStack.func_77973_b().func_77645_m() || par0ItemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = par0ItemStack.field_77990_d;
            }
            BattlegearUtils.writeNBTTagCompound(nbttagcompound, par1DataOutputStream);
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, ByteArrayDataOutput par1DataOutputStream) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutputStream.writeShort((int)((short)abyte.length));
            par1DataOutputStream.write(abyte);
        }
    }

    public static InventoryPlayer replaceInventory(EntityPlayer entityPlayer) {
        return new InventoryPlayerBattle(entityPlayer);
    }

    public static void attackTargetEntityWithCurrentOffItem(EntityPlayer player, Entity par1Entity) {
        player.field_71071_by.field_70461_c += InventoryPlayerBattle.WEAPON_SETS;
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, par1Entity))) {
            return;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b().onLeftClickEntity(stack, player, par1Entity)) {
            return;
        }
        if (par1Entity.func_70075_an() && !par1Entity.func_85031_j((Entity)player)) {
            float f = 1.0f;
            if (stack != null) {
                Collection map = stack.func_111283_C().get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
                for (Object ob : map) {
                    AttributeModifier am;
                    if (!(ob instanceof AttributeModifier) || !(am = (AttributeModifier)ob).func_111166_b().equals("Weapon modifier")) continue;
                    f = (float)((double)f + am.func_111164_d());
                }
            }
            int i = 0;
            float f1 = 0.0f;
            if (par1Entity instanceof EntityLivingBase) {
                f1 = EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)par1Entity));
                i += EnchantmentHelper.func_77507_b((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)par1Entity));
            }
            if (player.func_70051_ag()) {
                ++i;
            }
            if (f > 0.0f || f1 > 0.0f) {
                IEntityMultiPart ientitymultipart;
                boolean flag2;
                boolean flag;
                boolean bl = flag = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && par1Entity instanceof EntityLivingBase;
                if (flag && f > 0.0f) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag1 = false;
                int j = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (par1Entity instanceof EntityLivingBase && j > 0 && !par1Entity.func_70027_ad()) {
                    flag1 = true;
                    par1Entity.func_70015_d(1);
                }
                if (flag2 = par1Entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), f)) {
                    if (i > 0) {
                        par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (flag) {
                        player.func_71009_b(par1Entity);
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(par1Entity);
                    }
                    if (f >= 18.0f) {
                        player.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    player.func_130011_c(par1Entity);
                    if (par1Entity instanceof EntityLivingBase) {
                        EnchantmentThorns.func_92096_a((Entity)player, (EntityLivingBase)((EntityLivingBase)par1Entity), (Random)player.func_70681_au());
                    }
                }
                ItemStack itemstack = player.func_71045_bC();
                Entity object = par1Entity;
                if (par1Entity instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)par1Entity).field_70259_a) != null && ientitymultipart instanceof EntityLivingBase) {
                    object = (EntityLivingBase)ientitymultipart;
                }
                if (itemstack != null && object instanceof EntityLivingBase) {
                    itemstack.func_77961_a((EntityLivingBase)object, player);
                    if (itemstack.field_77994_a <= 0) {
                        player.func_71028_bD();
                    }
                }
                if (par1Entity instanceof EntityLivingBase) {
                    player.func_71064_a(StatList.field_75951_w, Math.round(f * 10.0f));
                    if (j > 0 && flag2) {
                        par1Entity.func_70015_d(j * 4);
                    } else if (flag1) {
                        par1Entity.func_70066_B();
                    }
                }
                player.func_71020_j(0.3f);
            }
        }
        player.field_71071_by.field_70461_c -= InventoryPlayerBattle.WEAPON_SETS;
    }

    public static void closeStream(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

