/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.items;

import java.util.List;
import mods.battlegear2.api.IDyable;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.QuiverArrowEvent;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemQuiver2
extends Item
implements IArrowContainer2,
IDyable {
    public Icon quiverDetails;
    public Icon quiverArrows;

    public ItemQuiver2(int id) {
        super(id);
        this.func_77625_d(1);
    }

    private NBTTagCompound getNBTTagComound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("current", (byte)0);
            stack.func_77982_d(compound);
        }
        return stack.func_77978_p();
    }

    public void func_94581_a(IconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
        this.quiverDetails = par1IconRegister.func_94245_a("battlegear2:quiver/quiver-details");
        this.quiverArrows = par1IconRegister.func_94245_a("battlegear2:quiver/quiver-arrows");
    }

    @Override
    public int getSlotCount(ItemStack container) {
        return 4;
    }

    @Override
    public int getSelectedSlot(ItemStack container) {
        return this.getNBTTagComound(container).func_74771_c("current");
    }

    @Override
    public void setSelectedSlot(ItemStack container, int newSlot) {
        this.getNBTTagComound(container).func_74774_a("current", (byte)newSlot);
    }

    @Override
    public ItemStack getStackInSlot(ItemStack container, int slot) {
        NBTTagCompound compound = this.getNBTTagComound(container);
        if (compound.func_74764_b("Slot" + slot)) {
            return ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("Slot" + slot));
        }
        return null;
    }

    @Override
    public void setStackInSlot(ItemStack container, int slot, ItemStack stack) {
        NBTTagCompound compound = this.getNBTTagComound(container);
        if (stack == null) {
            compound.func_82580_o("Slot" + slot);
        } else {
            NBTTagCompound newSlotCompound = new NBTTagCompound();
            stack.func_77955_b(newSlotCompound);
            compound.func_74766_a("Slot" + slot, newSlotCompound);
        }
    }

    @Override
    public boolean hasArrowFor(ItemStack stack, ItemStack bow, EntityPlayer player, int slot) {
        return bow != null && bow.func_77973_b() instanceof ItemBow && ((IArrowContainer2)stack.func_77973_b()).getStackInSlot(stack, slot) != null;
    }

    @Override
    public EntityArrow getArrowType(ItemStack stack, World world, EntityPlayer player, float charge) {
        ItemStack selected = this.getStackInSlot(stack, this.getSelectedSlot(stack));
        if (selected == null) {
            return null;
        }
        Class<? extends EntityArrow> clazz = QuiverArrowRegistry.getArrowClass(selected);
        if (clazz != null) {
            try {
                return clazz.getConstructor(World.class, EntityLivingBase.class, Float.TYPE).newInstance(player.field_70170_p, player, Float.valueOf(charge));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public void onArrowFired(World world, EntityPlayer player, ItemStack stack, ItemStack bow, EntityArrow arrow) {
    }

    @Override
    public void onPreArrowFired(QuiverArrowEvent arrowEvent) {
    }

    @Override
    public boolean isCraftableWithArrows(ItemStack stack, ItemStack arrows) {
        return arrows != null && (arrows.func_77973_b().field_77779_bT == Item.field_77704_l.field_77779_bT || arrows.func_77973_b().field_77779_bT == BattlegearConfig.MbArrows.field_77779_bT);
    }

    @Override
    public ItemStack addArrows(ItemStack container, ItemStack newStack) {
        if (newStack != null) {
            int left_over = newStack.field_77994_a;
            int slotCount = this.getSlotCount(container);
            for (int i = 0; i < slotCount && left_over > 0; ++i) {
                ItemStack slotStack = this.getStackInSlot(container, i);
                if (slotStack == null) {
                    newStack.field_77994_a = left_over;
                    this.setStackInSlot(container, i, newStack);
                    left_over = 0;
                    continue;
                }
                if (newStack.field_77993_c != slotStack.field_77993_c) continue;
                int newSize = Math.min(64, slotStack.field_77994_a + left_over);
                left_over -= newSize - slotStack.field_77994_a;
                slotStack.field_77994_a = newSize;
                this.setStackInSlot(container, i, slotStack);
            }
            if (left_over > 0) {
                newStack.field_77994_a = left_over;
                return newStack;
            }
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        super.func_77624_a(stack, par2EntityPlayer, list, par4);
        list.add(String.format("%s", StatCollector.func_74838_a((String)"attribute.quiver.arrow.count")));
        int slotCount = this.getSlotCount(stack);
        int selected = this.getSelectedSlot(stack);
        for (int i = 0; i < slotCount; ++i) {
            ItemStack slotStack = this.getStackInSlot(stack, i);
            if (slotStack != null) {
                list.add(String.format(" %s%s: %s x %s", i, i == selected ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.GOLD, slotStack.field_77994_a, StatCollector.func_74838_a((String)(slotStack.func_77973_b().func_77667_c(slotStack) + ".name"))));
                continue;
            }
            list.add(String.format(" %s%s: %s", i, i == selected ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.GOLD, StatCollector.func_74838_a((String)"attribute.quiver.arrow.empty")));
        }
    }

    @Override
    public boolean hasColor(ItemStack par1ItemStack) {
        return !par1ItemStack.func_77942_o() ? false : (!par1ItemStack.func_77978_p().func_74764_b("display") ? false : par1ItemStack.func_77978_p().func_74775_l("display").func_74764_b("color"));
    }

    @Override
    public int getColor(ItemStack par1ItemStack) {
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound == null) {
            return this.getDefaultColor(par1ItemStack);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        return nbttagcompound1 == null ? this.getDefaultColor(par1ItemStack) : (nbttagcompound1.func_74764_b("color") ? nbttagcompound1.func_74762_e("color") : this.getDefaultColor(par1ItemStack));
    }

    @Override
    public void removeColor(ItemStack par1ItemStack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")).func_74764_b("color")) {
            nbttagcompound1.func_82580_o("color");
        }
    }

    @Override
    public int getDefaultColor(ItemStack par1ItemStack) {
        return -3777483;
    }

    @Override
    public void setColor(ItemStack par1ItemStack, int par2) {
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            par1ItemStack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_74764_b("display")) {
            nbttagcompound.func_74766_a("display", nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", par2);
    }
}

