/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.ListIterator;
import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ModelBipedTransformer
implements IClassTransformer {
    private String modelBipedClassName;
    private String entityClassName;
    private String renderBipedMethodName;
    private String renderBibedMethodDesc;
    private String setRotationAngleMethodName;
    private String setRotationAngleMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.model.ModelBiped")) {
            this.modelBipedClassName = BattlegearTranslator.getMapedClassName("ModelBiped");
            this.entityClassName = BattlegearTranslator.getMapedClassName("Entity");
            this.setRotationAngleMethodName = BattlegearTranslator.getMapedMethodName("ModelBiped", "func_78087_a");
            this.setRotationAngleMethodDesc = BattlegearTranslator.getMapedMethodDesc("ModelBiped", "func_78087_a");
            this.renderBipedMethodName = BattlegearTranslator.getMapedMethodName("ModelBiped", "func_78088_a");
            this.renderBibedMethodDesc = BattlegearTranslator.getMapedMethodDesc("ModelBiped", "func_78088_a");
            System.out.println("M&B - Patching Class ModelBiped (" + name + ")");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            cn.fields.add(0, new FieldNode(1, "onGroundOffhand", "F", null, null));
            for (Object mnObj : cn.methods) {
                MethodNode method = (MethodNode)mnObj;
                if (!method.name.equals(this.renderBipedMethodName) || !method.desc.equals(this.renderBibedMethodDesc)) continue;
                this.processRotationAnglesMethod(method);
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class ModelBiped (" + name + ") done");
            if (BattlegearLoadingPlugin.debug) {
                TransformerUtils.writeClassFile(cw, name);
            }
            return cw.toByteArray();
        }
        return bytes;
    }

    private void processRotationAnglesMethod(MethodNode method) {
        System.out.println("\tPatching Method setRotationAngles in ModelBiped");
        ListIterator it = method.instructions.iterator();
        InsnList newInsn = new InsnList();
        while (it.hasNext()) {
            AbstractInsnNode nextInsn = (AbstractInsnNode)it.next();
            if (nextInsn.getOpcode() == 182 && ((MethodInsnNode)nextInsn).name.equals(this.setRotationAngleMethodName) && ((MethodInsnNode)nextInsn).desc.equals(this.setRotationAngleMethodDesc)) {
                newInsn.add(nextInsn);
                System.out.println("\t\tAdding hook");
                newInsn.add((AbstractInsnNode)new VarInsnNode(25, 1));
                newInsn.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newInsn.add((AbstractInsnNode)new VarInsnNode(23, 7));
                newInsn.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/client/utils/BattlegearRenderHelper", "moveOffHandArm", "(L" + this.entityClassName + ";L" + this.modelBipedClassName + ";F)V"));
                continue;
            }
            newInsn.add(nextInsn);
        }
    }
}

