/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.ListIterator;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityTrackerTransformer
implements IClassTransformer {
    private String tryStartTrackingMethodName;
    private String tryStartTrackingMethodDesc;
    private String entityPlayerClassName;
    private String entityPlayerMPClassName;
    private String netServerHandlerClasName;
    private String packet250CustomPayloadClassName;
    private String playerMPplayerNetServerHandlerField;
    private String sendPacketToPlayerMethodName;
    private String sendPacketToPlayerMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.entity.EntityTrackerEntry")) {
            this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("EntityPlayer");
            this.entityPlayerMPClassName = BattlegearTranslator.getMapedClassName("EntityPlayerMP");
            this.netServerHandlerClasName = BattlegearTranslator.getMapedClassName("NetServerHandler");
            this.packet250CustomPayloadClassName = BattlegearTranslator.getMapedClassName("Packet250CustomPayload");
            this.playerMPplayerNetServerHandlerField = BattlegearTranslator.getMapedFieldName("EntityPlayerMP", "field_71135_a");
            this.tryStartTrackingMethodName = BattlegearTranslator.getMapedMethodName("EntityTrackerEntry", "func_73117_b");
            this.tryStartTrackingMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityTrackerEntry", "func_73117_b");
            this.sendPacketToPlayerMethodName = BattlegearTranslator.getMapedMethodName("NetServerHandler", "func_72567_b");
            this.sendPacketToPlayerMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetServerHandler", "func_72567_b");
            System.out.println("M&B - Patching Class EntityTrackerEntry (" + name + ")");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            for (Object mnObj : cn.methods) {
                MethodNode method = (MethodNode)mnObj;
                if (!method.name.equals(this.tryStartTrackingMethodName) || !method.desc.equals(this.tryStartTrackingMethodDesc)) continue;
                System.out.println("\tPatching method tryStartTrackingEntity in EntityTrackerEntry");
                InsnList newList = new InsnList();
                ListIterator insn = method.instructions.iterator();
                boolean done = false;
                while (insn.hasNext()) {
                    AbstractInsnNode next = (AbstractInsnNode)insn.next();
                    if (!done && next instanceof TypeInsnNode && next.getOpcode() == 192 && ((TypeInsnNode)next).desc.equals(this.entityPlayerClassName)) {
                        newList.add(next);
                        newList.add((AbstractInsnNode)insn.next());
                        newList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerMPClassName, this.playerMPplayerNetServerHandlerField, "L" + this.netServerHandlerClasName + ";"));
                        newList.add((AbstractInsnNode)new VarInsnNode(25, 10));
                        newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/packet/BattlegearSyncItemPacket", "generatePacket", "(L" + this.entityPlayerClassName + ";)L" + this.packet250CustomPayloadClassName + ";"));
                        newList.add((AbstractInsnNode)new MethodInsnNode(182, this.netServerHandlerClasName, this.sendPacketToPlayerMethodName, this.sendPacketToPlayerMethodDesc));
                        done = true;
                        continue;
                    }
                    newList.add(next);
                }
                method.instructions = newList;
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class EntityTrackerEntry (" + name + ") done");
            TransformerUtils.writeClassFile(cw, name);
            return cw.toByteArray();
        }
        return bytes;
    }
}

