/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityPlayerTransformer
implements IClassTransformer {
    private String entityPlayerClassName;
    private String inventoryClassName;
    private String itemStackClassName;
    private String entityClassName;
    private String potionClassName;
    private String potionEffectClassName;
    private String entityLivingClassName;
    private String dataWatcherClassName;
    private String playerInventoryFieldName;
    private String inventoryCurrentItremField;
    private String potionDigSpeedField;
    private String potionDigSlowField;
    private String playerDataWatcherField;
    private String onItemFinishMethodName;
    private String onItemFinishMethodDesc;
    private String setCurrentItemArmourMethodName;
    private String setCurrentItemArmourMethodDesc;
    private String attackTargetMethodName;
    private String attackTargetMethodDesc;
    private String playerPotionActiveMethodName;
    private String playerPotionActiveMethodDesc;
    private String playerGetActivePotionMethodName;
    private String playerGetActivePotionMethodDesc;
    private String potionEffectGetAmpMethodName;
    private String playerUpdateArmSwingMethodName;
    private String dataWatcherAddObjectMethodName;
    private String dataWatcherAddObjectMethodDesc;
    private String playerInitMethodName;
    private String playerInitMethodDesc;
    private String itemStackGetItemMethodName;
    private String itemStackGetItemMethodDesc;
    private String dataWatcherGetByteMethodName;
    private String dataWatcherGetByteMethodDesc;
    private String dataWatcherUpdateObjectMethodName;
    private String dataWatcherUpdateObjectMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.entity.player.EntityPlayer")) {
            this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("EntityPlayer");
            this.inventoryClassName = BattlegearTranslator.getMapedClassName("InventoryPlayer");
            this.itemStackClassName = BattlegearTranslator.getMapedClassName("ItemStack");
            this.entityClassName = BattlegearTranslator.getMapedClassName("Entity");
            this.potionClassName = BattlegearTranslator.getMapedClassName("Potion");
            this.potionEffectClassName = BattlegearTranslator.getMapedClassName("PotionEffect");
            this.entityLivingClassName = BattlegearTranslator.getMapedClassName("EntityLivingBase");
            this.dataWatcherClassName = BattlegearTranslator.getMapedClassName("DataWatcher");
            this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by");
            this.inventoryCurrentItremField = BattlegearTranslator.getMapedFieldName("InventoryPlayer", "field_70461_c");
            this.potionDigSpeedField = BattlegearTranslator.getMapedFieldName("Potion", "field_76422_e");
            this.potionDigSlowField = BattlegearTranslator.getMapedFieldName("Potion", "field_76419_f");
            this.playerDataWatcherField = BattlegearTranslator.getMapedFieldName("Entity", "field_70180_af");
            this.onItemFinishMethodName = BattlegearTranslator.getMapedMethodName("EntityPlayer", "func_71036_o");
            this.onItemFinishMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityPlayer", "func_71036_o");
            this.setCurrentItemArmourMethodName = BattlegearTranslator.getMapedMethodName("EntityPlayer", "func_70062_b");
            this.setCurrentItemArmourMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityPlayer", "func_70062_b");
            this.attackTargetMethodName = BattlegearTranslator.getMapedMethodName("EntityPlayer", "func_71059_n");
            this.attackTargetMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityPlayer", "func_71059_n");
            this.playerPotionActiveMethodName = BattlegearTranslator.getMapedMethodName("EntityLivingBase", "func_70644_a");
            this.playerPotionActiveMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityLivingBase", "func_70644_a");
            this.playerGetActivePotionMethodName = BattlegearTranslator.getMapedMethodName("EntityLivingBase", "func_70660_b");
            this.playerGetActivePotionMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityLivingBase", "func_70660_b");
            this.potionEffectGetAmpMethodName = BattlegearTranslator.getMapedMethodName("PotionEffect", "func_76458_c");
            this.playerUpdateArmSwingMethodName = BattlegearTranslator.getMapedMethodName("EntityLivingBase", "func_82168_bl");
            this.dataWatcherAddObjectMethodName = BattlegearTranslator.getMapedMethodName("DataWatcher", "func_75682_a");
            this.dataWatcherAddObjectMethodDesc = BattlegearTranslator.getMapedMethodDesc("DataWatcher", "func_75682_a");
            this.playerInitMethodName = BattlegearTranslator.getMapedMethodName("EntityPlayer", "func_70088_a");
            this.playerInitMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityPlayer", "func_70088_a");
            this.itemStackGetItemMethodName = BattlegearTranslator.getMapedMethodName("ItemStack", "func_77973_b");
            this.itemStackGetItemMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemStack", "func_77973_b");
            this.dataWatcherGetByteMethodName = BattlegearTranslator.getMapedMethodName("DataWatcher", "func_75683_a");
            this.dataWatcherGetByteMethodDesc = BattlegearTranslator.getMapedMethodDesc("DataWatcher", "func_75683_a");
            this.dataWatcherUpdateObjectMethodName = BattlegearTranslator.getMapedMethodName("DataWatcher", "func_75692_b");
            this.dataWatcherUpdateObjectMethodDesc = BattlegearTranslator.getMapedMethodDesc("DataWatcher", "func_75692_b");
            System.out.println("M&B - Patching Class EntityPlayer (" + name + ")");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            this.processFields(cn);
            this.processMethods(cn);
            System.out.println("\tCreating new methods in EntityPlayer");
            cn.methods.add(0, this.generateAttackOffhandMethod());
            cn.methods.add(1, this.generateSwingOffhand());
            cn.methods.add(2, this.generateGetOffSwingMethod());
            cn.methods.add(3, this.generateSwingAnimationEnd2());
            cn.methods.add(4, this.generateUpdateSwingArm());
            cn.methods.add(5, this.generateIsBattleMode());
            cn.methods.add(6, this.generateIsBlockingWithShield());
            cn.methods.add(7, this.generateSetBlockingWithShield());
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class EntityPlayer done");
            if (BattlegearLoadingPlugin.debug) {
                TransformerUtils.writeClassFile(cw, name);
            }
            return cw.toByteArray();
        }
        return bytes;
    }

    private void processFields(ClassNode cn) {
        System.out.println("\tAdding new fields to EntityPlayer");
        cn.fields.add(0, new FieldNode(1, "offHandSwingProgress", "F", null, (Object)Float.valueOf(0.0f)));
        cn.fields.add(1, new FieldNode(1, "prevOffHandSwingProgress", "F", null, (Object)Float.valueOf(0.0f)));
        cn.fields.add(2, new FieldNode(1, "offHandSwingProgressInt", "I", null, (Object)0));
        cn.fields.add(3, new FieldNode(1, "isOffHandSwingInProgress", "Z", null, (Object)Float.valueOf(0.0f)));
        cn.fields.add(4, new FieldNode(1, "specialActionTimer", "I", null, (Object)Float.valueOf(0.0f)));
        for (Object fnObj : cn.fields) {
            FieldNode fn = (FieldNode)fnObj;
            if (!fn.name.equals("L" + this.inventoryCurrentItremField) || !fn.desc.equals(this.inventoryClassName + ";")) continue;
            System.out.println("M&B - Marking field inventory as final in EntityPlayer");
            fn.access = 17;
        }
    }

    private void processMethods(ClassNode cn) {
        for (Object mnObj : cn.methods) {
            MethodNode mn = (MethodNode)mnObj;
            if (mn.name.equals("<init>")) {
                System.out.println("\tPatching constructor in EntityPlayer");
                for (AbstractInsnNode insn : mn.instructions) {
                    if (insn instanceof TypeInsnNode) {
                        if (!((TypeInsnNode)insn).desc.equals(this.inventoryClassName)) continue;
                        ((TypeInsnNode)insn).desc = "mods/battlegear2/inventory/InventoryPlayerBattle";
                        continue;
                    }
                    if (!(insn instanceof MethodInsnNode) || !((MethodInsnNode)insn).owner.equals(this.inventoryClassName)) continue;
                    ((MethodInsnNode)insn).owner = "mods/battlegear2/inventory/InventoryPlayerBattle";
                }
                continue;
            }
            if (mn.name.equals(this.onItemFinishMethodName) && mn.desc.equals(this.onItemFinishMethodDesc)) {
                System.out.println("\tPatching method onItemUseFinish in EntityPlayer");
                TransformerUtils.replaceInventoryArrayAccess(mn, this.entityPlayerClassName, this.playerInventoryFieldName, mn.maxStack, mn.maxLocals);
                continue;
            }
            if (mn.name.equals(this.setCurrentItemArmourMethodName) && mn.desc.equals(this.setCurrentItemArmourMethodDesc)) {
                System.out.println("\tPatching method setCurrentItemOrArmor in EntityPlayer");
                TransformerUtils.replaceInventoryArrayAccess(mn, this.entityPlayerClassName, this.playerInventoryFieldName, mn.maxStack, mn.maxLocals);
                continue;
            }
            if (!mn.name.equals(this.playerInitMethodName) || !mn.desc.equals(this.playerInitMethodDesc)) continue;
            System.out.println("\tPatching method entityInit in EntityPlayer");
            InsnList newList = new InsnList();
            for (AbstractInsnNode next : mn.instructions) {
                if (next instanceof InsnNode && next.getOpcode() == 177) {
                    newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerDataWatcherField, "L" + this.dataWatcherClassName + ";"));
                    newList.add((AbstractInsnNode)new VarInsnNode(16, 25));
                    newList.add((AbstractInsnNode)new InsnNode(3));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
                    newList.add((AbstractInsnNode)new MethodInsnNode(182, this.dataWatcherClassName, this.dataWatcherAddObjectMethodName, this.dataWatcherAddObjectMethodDesc));
                }
                newList.add(next);
            }
            mn.instructions = newList;
        }
    }

    private MethodNode generateIsBlockingWithShield() {
        MethodNode mn = new MethodNode(262144, 1, "isBlockingWithShield", "()Z", null, null);
        LabelNode L1 = new LabelNode();
        LabelNode L3 = new LabelNode();
        LabelNode L4 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/inventory/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/inventory/InventoryPlayerBattle", "getCurrentOffhandWeapon", "()L" + this.itemStackClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(198, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/inventory/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/inventory/InventoryPlayerBattle", "getCurrentOffhandWeapon", "()L" + this.itemStackClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.itemStackClassName, this.itemStackGetItemMethodName, this.itemStackGetItemMethodDesc));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(193, "mods/battlegear2/api/IShield"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerDataWatcherField, "L" + this.dataWatcherClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(16, 25));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.dataWatcherClassName, this.dataWatcherGetByteMethodName, this.dataWatcherGetByteMethodDesc));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(158, L3));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, L4));
        mn.instructions.add((AbstractInsnNode)L3);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)L4);
        mn.instructions.add((AbstractInsnNode)new FrameNode(4, 0, null, 1, new Object[]{Opcodes.INTEGER}));
        mn.instructions.add((AbstractInsnNode)new InsnNode(172));
        mn.instructions.add((AbstractInsnNode)L1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new InsnNode(172));
        mn.maxStack = 2;
        mn.maxLocals = 1;
        return mn;
    }

    private MethodNode generateSetBlockingWithShield() {
        MethodNode mn = new MethodNode(262144, 1, "setBlockingWithShield", "(Z)V", null, null);
        LabelNode L1 = new LabelNode();
        LabelNode L3 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/inventory/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/inventory/InventoryPlayerBattle", "getCurrentOffhandWeapon", "()L" + this.itemStackClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(198, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/inventory/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/inventory/InventoryPlayerBattle", "getCurrentOffhandWeapon", "()L" + this.itemStackClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.itemStackClassName, this.itemStackGetItemMethodName, this.itemStackGetItemMethodDesc));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(193, "mods/battlegear2/api/IShield"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, L1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerDataWatcherField, "L" + this.dataWatcherClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(16, 25));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.dataWatcherClassName, this.dataWatcherUpdateObjectMethodName, this.dataWatcherUpdateObjectMethodDesc));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, L3));
        mn.instructions.add((AbstractInsnNode)L1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerDataWatcherField, "L" + this.dataWatcherClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(16, 25));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.dataWatcherClassName, this.dataWatcherUpdateObjectMethodName, this.dataWatcherUpdateObjectMethodDesc));
        mn.instructions.add((AbstractInsnNode)L3);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 3;
        mn.maxLocals = 2;
        return mn;
    }

    private MethodNode generateAttackOffhandMethod() {
        MethodNode mn = new MethodNode(262144, 1, "attackTargetEntityWithCurrentOffItem", "(L" + this.entityClassName + ";)V", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.inventoryClassName, this.inventoryCurrentItremField, "I"));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "mods/battlegear2/inventory/InventoryPlayerBattle", "WEAPON_SETS", "I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.inventoryClassName, this.inventoryCurrentItremField, "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.attackTargetMethodName, this.attackTargetMethodDesc));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.inventoryClassName, this.inventoryCurrentItremField, "I"));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, "mods/battlegear2/inventory/InventoryPlayerBattle", "WEAPON_SETS", "I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(100));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.inventoryClassName, this.inventoryCurrentItremField, "I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 3;
        mn.maxLocals = 2;
        return mn;
    }

    private MethodNode generateSwingOffhand() {
        MethodNode mn = new MethodNode(262144, 1, "swingOffItem", "()V", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z"));
        LabelNode l0 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, l0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.entityPlayerClassName, "getArmSwingAnimationEndCopy", "()I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(5));
        mn.instructions.add((AbstractInsnNode)new InsnNode(108));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(162, l0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        LabelNode l1 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(156, l1));
        mn.instructions.add((AbstractInsnNode)l0);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(2));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z"));
        mn.instructions.add((AbstractInsnNode)l1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 3;
        mn.maxLocals = 1;
        return mn;
    }

    private MethodNode generateGetOffSwingMethod() {
        MethodNode mn = new MethodNode(262144, 1, "getOffSwingProgress", "(F)F", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "prevOffHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(102));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(56, 2));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
        mn.instructions.add((AbstractInsnNode)new InsnNode(11));
        mn.instructions.add((AbstractInsnNode)new InsnNode(150));
        LabelNode l0 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(156, l0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
        mn.instructions.add((AbstractInsnNode)new InsnNode(12));
        mn.instructions.add((AbstractInsnNode)new InsnNode(98));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(56, 2));
        mn.instructions.add((AbstractInsnNode)l0);
        mn.instructions.add((AbstractInsnNode)new FrameNode(1, 1, new Object[]{Opcodes.FLOAT}, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "prevOffHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 2));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(23, 1));
        mn.instructions.add((AbstractInsnNode)new InsnNode(106));
        mn.instructions.add((AbstractInsnNode)new InsnNode(98));
        mn.instructions.add((AbstractInsnNode)new InsnNode(174));
        mn.maxLocals = 3;
        mn.maxStack = 3;
        return mn;
    }

    private MethodNode generateSwingAnimationEnd2() {
        MethodNode mn = new MethodNode(262144, 2, "getArmSwingAnimationEndCopy", "()I", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.potionClassName, this.potionDigSpeedField, "L" + this.potionClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.playerPotionActiveMethodName, this.playerPotionActiveMethodDesc));
        LabelNode l0 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, l0));
        mn.instructions.add((AbstractInsnNode)new IntInsnNode(16, 6));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.potionClassName, this.potionDigSpeedField, "L" + this.potionClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.playerGetActivePotionMethodName, this.playerGetActivePotionMethodDesc));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.potionEffectClassName, this.potionEffectGetAmpMethodName, "()I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new InsnNode(104));
        mn.instructions.add((AbstractInsnNode)new InsnNode(100));
        LabelNode l1 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, l1));
        mn.instructions.add((AbstractInsnNode)l0);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.potionClassName, this.potionDigSlowField, "L" + this.potionClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.playerPotionActiveMethodName, "(L" + this.potionClassName + ";)Z"));
        LabelNode l2 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, l2));
        mn.instructions.add((AbstractInsnNode)new IntInsnNode(16, 6));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(178, this.potionClassName, this.potionDigSlowField, "L" + this.potionClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.entityPlayerClassName, this.playerGetActivePotionMethodName, "(L" + this.potionClassName + ";)L" + this.potionEffectClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, this.potionEffectClassName, this.potionEffectGetAmpMethodName, "()I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new InsnNode(5));
        mn.instructions.add((AbstractInsnNode)new InsnNode(104));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, l1));
        mn.instructions.add((AbstractInsnNode)l2);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new IntInsnNode(16, 6));
        mn.instructions.add((AbstractInsnNode)l1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(4, 0, null, 1, new Object[]{Opcodes.INTEGER}));
        mn.instructions.add((AbstractInsnNode)new InsnNode(172));
        mn.maxStack = 4;
        mn.maxLocals = 1;
        return mn;
    }

    private MethodNode generateUpdateSwingArm() {
        MethodNode mn = new MethodNode(262144, 4, this.playerUpdateArmSwingMethodName, "()V", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.entityLivingClassName, this.playerUpdateArmSwingMethodName, "()V"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "prevOffHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(183, this.entityPlayerClassName, "getArmSwingAnimationEndCopy", "()I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(54, 1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z"));
        LabelNode l0 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(153, l0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(89));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(4));
        mn.instructions.add((AbstractInsnNode)new InsnNode(96));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        LabelNode l1 = new LabelNode();
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(161, l1));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "isOffHandSwingInProgress", "Z"));
        mn.instructions.add((AbstractInsnNode)new JumpInsnNode(167, l1));
        mn.instructions.add((AbstractInsnNode)l0);
        mn.instructions.add((AbstractInsnNode)new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new InsnNode(3));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)l1);
        mn.instructions.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, "offHandSwingProgressInt", "I"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(134));
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        mn.instructions.add((AbstractInsnNode)new InsnNode(134));
        mn.instructions.add((AbstractInsnNode)new InsnNode(110));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(181, this.entityPlayerClassName, "offHandSwingProgress", "F"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(177));
        mn.maxStack = 3;
        mn.maxLocals = 2;
        return mn;
    }

    private MethodNode generateIsBattleMode() {
        MethodNode mn = new MethodNode(262144, 1, "isBattlemode", "()Z", null, null);
        mn.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        mn.instructions.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerClassName, this.playerInventoryFieldName, "L" + this.inventoryClassName + ";"));
        mn.instructions.add((AbstractInsnNode)new TypeInsnNode(192, "mods/battlegear2/inventory/InventoryPlayerBattle"));
        mn.instructions.add((AbstractInsnNode)new MethodInsnNode(182, "mods/battlegear2/inventory/InventoryPlayerBattle", "isBattlemode", "()Z"));
        mn.instructions.add((AbstractInsnNode)new InsnNode(172));
        mn.maxStack = 1;
        mn.maxLocals = 1;
        return mn;
    }
}

