/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.ListIterator;
import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityOtherPlayerMPTransformer
implements IClassTransformer {
    private String inventoryPlayerClassName;
    private String itemStackClassName;
    private String entityOtherPlayerMPClassName;
    private String itemClassName;
    private String mainInventoryArrayFieldName;
    private String currentItemFieldName;
    private String playerInventoryFieldName;
    private String getStackInSlotMethodName;
    private String getStackInSlotMethodDesc;
    private String onUpdateMethodName;
    private String onUpdateMethodDesc;
    private String setCurrentItemMethodName;
    private String setCurrentItemMethodDesc;
    private String isItemInUseFieldName;
    private String limbSwingFieldName;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.entity.EntityOtherPlayerMP")) {
            System.out.println("M&B - Patching Class EntityOtherPlayerMP (" + name + ")");
            this.inventoryPlayerClassName = BattlegearTranslator.getMapedClassName("InventoryPlayer");
            this.itemStackClassName = BattlegearTranslator.getMapedClassName("ItemStack");
            this.entityOtherPlayerMPClassName = BattlegearTranslator.getMapedClassName("EntityOtherPlayerMP");
            this.itemClassName = BattlegearTranslator.getMapedClassName("Item");
            this.isItemInUseFieldName = BattlegearTranslator.getMapedFieldName("EntityOtherPlayerMP", "field_71186_a");
            this.limbSwingFieldName = BattlegearTranslator.getMapedFieldName("EntityLivingBase", "field_70754_ba");
            this.currentItemFieldName = BattlegearTranslator.getMapedFieldName("InventoryPlayer", "field_71185_c");
            this.mainInventoryArrayFieldName = BattlegearTranslator.getMapedFieldName("InventoryPlayer", "field_70462_a");
            this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by");
            this.getStackInSlotMethodName = BattlegearTranslator.getMapedMethodName("InventoryPlayer", "func_70301_a");
            this.getStackInSlotMethodDesc = BattlegearTranslator.getMapedMethodDesc("InventoryPlayer", "func_70301_a");
            this.setCurrentItemMethodName = BattlegearTranslator.getMapedMethodName("EntityOtherPlayerMP", "func_70062_b");
            this.setCurrentItemMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityOtherPlayerMP", "func_70062_b");
            this.onUpdateMethodName = BattlegearTranslator.getMapedMethodName("EntityOtherPlayerMP", "func_70071_h_");
            this.onUpdateMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityOtherPlayerMP", "func_70071_h_");
            System.out.println(this.onUpdateMethodName);
            System.out.println(this.onUpdateMethodDesc);
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            for (Object mnObj : cn.methods) {
                MethodNode mn = (MethodNode)mnObj;
                if (mn.name.equals(this.setCurrentItemMethodName) && mn.desc.equals(this.setCurrentItemMethodDesc)) {
                    this.processSetCurrentItemMethod(mn);
                }
                if (!mn.name.equals(this.onUpdateMethodName) || !mn.desc.equals(this.onUpdateMethodDesc)) continue;
                this.processOnUpdateMethod(mn);
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class EntityOtherPlayerMP done");
            if (BattlegearLoadingPlugin.debug) {
                TransformerUtils.writeClassFile(cw, name);
            }
            return cw.toByteArray();
        }
        return bytes;
    }

    private void processOnUpdateMethod(MethodNode mn) {
        System.out.println("\tPatching method onUpdate in EntityOtherPlayerMP");
        InsnList newList = new InsnList();
        ListIterator it = mn.instructions.iterator();
        boolean done = false;
        while (it.hasNext() && !done) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node instanceof FieldInsnNode && node.getOpcode() == 181 && ((FieldInsnNode)node).owner.equals(this.entityOtherPlayerMPClassName) && ((FieldInsnNode)node).name.equals(this.limbSwingFieldName)) {
                newList.add(node);
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityOtherPlayerMPClassName, this.isItemInUseFieldName, "Z"));
                newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/client/utils/BattlegearClientUtils", "entityOtherPlayerIsItemInUseHook", "(L" + this.entityOtherPlayerMPClassName + ";Z)Z"));
                newList.add((AbstractInsnNode)new FieldInsnNode(181, this.entityOtherPlayerMPClassName, this.isItemInUseFieldName, "Z"));
                newList.add((AbstractInsnNode)new InsnNode(177));
                done = true;
                continue;
            }
            newList.add(node);
        }
        mn.instructions = newList;
        --mn.maxLocals;
    }

    private void processSetCurrentItemMethod(MethodNode mn) {
        System.out.println("\tPatching method setCurrentItem in EntityOtherPlayerMP");
        TransformerUtils.replaceInventoryArrayAccess(mn, this.entityOtherPlayerMPClassName, this.playerInventoryFieldName, 4, 3, 3);
    }
}

