/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import mods.battlegear2.api.heraldry.HeraldryData;
import mods.battlegear2.api.heraldry.IHeraldryItem;
import mods.battlegear2.client.heraldry.HeraldryTextureSmall;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class HeraldryItemRenderer
implements IItemRenderer {
    private RenderItem itemRenderer;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return item.func_77973_b() instanceof IHeraldryItem && ((IHeraldryItem)item.func_77973_b()).hasHeraldry(item) && type == IItemRenderer.ItemRenderType.INVENTORY;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.itemRenderer == null) {
            this.itemRenderer = new RenderItem();
        }
        byte[] heraldryData = ((IHeraldryItem)item.func_77973_b()).getHeraldry(item);
        switch (type) {
            case INVENTORY: {
                this.doInventoryRendering(item, heraldryData, (IHeraldryItem)item.func_77973_b());
            }
        }
    }

    private void doInventoryRendering(ItemStack item, byte[] heraldryData, IHeraldryItem heraldryItem) {
        Icon icon = heraldryItem.getBaseIcon(item);
        this.itemRenderer.field_77023_b += 100.0f;
        if (heraldryItem.shouldDoPass(IHeraldryItem.HeraldyRenderPassess.Pattern) && icon != null) {
            GL11.glPushMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.itemRenderer.func_94149_a(0, 0, icon, 16, 16);
            ResourceLocation crestLocation = new ResourceLocation("Small:" + HeraldryData.byteArrayToHex(heraldryData));
            Object texture = Minecraft.func_71410_x().field_71446_o.func_110581_b(crestLocation);
            if (texture == null) {
                texture = new HeraldryTextureSmall(new HeraldryData(heraldryData));
                Minecraft.func_71410_x().field_71446_o.func_110579_a(crestLocation, texture);
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(crestLocation);
            GL11.glDepthFunc((int)514);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.renderTexturedQuad(0, 0, this.itemRenderer.field_77023_b, 16, 16);
            GL11.glDisable((int)3042);
            GL11.glDepthFunc((int)515);
            GL11.glPopMatrix();
        }
        icon = heraldryItem.getPostRenderIcon(item);
        if (heraldryItem.shouldDoPass(IHeraldryItem.HeraldyRenderPassess.PostRenderIcon) && icon != null) {
            GL11.glPushMatrix();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        this.itemRenderer.field_77023_b -= 100.0f;
    }

    public void renderTexturedQuad(int x, int y, float z, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)z, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)z, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)z, 1.0, 0.0);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)z, 0.0, 0.0);
        tessellator.func_78381_a();
    }
}

