/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.heraldry;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.resources.ResourceManager;
import net.minecraft.util.ResourceLocation;

public class PatternStore {
    public static final ResourceLocation small_image = new ResourceLocation("battlegear2", "textures/heraldry/Patterns-small.png");
    public static final int IMAGES_X = 8;
    public static final int IMAGES_Y = 4;
    public static int[][][][] small_rgbs;

    public static void initialise(ResourceManager rm) {
        try {
            InputStream inputstream = rm.func_110536_a(small_image).func_110527_b();
            BufferedImage image = ImageIO.read(inputstream);
            small_rgbs = new int[32][3][image.getWidth() / 8][image.getHeight() / 4];
            int imageRes = image.getWidth() / 8;
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int blue;
                    int green;
                    int imageNo = x / imageRes + 8 * (y / imageRes);
                    int rgb = image.getRGB(x, y);
                    int red = rgb >> 16 & 0xFF;
                    int total = red + (green = rgb >> 8 & 0xFF) + (blue = rgb & 0xFF);
                    if (total == 0) {
                        PatternStore.small_rgbs[imageNo][0][x % imageRes][y % imageRes] = 255;
                        PatternStore.small_rgbs[imageNo][1][x % imageRes][y % imageRes] = 0;
                        PatternStore.small_rgbs[imageNo][2][x % imageRes][y % imageRes] = 0;
                        continue;
                    }
                    PatternStore.small_rgbs[imageNo][0][x % imageRes][y % imageRes] = 255 * red / total;
                    PatternStore.small_rgbs[imageNo][1][x % imageRes][y % imageRes] = 255 * green / total;
                    PatternStore.small_rgbs[imageNo][2][x % imageRes][y % imageRes] = 255 * blue / total;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getBlendedSmallPixel(byte imageNo, int x, int y, int col1, int col2, int col3) {
        int red = (col1 >> 16 & 0xFF) * small_rgbs[imageNo][0][x][y] / 255 + (col2 >> 16 & 0xFF) * small_rgbs[imageNo][1][x][y] / 255 + (col3 >> 16 & 0xFF) * small_rgbs[imageNo][2][x][y] / 255;
        int green = (col1 >> 8 & 0xFF) * small_rgbs[imageNo][0][x][y] / 255 + (col2 >> 8 & 0xFF) * small_rgbs[imageNo][1][x][y] / 255 + (col3 >> 8 & 0xFF) * small_rgbs[imageNo][2][x][y] / 255;
        int blue = (col1 & 0xFF) * small_rgbs[imageNo][0][x][y] / 255 + (col2 & 0xFF) * small_rgbs[imageNo][1][x][y] / 255 + (col3 & 0xFF) * small_rgbs[imageNo][2][x][y] / 255;
        return 0xFF000000 | red << 16 & 0xFF0000 | green << 8 & 0xFF00 | blue & 0xFF;
    }
}

