/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.heraldry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import mods.battlegear2.utils.BattlegearUtils;

public class HeraldryData {
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int BLUE = 3;
    private byte pattern;
    private short crest;
    private byte crestPosition;
    private int[] colours = new int[5];
    private byte helm;
    private byte banner;
    private byte[] byteArray = null;

    public HeraldryData(int pattern, int pattern_col_1, int pattern_col_2, int pattern_col_3, int crest, int crest_col_1, int crest_col_2, int crest_position, int helm, int banner) {
        this.pattern = (byte)pattern;
        this.crest = (short)crest;
        this.colours = new int[]{pattern_col_1, pattern_col_2, pattern_col_3, crest_col_1, crest_col_2};
        this.crestPosition = (byte)crest_position;
        this.helm = (byte)helm;
        this.banner = (byte)banner;
    }

    public HeraldryData(byte pattern, int pattern_col_1, int pattern_col_2, int pattern_col_3) {
        this(pattern, pattern_col_1, pattern_col_2, pattern_col_3, 0, 0, 0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HeraldryData(byte[] data) {
        DataInputStream input = null;
        try {
            input = new DataInputStream(new ByteArrayInputStream(data));
            this.pattern = input.readByte();
            this.crest = input.readShort();
            this.crestPosition = input.readByte();
            this.colours = new int[5];
            for (int i = 0; i < this.colours.length; ++i) {
                this.colours[i] = input.readInt();
            }
            this.helm = input.readByte();
            this.banner = input.readByte();
            this.byteArray = Arrays.copyOf(data, data.length);
            BattlegearUtils.closeStream(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BattlegearUtils.closeStream(input);
        }
    }

    public static HeraldryData getDefault() {
        return new HeraldryData(10, -16777216, -1, -256, 0, -16777216, -16777216, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteArray() {
        if (this.byteArray != null) {
            return this.byteArray;
        }
        DataOutputStream output = null;
        ByteArrayOutputStream bos = null;
        try {
            bos = new ByteArrayOutputStream();
            output = new DataOutputStream(bos);
            output.writeByte(this.pattern);
            output.writeShort(this.crest);
            output.writeByte(this.crestPosition);
            for (int i = 0; i < 5; ++i) {
                output.writeInt(this.colours[i]);
            }
            output.writeByte(this.helm);
            output.writeByte(this.banner);
            byte[] i = bos.toByteArray();
            BattlegearUtils.closeStream(output);
            return i;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BattlegearUtils.closeStream(output);
        }
        return null;
    }

    public int getColourChanel(int colour, int chanelNo) {
        switch (chanelNo) {
            case 1: {
                return this.colours[colour] >> 16 & 0xFF;
            }
            case 2: {
                return this.colours[colour] >> 8 & 0xFF;
            }
            case 3: {
                return this.colours[colour] >> 0 & 0xFF;
            }
        }
        return this.colours[colour] >> 16 & 0xFF;
    }

    public byte getPattern() {
        return this.pattern;
    }

    public int getColour(int i) {
        return this.colours[i];
    }

    public String toString() {
        return HeraldryData.byteArrayToHex(this.getByteArray());
    }

    public static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    public short getCrest() {
        return this.crest;
    }
}

