/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.RenderItemBarEvent;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.heraldry.PatternStore;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.client.BattlegearClientTickHandeler;
import mods.battlegear2.client.ClientProxy;
import mods.battlegear2.client.gui.BattlegearInGameGUI;
import mods.battlegear2.client.gui.controls.GuiBGInventoryButton;
import mods.battlegear2.client.gui.controls.GuiPlaceableButton;
import mods.battlegear2.client.gui.controls.GuiSigilButton;
import mods.battlegear2.client.model.QuiverModel;
import mods.battlegear2.client.utils.BattlegearRenderHelper;
import mods.battlegear2.items.ItemQuiver;
import mods.battlegear2.packet.PickBlockPacket;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderSkeleton;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class BattlegearClientEvents {
    private final BattlegearInGameGUI inGameGUI = new BattlegearInGameGUI();
    private final QuiverModel quiverModel = new QuiverModel();
    private final ResourceLocation quiverDetails = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverDetails.png");
    private final ResourceLocation quiverBase = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverBase.png");
    public static final ResourceLocation patterns = new ResourceLocation("battlegear2", "textures/heraldry/Patterns-small.png");
    public static int storageIndex;
    public static List<GuiPlaceableButton> tabsList;
    private static final int SKELETON_ARROW = 5;
    private static final int MAIN_INV;

    @ForgeSubscribe(priority=EventPriority.HIGHEST)
    public void postRenderBar(RenderItemBarEvent.BattleSlots event) {
        if (!event.isMainHand) {
            event.xOffset += BattlegearConfig.battleBarOffset[0];
            event.yOffset += BattlegearConfig.battleBarOffset[1];
        } else {
            event.xOffset += BattlegearConfig.battleBarOffset[2];
            event.yOffset += BattlegearConfig.battleBarOffset[3];
        }
    }

    @ForgeSubscribe(priority=EventPriority.HIGHEST)
    public void postRenderQuiver(RenderItemBarEvent.QuiverSlots event) {
        event.xOffset += BattlegearConfig.quiverBarOffset[0];
        event.yOffset += BattlegearConfig.quiverBarOffset[1];
    }

    @ForgeSubscribe(priority=EventPriority.HIGHEST)
    public void postRenderShield(RenderItemBarEvent.ShieldBar event) {
        event.xOffset += BattlegearConfig.shieldBarOffset[0];
        event.yOffset += BattlegearConfig.shieldBarOffset[1];
    }

    @ForgeSubscribe
    public void postRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            this.inGameGUI.renderGameOverlay(event.partialTicks, event.mouseX, event.mouseY);
        }
    }

    @ForgeSubscribe
    public void render3rdPersonBattlemode(RenderPlayerEvent.Specials.Post event) {
        ItemStack quiverStack;
        ModelBiped biped = (ModelBiped)event.renderer.field_77045_g;
        BattlegearRenderHelper.renderItemIn3rdPerson(event.entityPlayer, biped, event.partialRenderTick);
        ItemStack mainhand = event.entityPlayer.func_70694_bm();
        if (mainhand != null && (quiverStack = QuiverArrowRegistry.getArrowContainer(mainhand, event.entityPlayer)) != null && quiverStack.func_77973_b() instanceof ItemQuiver) {
            ItemQuiver quiver = (ItemQuiver)quiverStack.func_77973_b();
            int col = quiver.getColor(quiverStack);
            float red = (float)(col >> 16 & 0xFF) / 255.0f;
            float green = (float)(col >> 8 & 0xFF) / 255.0f;
            float blue = (float)(col & 0xFF) / 255.0f;
            int maxStack = quiver.getSlotCount(quiverStack);
            int arrowCount = 0;
            for (int i = 0; i < maxStack; ++i) {
                arrowCount += quiver.getStackInSlot(quiverStack, i) == null ? 0 : 1;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.quiverDetails);
            GL11.glPushMatrix();
            biped.field_78115_e.func_78794_c(0.0625f);
            GL11.glScalef((float)1.05f, (float)1.05f, (float)1.05f);
            this.quiverModel.render(arrowCount, 0.0625f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.quiverBase);
            GL11.glColor3f((float)red, (float)green, (float)blue);
            this.quiverModel.render(0, 0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    @ForgeSubscribe
    public void renderLiving(RenderLivingEvent.Post event) {
        if (BattlegearConfig.enableSkeletonQuiver && event.entity instanceof EntitySkeleton && event.renderer instanceof RenderSkeleton) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.quiverDetails);
            double d0 = ((EntitySkeleton)event.entity).field_70142_S + (((EntitySkeleton)event.entity).field_70165_t - ((EntitySkeleton)event.entity).field_70142_S) * (double)BattlegearClientTickHandeler.partialTick;
            double d1 = ((EntitySkeleton)event.entity).field_70137_T + (((EntitySkeleton)event.entity).field_70163_u - ((EntitySkeleton)event.entity).field_70137_T) * (double)BattlegearClientTickHandeler.partialTick;
            double d2 = ((EntitySkeleton)event.entity).field_70136_U + (((EntitySkeleton)event.entity).field_70161_v - ((EntitySkeleton)event.entity).field_70136_U) * (double)BattlegearClientTickHandeler.partialTick;
            GL11.glTranslatef((float)((float)(d0 - RenderManager.field_78725_b)), (float)((float)(d1 - RenderManager.field_78726_c)), (float)((float)(d2 - RenderManager.field_78723_d)));
            GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
            float f2 = this.interpolateRotation(event.entity.field_70760_ar, event.entity.field_70761_aq, 0.0f);
            GL11.glRotatef((float)(180.0f - f2), (float)0.0f, (float)1.0f, (float)0.0f);
            if (event.entity.field_70725_aQ > 0) {
                float f3 = ((float)event.entity.field_70725_aQ + BattlegearClientTickHandeler.partialTick - 1.0f) / 20.0f * 1.6f;
                if ((f3 = MathHelper.func_76129_c((float)f3)) > 1.0f) {
                    f3 = 1.0f;
                }
                GL11.glRotatef((float)(-f3 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)-1.5f, (float)0.0f);
            GL11.glRotatef((float)event.entity.field_70125_A, (float)0.0f, (float)1.0f, (float)0.0f);
            ((ModelBiped)event.renderer.field_77045_g).field_78115_e.func_78794_c(0.0625f);
            GL11.glScalef((float)1.05f, (float)1.05f, (float)1.05f);
            this.quiverModel.render(5, 0.0625f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.quiverBase);
            GL11.glColor3f((float)0.1f, (float)0.1f, (float)0.1f);
            this.quiverModel.render(0, 0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
    }

    @ForgeSubscribe(priority=EventPriority.HIGHEST)
    public void replacePickBlock(MouseEvent event) {
        if (event.buttonstate && event.button - 100 == Minecraft.func_71410_x().field_71474_y.field_74322_I.field_74512_d) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            if (mc.field_71439_g != null && mc.field_71441_e != null) {
                boolean isCreative;
                ItemStack stack;
                event.setCanceled(true);
                if (!((IBattlePlayer)mc.field_71439_g).isBattlemode() && (stack = BattlegearClientEvents.getItemFromPointedAt(Minecraft.func_71410_x().field_71476_x, (World)mc.field_71441_e, isCreative = mc.field_71439_g.field_71075_bZ.field_75098_d)) != null) {
                    int k = -1;
                    for (int slot = 0; slot < MAIN_INV; ++slot) {
                        ItemStack temp = mc.field_71439_g.field_71071_by.func_70301_a(slot);
                        if (temp == null || !stack.func_77969_a(temp) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)temp)) continue;
                        k = slot;
                        break;
                    }
                    if (isCreative && k == -1 && ((k = mc.field_71439_g.field_71071_by.func_70447_i()) < 0 || k >= MAIN_INV)) {
                        k = mc.field_71439_g.field_71071_by.field_70461_c;
                    }
                    if (k >= 0 && k < MAIN_INV) {
                        PacketDispatcher.sendPacketToServer((Packet)new PickBlockPacket(mc.field_71439_g.field_71092_bJ, stack, k).generatePacket());
                    }
                }
            }
        }
    }

    private static ItemStack getItemFromPointedAt(MovingObjectPosition target, World world, boolean creative) {
        if (target != null) {
            if (target.field_72313_a == EnumMovingObjectType.TILE) {
                int x = target.field_72311_b;
                int y = target.field_72312_c;
                int z = target.field_72309_d;
                Block block = Block.field_71973_m[world.func_72798_a(x, y, z)];
                if (block == null) {
                    return null;
                }
                return block.getPickBlock(target, world, x, y, z);
            }
            if (target.field_72313_a != EnumMovingObjectType.ENTITY || target.field_72308_g == null || !creative) {
                return null;
            }
            return target.field_72308_g.getPickedResult(target);
        }
        return null;
    }

    private float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    @ForgeSubscribe
    public void preStitch(TextureStitchEvent.Pre event) {
        if (event.map.field_94255_a == 1) {
            ClientProxy.backgroundIcon = new Icon[2];
            ClientProxy.backgroundIcon[0] = event.map.func_94245_a("battlegear2:slots/mainhand");
            ClientProxy.backgroundIcon[1] = event.map.func_94245_a("battlegear2:slots/offhand");
            ClientProxy.bowIcons = new Icon[3];
            ClientProxy.bowIcons[0] = event.map.func_94245_a("battlegear2:bow_pulling_0");
            ClientProxy.bowIcons[1] = event.map.func_94245_a("battlegear2:bow_pulling_1");
            ClientProxy.bowIcons[2] = event.map.func_94245_a("battlegear2:bow_pulling_2");
            storageIndex = PatternStore.DEFAULT.buildPatternAndStore(patterns);
        }
    }

    @ForgeSubscribe
    public void onSoundLoad(SoundLoadEvent event) {
        try {
            for (int i = 0; i < 10; ++i) {
                event.manager.field_77379_b.func_77459_a(String.format("%s:%s%s.wav", "battlegear2", "shield", i));
            }
        }
        catch (Exception e) {
            Battlegear.logger.log(Level.WARNING, "Failed to register one or more sounds.");
        }
    }

    public static void onOpenGui(List buttons, int guiLeft, int guiTop) {
        if (BattlegearConfig.enableGuiButtons) {
            int count = 0;
            for (GuiPlaceableButton button : tabsList) {
                button.place(count, guiLeft, guiTop);
                button.field_73741_f = buttons.size() + 2;
                ++count;
                buttons.add(button);
            }
        }
    }

    static {
        tabsList = new ArrayList<GuiPlaceableButton>();
        tabsList.add(new GuiBGInventoryButton(0, 10, 10));
        tabsList.add(new GuiSigilButton(1, 20, 20));
        MAIN_INV = InventoryPlayer.func_70451_h();
    }
}

