/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.quiver;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mods.battlegear2.api.quiver.IArrowFireHandler;
import mods.battlegear2.api.quiver.IQuiverSelection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class QuiverArrowRegistry {
    private static Map<ItemStack, Class<? extends EntityArrow>> itemToClasses = new TreeMap<ItemStack, Class<? extends EntityArrow>>(new StackComparator());
    private static Map<Class<? extends EntityArrow>, ItemStack> classToItems = new HashMap<Class<? extends EntityArrow>, ItemStack>();
    private static List<IQuiverSelection> quiverSelectors = new ArrayList<IQuiverSelection>();
    private static List<IArrowFireHandler> fireHandlers = new ArrayList<IArrowFireHandler>();

    public static void addArrowToRegistry(int itemId, int itemMetadata, Class<? extends EntityArrow> entityArrow) {
        ItemStack stack = new ItemStack(itemId, 1, itemMetadata);
        QuiverArrowRegistry.addArrowToRegistry(stack, entityArrow);
    }

    public static void addArrowToRegistry(ItemStack stack, Class<? extends EntityArrow> entityArrow) {
        ItemStack st = stack.func_77946_l();
        st.field_77994_a = 1;
        itemToClasses.put(st, entityArrow);
        classToItems.put(entityArrow, st);
    }

    public static boolean addQuiverSelection(IQuiverSelection handler) {
        return quiverSelectors.add(handler);
    }

    public static boolean addArrowFireHandler(IArrowFireHandler handler) {
        return fireHandlers.add(handler);
    }

    public static ItemStack getArrowContainer(ItemStack bow, EntityPlayer entityPlayer) {
        for (IQuiverSelection handler : quiverSelectors) {
            ItemStack temp = handler.getQuiverFor(bow, entityPlayer);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public static EntityArrow getArrowType(ItemStack arrow, World world, EntityPlayer player, float charge) {
        for (IArrowFireHandler handler : fireHandlers) {
            EntityArrow result;
            if (!handler.canFireArrow(arrow, world, player, charge) || (result = handler.getFiredArrow(arrow, world, player, charge)) == null) continue;
            return result;
        }
        return null;
    }

    public static Class<? extends EntityArrow> getArrowClass(ItemStack stack) {
        return itemToClasses.get(stack);
    }

    public static ItemStack getItem(Class<? extends EntityArrow> clazz) {
        ItemStack temp = classToItems.get(clazz);
        if (temp == null) {
            return new ItemStack(Item.field_77704_l);
        }
        return temp.func_77946_l();
    }

    public static boolean isKnownArrow(ItemStack test) {
        return itemToClasses.containsKey(test);
    }

    static {
        fireHandlers.add(new DefaultArrowFire());
    }

    static class DefaultArrowFire
    implements IArrowFireHandler {
        DefaultArrowFire() {
        }

        @Override
        public boolean canFireArrow(ItemStack arrow, World world, EntityPlayer player, float charge) {
            return QuiverArrowRegistry.isKnownArrow(arrow);
        }

        @Override
        public EntityArrow getFiredArrow(ItemStack arrow, World world, EntityPlayer player, float charge) {
            Class<? extends EntityArrow> clazz = QuiverArrowRegistry.getArrowClass(arrow);
            if (clazz != null) {
                try {
                    return clazz.getConstructor(World.class, EntityLivingBase.class, Float.TYPE).newInstance(player.field_70170_p, player, Float.valueOf(charge));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    static class StackComparator
    implements Comparator<ItemStack> {
        StackComparator() {
        }

        @Override
        public int compare(ItemStack stack, ItemStack stack2) {
            if (stack == stack2) {
                return 0;
            }
            int idDiff = stack.field_77993_c - stack2.field_77993_c;
            if (idDiff != 0) {
                return idDiff;
            }
            idDiff = stack.func_77960_j() - stack2.func_77960_j();
            if (idDiff != 0) {
                return idDiff;
            }
            int tag = 0;
            if (stack.func_77942_o()) {
                tag = stack.func_77978_p().hashCode();
            }
            int tag2 = 0;
            if (stack2.func_77942_o()) {
                tag2 = stack2.func_77978_p().hashCode();
            }
            return tag - tag2;
        }
    }
}

