/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Cancelable;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public abstract class PlayerEventChild
extends PlayerEvent {
    public final PlayerEvent parent;

    public PlayerEventChild(PlayerEvent parent) {
        super(parent.entityPlayer);
        this.parent = parent;
    }

    public void setCancelParentEvent(boolean cancel) {
        this.parent.setCanceled(cancel);
    }

    public void setCanceled(boolean cancel) {
        super.setCanceled(cancel);
        this.parent.setCanceled(cancel);
    }

    public void setResult(Event.Result value) {
        super.setResult(value);
        this.parent.setResult(value);
    }

    public static class QuiverArrowEvent
    extends PlayerEventChild {
        protected final ArrowLooseEvent event;

        public QuiverArrowEvent(ArrowLooseEvent event) {
            super((PlayerEvent)event);
            this.event = event;
        }

        public EntityPlayer getArcher() {
            return this.event.entityPlayer;
        }

        public ItemStack getBow() {
            return this.event.bow;
        }

        public float getCharge() {
            return this.event.charge;
        }

        @Event.HasResult
        public static class ChargeCalculations
        extends QuiverArrowEvent {
            protected float charge;

            public ChargeCalculations(ArrowLooseEvent event) {
                super(event);
            }

            @Override
            public float getCharge() {
                MinecraftForge.EVENT_BUS.post((Event)this);
                switch (this.getResult()) {
                    case ALLOW: {
                        return this.charge;
                    }
                    case DENY: {
                        return 0.0f;
                    }
                }
                float f = super.getCharge() / 20.0f;
                f = (f * f + f * 2.0f) / 3.0f;
                if ((double)f < 0.1) {
                    return 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                return f;
            }

            public void setNewCharge(float charge) {
                this.setResult(Event.Result.ALLOW);
                this.charge = charge;
            }
        }

        @Cancelable
        public static class Firing
        extends QuiverArrowEvent {
            public int bowDamage = 1;
            public float bowSoundVolume = 1.0f;
            public boolean addEnchantments = true;
            public boolean isCritical = false;
            public final ItemStack quiver;
            public final EntityArrow arrow;

            public Firing(ArrowLooseEvent parent, ItemStack quiver, EntityArrow arrow) {
                super(parent);
                this.quiver = quiver;
                this.arrow = arrow;
            }
        }
    }

    @Cancelable
    public static class OffhandAttackEvent
    extends PlayerEventChild {
        public boolean swingOffhand = true;
        public boolean shouldAttack = true;
        public boolean cancelParent = true;
        public final EntityInteractEvent event;
        public final ItemStack mainHand;
        public final ItemStack offHand;

        public OffhandAttackEvent(EntityInteractEvent parent, ItemStack mainHand, ItemStack offHand) {
            super((PlayerEvent)parent);
            this.event = parent;
            this.mainHand = mainHand;
            this.offHand = offHand;
        }

        public Entity getTarget() {
            return this.event.target;
        }
    }

    @Cancelable
    public static class OffhandSwingEvent
    extends PlayerEventChild {
        public final ItemStack mainHand;
        public final ItemStack offHand;

        public OffhandSwingEvent(PlayerEvent parent, ItemStack mainHand, ItemStack offHand) {
            super(parent);
            this.mainHand = mainHand;
            this.offHand = offHand;
        }
    }

    public static class ShieldBlockEvent
    extends PlayerEventChild {
        public final ItemStack shield;
        public final DamageSource source;
        public final float ammount;
        public boolean performAnimation = true;
        public boolean damageShield = true;

        public ShieldBlockEvent(PlayerEvent parent, ItemStack shield, DamageSource source, float ammount) {
            super(parent);
            this.shield = shield;
            this.source = source;
            this.ammount = ammount;
        }
    }
}

