/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.IOffhandDual;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.shield.IArrowCatcher;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.api.weapons.IExtendedReachWeapon;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.packet.BattlegearShieldFlashPacket;
import mods.battlegear2.packet.BattlegearSyncItemPacket;
import mods.battlegear2.utils.EnumBGAnimations;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.network.packet.Packet;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.EventPriority;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BattlemodeHookContainerClass {
    @ForgeSubscribe(priority=EventPriority.LOWEST)
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer) {
            PacketDispatcher.sendPacketToPlayer((Packet)new BattlegearSyncItemPacket((EntityPlayer)event.entity).generatePacket(), (Player)((Player)event.entity));
        }
    }

    @ForgeSubscribe
    public void attackEntity(AttackEntityEvent event) {
        if (((IBattlePlayer)event.entityPlayer).getSpecialActionTimer() > 0) {
            event.setCanceled(true);
            return;
        }
        ItemStack mainhand = event.entityPlayer.func_71045_bC();
        float reachMod = 0.0f;
        if (mainhand == null) {
            reachMod = -2.2f;
        } else if (mainhand.func_77973_b() instanceof ItemBlock) {
            reachMod = -2.1f;
        } else if (mainhand.func_77973_b() instanceof IExtendedReachWeapon) {
            reachMod = ((IExtendedReachWeapon)mainhand.func_77973_b()).getReachModifierInBlocks(mainhand);
        }
        if (reachMod < 0.0f && reachMod + 4.0f < event.entityPlayer.func_70032_d(event.target)) {
            event.setCanceled(true);
        }
    }

    @ForgeSubscribe
    public void playerInterect(PlayerInteractEvent event) {
        if (((IBattlePlayer)event.entityPlayer).getSpecialActionTimer() > 0) {
            event.setCanceled(true);
            event.entityPlayer.field_82175_bq = false;
        } else if (((IBattlePlayer)event.entityPlayer).isBattlemode()) {
            ItemStack mainHandItem = event.entityPlayer.func_71045_bC();
            ItemStack offhandItem = ((InventoryPlayerBattle)event.entityPlayer.field_71071_by).getCurrentOffhandWeapon();
            switch (event.action) {
                case LEFT_CLICK_BLOCK: {
                    break;
                }
                case RIGHT_CLICK_BLOCK: {
                    BattlemodeHookContainerClass.sendOffSwingEvent((PlayerEvent)event, mainHandItem, offhandItem);
                    break;
                }
                case RIGHT_CLICK_AIR: {
                    if (mainHandItem != null && !BattlegearUtils.isMainHand(mainHandItem, offhandItem)) break;
                    event.setCanceled(true);
                    BattlemodeHookContainerClass.sendOffSwingEvent((PlayerEvent)event, mainHandItem, offhandItem);
                }
            }
        }
    }

    private static void sendOffSwingEvent(PlayerEvent event, ItemStack mainHandItem, ItemStack offhandItem) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new PlayerEventChild.OffhandSwingEvent(event, mainHandItem, offhandItem))) {
            ((IBattlePlayer)event.entityPlayer).swingOffItem();
            Battlegear.proxy.sendAnimationPacket(EnumBGAnimations.OffHandSwing, event.entityPlayer);
        }
    }

    @ForgeSubscribe(priority=EventPriority.HIGHEST)
    public void onOffhandSwing(PlayerEventChild.OffhandSwingEvent event) {
        if (event.offHand != null && event.parent.getClass().equals(PlayerInteractEvent.class)) {
            if (event.offHand.func_77973_b() instanceof IShield) {
                ((PlayerInteractEvent)event.parent).useItem = Event.Result.DENY;
                event.setCanceled(true);
            } else if (event.offHand.func_77973_b() instanceof IOffhandDual) {
                boolean shouldSwing = true;
                if (((PlayerInteractEvent)event.parent).action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                    shouldSwing = ((IOffhandDual)event.offHand.func_77973_b()).offhandClickAir((PlayerInteractEvent)event.parent, event.mainHand, event.offHand);
                } else if (((PlayerInteractEvent)event.parent).action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                    ((PlayerInteractEvent)event.parent).useItem = Event.Result.DENY;
                    shouldSwing = ((IOffhandDual)event.offHand.func_77973_b()).offhandClickBlock((PlayerInteractEvent)event.parent, event.mainHand, event.offHand);
                }
                if (!shouldSwing) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @ForgeSubscribe
    public void playerIntereactEntity(EntityInteractEvent event) {
        if (((IBattlePlayer)event.entityPlayer).getSpecialActionTimer() > 0) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            event.entityPlayer.field_82175_bq = false;
        } else if (((IBattlePlayer)event.entityPlayer).isBattlemode()) {
            PlayerEventChild.OffhandAttackEvent offAttackEvent;
            ItemStack mainHandItem = event.entityPlayer.func_71045_bC();
            ItemStack offhandItem = ((InventoryPlayerBattle)event.entityPlayer.field_71071_by).getCurrentOffhandWeapon();
            if ((mainHandItem == null || BattlegearUtils.isMainHand(mainHandItem, offhandItem)) && !MinecraftForge.EVENT_BUS.post((Event)(offAttackEvent = new PlayerEventChild.OffhandAttackEvent(event, mainHandItem, offhandItem)))) {
                if (offAttackEvent.swingOffhand) {
                    BattlemodeHookContainerClass.sendOffSwingEvent((PlayerEvent)event, mainHandItem, offhandItem);
                }
                if (offAttackEvent.shouldAttack) {
                    ((IBattlePlayer)event.entityPlayer).attackTargetEntityWithCurrentOffItem(event.target);
                }
                if (offAttackEvent.cancelParent) {
                    event.setCanceled(true);
                    event.setResult(Event.Result.DENY);
                }
            }
        }
    }

    @ForgeSubscribe(priority=EventPriority.HIGHEST)
    public void onOffhandAttack(PlayerEventChild.OffhandAttackEvent event) {
        if (event.offHand != null) {
            if (event.offHand.func_77973_b() instanceof IOffhandDual) {
                event.swingOffhand = ((IOffhandDual)event.offHand.func_77973_b()).offhandAttackEntity(event, event.mainHand, event.offHand);
            } else if (event.offHand.func_77973_b() instanceof IShield) {
                event.swingOffhand = false;
                event.shouldAttack = false;
            } else if (event.offHand.func_77973_b() instanceof IArrowContainer2) {
                event.shouldAttack = false;
            }
        }
    }

    @ForgeSubscribe
    public void shieldHook(LivingHurtEvent event) {
        if (event.entity instanceof IBattlePlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (((IBattlePlayer)player).getSpecialActionTimer() > 0) {
                event.setCanceled(true);
            } else if (((IBattlePlayer)player).isBlockingWithShield()) {
                ItemStack shield = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
                float dmg = event.ammount;
                if (((IShield)shield.func_77973_b()).canBlock(shield, event.source)) {
                    boolean shouldBlock = true;
                    Entity opponent = event.source.func_76346_g();
                    if (opponent != null) {
                        double d0 = opponent.field_70165_t - event.entity.field_70165_t;
                        double d1 = opponent.field_70161_v - player.field_70161_v;
                        while (d0 * d0 + d1 * d1 < 1.0E-4) {
                            d0 = (Math.random() - Math.random()) * 0.01;
                            d1 = (Math.random() - Math.random()) * 0.01;
                        }
                        float yaw = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - player.field_70177_z;
                        yaw -= 90.0f;
                        while (yaw < -180.0f) {
                            yaw += 360.0f;
                        }
                        while (yaw >= 180.0f) {
                            yaw -= 360.0f;
                        }
                        float blockAngle = ((IShield)shield.func_77973_b()).getBlockAngle(shield);
                        boolean bl = shouldBlock = yaw < blockAngle && yaw > -blockAngle;
                    }
                    if (shouldBlock) {
                        float red;
                        event.setCanceled(true);
                        PlayerEventChild.ShieldBlockEvent blockEvent = new PlayerEventChild.ShieldBlockEvent(new PlayerEvent(player), shield, event.source, dmg);
                        MinecraftForge.EVENT_BUS.post((Event)blockEvent);
                        if (blockEvent.performAnimation) {
                            PacketDispatcher.sendPacketToAllAround((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)32.0, (int)player.field_71093_bK, (Packet)new BattlegearShieldFlashPacket(player, dmg).generatePacket());
                            ((IShield)shield.func_77973_b()).blockAnimation(player, dmg);
                        }
                        if (event.source.func_76352_a() && event.source.func_76364_f() instanceof IProjectile && shield.func_77973_b() instanceof IArrowCatcher && ((IArrowCatcher)shield.func_77973_b()).catchArrow(shield, player, (IProjectile)event.source.func_76364_f())) {
                            ((InventoryPlayerBattle)player.field_71071_by).hasChanged = true;
                        }
                        if (blockEvent.damageShield && !player.field_71075_bZ.field_75098_d && (red = ((IShield)shield.func_77973_b()).getDamageReduction(shield, event.source)) < dmg) {
                            shield.func_77972_a(Math.round(dmg - red), (EntityLivingBase)player);
                            if (shield.func_77960_j() <= 0) {
                                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)shield);
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c + 3, null);
                            }
                            ((InventoryPlayerBattle)player.field_71071_by).hasChanged = true;
                        }
                    }
                }
            }
        }
    }

    @ForgeSubscribe
    public void onDrop(LivingDropsEvent event) {
        int lvl;
        ItemStack stack;
        if (event.source.func_76346_g() instanceof EntityLivingBase && (stack = ((EntityLivingBase)event.source.func_76346_g()).func_71124_b(0)) != null && stack.func_77973_b() instanceof ItemBow && (lvl = EnchantmentHelper.func_77506_a((int)BaseEnchantment.bowLoot.field_77352_x, (ItemStack)stack)) > 0) {
            for (EntityItem items : event.drops) {
                ItemStack drop = items.func_92059_d();
                if (drop == null || drop.func_77976_d() >= drop.field_77994_a + lvl) continue;
                drop.field_77994_a += lvl;
                items.func_92058_a(drop);
            }
        }
    }
}

