/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.packet;

import io.netty.buffer.ByteBuf;
import mods.battlegear2.Battlegear;
import mods.battlegear2.BattlemodeHookContainerClass;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.packet.AbstractMBPacket;
import mods.battlegear2.packet.BattlegearSyncItemPacket;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public final class OffhandPlaceBlockPacket
extends AbstractMBPacket {
    public static final String packetName = "MB2|Place";
    private int xPosition;
    private int yPosition;
    private int zPosition;
    private int direction;
    private ItemStack itemStack;
    private float xOffset;
    private float yOffset;
    private float zOffset;

    public OffhandPlaceBlockPacket() {
    }

    public OffhandPlaceBlockPacket(ItemStack itemStack) {
        this(-1, -1, -1, 255, itemStack, 0.0f, 0.0f, 0.0f);
    }

    public OffhandPlaceBlockPacket(BlockPos pos, EnumFacing face, ItemStack par5ItemStack, float par6, float par7, float par8) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), face.func_176745_a(), par5ItemStack, par6, par7, par8);
    }

    private OffhandPlaceBlockPacket(int par1, int par2, int par3, int par4, ItemStack par5ItemStack, float par6, float par7, float par8) {
        this.xPosition = par1;
        this.yPosition = par2;
        this.zPosition = par3;
        this.direction = par4;
        this.itemStack = ItemStack.func_77944_b((ItemStack)par5ItemStack);
        this.xOffset = par6;
        this.yOffset = par7;
        this.zOffset = par8;
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void write(ByteBuf out) {
        out.writeInt(this.xPosition);
        out.writeByte(this.yPosition);
        out.writeInt(this.zPosition);
        out.writeByte(this.direction);
        ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.itemStack);
        out.writeByte((int)(this.xOffset * 16.0f));
        out.writeByte((int)(this.yOffset * 16.0f));
        out.writeByte((int)(this.zOffset * 16.0f));
    }

    @Override
    public void process(ByteBuf in, EntityPlayer player) {
        try {
            this.xPosition = in.readInt();
            this.yPosition = in.readUnsignedByte();
            this.zPosition = in.readInt();
            this.direction = in.readUnsignedByte();
            this.itemStack = ByteBufUtils.readItemStack((ByteBuf)in);
            this.xOffset = (float)in.readUnsignedByte() / 16.0f;
            this.yOffset = (float)in.readUnsignedByte() / 16.0f;
            this.zOffset = (float)in.readUnsignedByte() / 16.0f;
        }
        catch (Exception io) {
            return;
        }
        if (player == null || !(player instanceof EntityPlayerMP) || !BattlegearUtils.isPlayerInBattlemode(player)) {
            return;
        }
        ItemStack offhandWeapon = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
        boolean placeResult = true;
        BlockPos pos = new BlockPos(this.xPosition, this.yPosition, this.zPosition);
        EnumFacing l = EnumFacing.func_82600_a((int)this.direction);
        ((EntityPlayerMP)player).func_143004_u();
        if (this.direction == 255) {
            if (offhandWeapon == null) {
                return;
            }
            PlayerInteractEvent event = new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_AIR, new BlockPos(0, 0, 0), null, player.func_130014_f_());
            MinecraftForge.EVENT_BUS.post((Event)new PlayerEventChild.UseOffhandItemEvent(event, offhandWeapon));
            if (event.useItem != Event.Result.DENY && ((EntityPlayerMP)player).field_71134_c.func_73081_b() != WorldSettings.GameType.SPECTATOR) {
                BattlegearUtils.refreshAttributes(player);
                BattlemodeHookContainerClass.tryUseItem(player, offhandWeapon, Side.SERVER);
                BattlegearUtils.refreshAttributes(player);
            }
        } else {
            MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (this.yPosition >= mcServer.func_71207_Z() - 1 && (l == EnumFacing.UP || this.yPosition >= mcServer.func_71207_Z())) {
                ChatComponentTranslation chat = new ChatComponentTranslation("build.tooHigh", new Object[]{mcServer.func_71207_Z()});
                chat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S02PacketChat((IChatComponent)chat));
            } else {
                double dist = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance() + 1.0;
                dist *= dist;
                if (((EntityPlayerMP)player).field_71135_a.field_147380_r && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) < dist && !mcServer.func_175579_a(player.func_130014_f_(), pos, player) && player.func_130014_f_().func_175723_af().func_177746_a(pos)) {
                    placeResult = this.activateBlockOrUseItem((EntityPlayerMP)player, offhandWeapon, pos, l, this.xOffset, this.yOffset, this.zOffset);
                }
            }
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(player.func_130014_f_(), pos));
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(player.func_130014_f_(), pos.func_177972_a(l)));
        }
        offhandWeapon = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
        if (offhandWeapon != null && offhandWeapon.field_77994_a <= 0) {
            BattlegearUtils.setPlayerOffhandItem(player, null);
            offhandWeapon = null;
        }
        if (offhandWeapon == null || offhandWeapon.func_77988_m() == 0) {
            ((EntityPlayerMP)player).field_71137_h = true;
            BattlegearUtils.setPlayerOffhandItem(player, ItemStack.func_77944_b((ItemStack)((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon()));
            player.field_71070_bA.func_75142_b();
            ((EntityPlayerMP)player).field_71137_h = false;
            if (!ItemStack.func_77989_b((ItemStack)((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon(), (ItemStack)this.itemStack) || !placeResult) {
                Battlegear.packetHandler.sendPacketToPlayer(new BattlegearSyncItemPacket(player).generatePacket(), (EntityPlayerMP)player);
            }
        }
    }

    public boolean activateBlockOrUseItem(EntityPlayerMP playerMP, ItemStack itemStack, BlockPos pos, EnumFacing side, float xOffset, float yOffset, float zOffset) {
        boolean useBlock;
        World theWorld = playerMP.func_130014_f_();
        if (playerMP.field_71134_c.func_73081_b() == WorldSettings.GameType.SPECTATOR) {
            return playerMP.field_71134_c.func_180236_a((EntityPlayer)playerMP, theWorld, itemStack, pos, side, xOffset, yOffset, zOffset);
        }
        PlayerInteractEvent event = new PlayerInteractEvent((EntityPlayer)playerMP, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, pos, side, theWorld);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerEventChild.UseOffhandItemEvent(event, itemStack));
        if (event.isCanceled()) {
            playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(theWorld, pos));
            return false;
        }
        BattlegearUtils.refreshAttributes((EntityPlayer)playerMP);
        if (itemStack != null && itemStack.func_77973_b().onItemUseFirst(itemStack, (EntityPlayer)playerMP, theWorld, pos, side, xOffset, yOffset, zOffset)) {
            if (itemStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)playerMP, (ItemStack)itemStack);
            }
            BattlegearUtils.refreshAttributes((EntityPlayer)playerMP);
            return true;
        }
        boolean bl = useBlock = !playerMP.func_70093_af() || playerMP.func_70694_bm() == null;
        if (!useBlock) {
            useBlock = playerMP.func_70694_bm().func_77973_b().doesSneakBypassUse(theWorld, pos, (EntityPlayer)playerMP);
        }
        boolean result = false;
        if (useBlock) {
            if (event.useBlock != Event.Result.DENY) {
                IBlockState state = theWorld.func_180495_p(pos);
                result = state.func_177230_c().func_180639_a(theWorld, pos, state, (EntityPlayer)playerMP, side, xOffset, yOffset, zOffset);
            } else {
                playerMP.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(theWorld, pos));
                boolean bl2 = result = event.useItem != Event.Result.ALLOW;
            }
        }
        if (itemStack != null && !result && event.useItem != Event.Result.DENY) {
            int meta = itemStack.func_77960_j();
            int size = itemStack.field_77994_a;
            result = itemStack.func_179546_a((EntityPlayer)playerMP, theWorld, pos, side, xOffset, yOffset, zOffset);
            if (playerMP.field_71134_c.func_73083_d()) {
                itemStack.func_77964_b(meta);
                itemStack.field_77994_a = size;
            }
            if (itemStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)playerMP, (ItemStack)itemStack);
            }
        }
        BattlegearUtils.refreshAttributes((EntityPlayer)playerMP);
        return result;
    }
}

