/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.packet;

import io.netty.buffer.ByteBuf;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.packet.AbstractMBPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class BattlegearSyncItemPacket
extends AbstractMBPacket {
    public static final String packetName = "MB2|SyncItem";
    private String user;
    private InventoryPlayer inventory;
    private EntityPlayer player;

    public BattlegearSyncItemPacket(EntityPlayer player) {
        this(player.func_70005_c_(), player.field_71071_by, player);
    }

    private BattlegearSyncItemPacket(String user, InventoryPlayer inventory, EntityPlayer player) {
        this.user = user;
        this.inventory = inventory;
        this.player = player;
    }

    public BattlegearSyncItemPacket() {
    }

    @Override
    public void process(ByteBuf inputStream, EntityPlayer player) {
        this.user = ByteBufUtils.readUTF8String((ByteBuf)inputStream);
        this.player = player.field_70170_p.func_72924_a(this.user);
        if (this.player != null) {
            int current = inputStream.readInt();
            if (InventoryPlayerBattle.isValidSwitch(current)) {
                this.player.field_71071_by.field_70461_c = current;
            }
            if (player.field_70170_p.field_72995_K) {
                int previous;
                int length;
                ItemStack temp = ByteBufUtils.readItemStack((ByteBuf)inputStream);
                if (!ItemStack.func_77989_b((ItemStack)this.player.func_71045_bC(), (ItemStack)temp)) {
                    BattlegearUtils.setPlayerCurrentItem(this.player, temp);
                }
                if ((length = inputStream.readInt()) != (previous = ((InventoryPlayerBattle)this.player.field_71071_by).extraItems.length)) {
                    if (previous > length) {
                        previous = length;
                    }
                    ItemStack[] change = new ItemStack[length];
                    System.arraycopy(((InventoryPlayerBattle)this.player.field_71071_by).extraItems, 0, change, 0, previous);
                    ((InventoryPlayerBattle)this.player.field_71071_by).extraItems = change;
                    ((InventoryPlayerBattle)this.player.field_71071_by).resizeExtra();
                }
                for (int i = 0; i < length; ++i) {
                    ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)inputStream);
                    if (ItemStack.func_77989_b((ItemStack)this.player.field_71071_by.func_70301_a(InventoryPlayerBattle.OFFSET + i), (ItemStack)stack)) continue;
                    ((InventoryPlayerBattle)this.player.field_71071_by).setInventorySlotContents(InventoryPlayerBattle.OFFSET + i, stack, false);
                }
            } else if (BattlegearUtils.isPlayerInBattlemode(this.player)) {
                ItemStack inUse = ByteBufUtils.readItemStack((ByteBuf)inputStream);
                int time = inputStream.readInt();
                if (inUse != null && time > 0) {
                    this.player.func_71008_a(inUse, time);
                }
            }
            ((IBattlePlayer)this.player).setSpecialActionTimer(0);
        }
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void write(ByteBuf out) {
        ByteBufUtils.writeUTF8String((ByteBuf)out, (String)this.user);
        out.writeInt(this.inventory.field_70461_c);
        if (!this.player.field_70170_p.field_72995_K) {
            ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.inventory.func_70448_g());
            int max = ((InventoryPlayerBattle)this.player.field_71071_by).extraItems.length;
            out.writeInt(max);
            for (int i = 0; i < max; ++i) {
                ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.inventory.func_70301_a(i + InventoryPlayerBattle.OFFSET));
            }
        } else if (BattlegearUtils.isPlayerInBattlemode(this.player)) {
            ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)this.player.func_71011_bu());
            out.writeInt(this.player.func_71052_bv());
        }
    }
}

