/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.enchantments;

import com.google.common.base.Optional;
import mods.battlegear2.api.EnchantmentHelper;
import mods.battlegear2.api.IEnchantable;
import mods.battlegear2.api.core.BattlegearUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;

public class BaseEnchantment
extends Enchantment {
    private int max;
    private int enchantCoeff;
    private int range;
    public static Optional<Enchantment> bashWeight;
    public static Optional<Enchantment> bashPower;
    public static Optional<Enchantment> bashDamage;
    public static Optional<Enchantment> shieldUsage;
    public static Optional<Enchantment> shieldRecover;
    public static Optional<Enchantment> bowLoot;
    public static Optional<Enchantment> bowCharge;
    public static EnchantmentHelper helper;

    public BaseEnchantment(int id, String name, int weight, int limit, int progress, int range) {
        super(id, new ResourceLocation("battlegear2:" + name), weight, EnumEnchantmentType.ALL);
        this.max = limit > 1 ? limit : 1;
        this.enchantCoeff = progress > 1 ? progress : 1;
        this.range = range > 0 ? range : 0;
    }

    public BaseEnchantment(int id, String name, int weight, EnumEnchantmentType type, int coeff, int rng) {
        super(id, new ResourceLocation("battlegear2:" + name), weight, type);
        this.max = 1;
        this.enchantCoeff = coeff > 1 ? coeff : 1;
        this.range = this.range > 0 ? rng : 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        if (stack.func_77973_b() instanceof IEnchantable) {
            return ((IEnchantable)stack.func_77973_b()).isEnchantable(this, stack);
        }
        if (this.field_77351_y == EnumEnchantmentType.BOW && BattlegearUtils.isBow(stack.func_77973_b())) {
            return true;
        }
        return this.field_77351_y != EnumEnchantmentType.ALL && super.canApplyAtEnchantingTable(stack);
    }

    public int func_77325_b() {
        return this.max;
    }

    public boolean func_77326_a(Enchantment par1Enchantment) {
        return super.func_77326_a(par1Enchantment) && par1Enchantment.field_77352_x != this.field_77352_x;
    }

    public int func_77321_a(int par1) {
        return 1 + par1 * this.enchantCoeff;
    }

    public int func_77317_b(int par1) {
        return this.func_77321_a(par1) + this.range;
    }

    public static void initBase(Property ... props) {
        bashWeight = EnchantmentHelper.build(props[0], "bash.weightless", BaseEnchantment.class, "bash_weightless", 5, 3, 15, 30);
        bashPower = EnchantmentHelper.build(props[1], "bash.power", BaseEnchantment.class, "bash_power", 10, 5, 10, 40);
        bashDamage = EnchantmentHelper.build(props[2], "bash.damage", BaseEnchantment.class, "bash_damage", 1, 3, 15, 50);
        shieldUsage = EnchantmentHelper.build(props[3], "shield.usage", BaseEnchantment.class, "shield_efficiency", 2, 5, 5, 30);
        shieldRecover = EnchantmentHelper.build(props[4], "shield.recover", BaseEnchantment.class, "shield_recovery", 3, 4, 20, 20);
        bowLoot = EnchantmentHelper.build(props[5], "bow.loot", BaseEnchantment.class, "bow_luck", 2, EnumEnchantmentType.BOW, 10, 50);
        bowCharge = EnchantmentHelper.build(props[6], "bow.charge", BaseEnchantment.class, "bow_drawnback", 1, EnumEnchantmentType.BOW, 20, 20);
    }

    public Enchantment func_77322_b(String name) {
        super.func_77322_b(name);
        if (helper.addEnchantment(this)) {
            BaseEnchantment.addToBookList((Enchantment)this);
        }
        return this;
    }

    static {
        helper = new EnchantmentHelper();
    }
}

