/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mods.battlegear2.Battlegear;
import mods.battlegear2.BattlemodeHookContainerClass;
import mods.battlegear2.api.EnchantmentHelper;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.IOffhandRender;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.client.renderer.LayerOffhandItem;
import mods.battlegear2.client.renderer.LayerQuiver;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.packet.BattlegearAnimationPacket;
import mods.battlegear2.packet.BattlegearShieldBlockPacket;
import mods.battlegear2.packet.OffhandPlaceBlockPacket;
import mods.battlegear2.packet.ReachTargetPacket;
import mods.battlegear2.utils.BattlegearConfig;
import mods.battlegear2.utils.EnumBGAnimations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public final class BattlegearClientTickHandeler {
    private static final int FLASH_MAX = 30;
    private final KeyBinding drawWeapons;
    private final KeyBinding special;
    private final Minecraft mc;
    private float blockBar = 1.0f;
    private float partialTick;
    private boolean wasBlocking = false;
    private int previousBattlemode = InventoryPlayerBattle.OFFSET;
    private int previousNormal = 0;
    private int flashTimer;
    private boolean specialDone = false;
    private boolean drawDone = false;
    private boolean inBattle = false;
    private List<RenderPlayer> renderPlayer = new ArrayList<RenderPlayer>();
    public static final BattlegearClientTickHandeler INSTANCE = new BattlegearClientTickHandeler();

    private BattlegearClientTickHandeler() {
        this.drawWeapons = new KeyBinding("key.drawWeapons", 19, "key.categories.gameplay");
        this.special = new KeyBinding("key.special", 44, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyBinding)this.drawWeapons);
        ClientRegistry.registerKeyBinding((KeyBinding)this.special);
        this.mc = FMLClientHandler.instance().getClient();
    }

    @SubscribeEvent
    public void keyDown(TickEvent.ClientTickEvent event) {
        if (Battlegear.battlegearEnabled && this.mc.field_71439_g != null && this.mc.field_71441_e != null && this.mc.field_71462_r == null) {
            EntityPlayerSP player = this.mc.field_71439_g;
            if (event.phase == TickEvent.Phase.START) {
                if (!this.specialDone && this.special.func_151470_d() && ((IBattlePlayer)player).getSpecialActionTimer() == 0) {
                    float shieldBashPenalty;
                    ItemStack offhand;
                    ItemStack quiver = QuiverArrowRegistry.getArrowContainer((EntityPlayer)player);
                    if (quiver != null) {
                        FMLProxyPacket p = new BattlegearAnimationPacket(EnumBGAnimations.SpecialAction, (EntityPlayer)player).generatePacket();
                        Battlegear.packetHandler.sendPacketToServer(p);
                        ((IBattlePlayer)player).setSpecialActionTimer(2);
                    } else if (((IBattlePlayer)player).isBattlemode() && (offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon()) != null && offhand.func_77973_b() instanceof IShield && this.blockBar >= (shieldBashPenalty = 0.33f - 0.06f * (float)EnchantmentHelper.getEnchantmentLevel(BaseEnchantment.bashWeight, offhand))) {
                        FMLProxyPacket p = new BattlegearAnimationPacket(EnumBGAnimations.SpecialAction, (EntityPlayer)player).generatePacket();
                        Battlegear.packetHandler.sendPacketToServer(p);
                        ((IBattlePlayer)player).setSpecialActionTimer(((IShield)offhand.func_77973_b()).getBashTimer(offhand));
                        this.blockBar -= shieldBashPenalty;
                    }
                    this.specialDone = true;
                } else if (this.specialDone && !this.special.func_151470_d()) {
                    this.specialDone = false;
                }
                if (!this.drawDone && this.drawWeapons.func_151470_d()) {
                    if (((IBattlePlayer)player).isBattlemode()) {
                        this.previousBattlemode = player.field_71071_by.field_70461_c;
                        player.field_71071_by.field_70461_c = this.previousNormal;
                    } else {
                        this.previousNormal = player.field_71071_by.field_70461_c;
                        player.field_71071_by.field_70461_c = this.previousBattlemode;
                    }
                    this.mc.field_71442_b.func_78750_j();
                    this.drawDone = true;
                } else if (this.drawDone && !this.drawWeapons.func_151470_d()) {
                    this.drawDone = false;
                }
                this.inBattle = ((IBattlePlayer)player).isBattlemode();
            } else if (this.inBattle && !((IBattlePlayer)player).isBattlemode()) {
                for (int i = 0; i < InventoryPlayerBattle.WEAPON_SETS; ++i) {
                    if (!this.mc.field_71474_y.field_151456_ac[i].func_151470_d()) continue;
                    this.previousBattlemode = InventoryPlayerBattle.OFFSET + i;
                }
                player.field_71071_by.field_70461_c = this.previousBattlemode;
                this.mc.field_71442_b.func_78750_j();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == this.mc.field_71439_g) {
            if (event.phase == TickEvent.Phase.START) {
                this.tickStart((EntityPlayer)this.mc.field_71439_g);
            } else {
                this.tickEnd((EntityPlayer)this.mc.field_71439_g);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        Battlegear.battlegearEnabled = false;
    }

    public void tickStart(EntityPlayer player) {
        ItemStack offhand;
        if (this.renderPlayer.isEmpty()) {
            try {
                Map map = (Map)ObfuscationReflectionHelper.getPrivateValue(RenderManager.class, (Object)this.mc.func_175598_ae(), (String[])new String[]{"skinMap", "field_178636_l"});
                this.renderPlayer.addAll(map.values());
                for (RenderPlayer render : this.renderPlayer) {
                    render.field_177097_h.add(new LayerOffhandItem(render));
                    if (!BattlegearConfig.hasRender("quiver")) continue;
                    render.field_177097_h.add(new LayerQuiver(render));
                }
            }
            catch (Throwable map) {
                // empty catch block
            }
        }
        if (((IBattlePlayer)player).isBattlemode() && (offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon()) != null) {
            if (offhand.func_77973_b() instanceof IShield) {
                if (this.flashTimer == 30) {
                    player.field_70181_x /= 2.0;
                }
                if (this.flashTimer > 0) {
                    --this.flashTimer;
                }
                if (this.mc.field_71474_y.field_74313_G.func_151470_d() && !player.field_82175_bq) {
                    this.blockBar -= ((IShield)offhand.func_77973_b()).getDecayRate(offhand);
                    if (this.blockBar > 0.0f) {
                        if (!this.wasBlocking) {
                            Battlegear.packetHandler.sendPacketToServer(new BattlegearShieldBlockPacket(true, player).generatePacket());
                        }
                        this.wasBlocking = true;
                    } else {
                        if (this.wasBlocking) {
                            Battlegear.packetHandler.sendPacketToServer(new BattlegearShieldBlockPacket(false, player).generatePacket());
                        }
                        this.wasBlocking = false;
                        this.blockBar = 0.0f;
                    }
                } else {
                    if (this.wasBlocking) {
                        Battlegear.packetHandler.sendPacketToServer(new BattlegearShieldBlockPacket(false, player).generatePacket());
                    }
                    this.wasBlocking = false;
                    this.blockBar += ((IShield)offhand.func_77973_b()).getRecoveryRate(offhand);
                    if (this.blockBar > 1.0f) {
                        this.blockBar = 1.0f;
                    }
                }
            } else if (this.mc.field_71474_y.field_74313_G.func_151470_d() && this.mc.field_71467_ac == 4 && !player.func_71039_bw()) {
                this.tryCheckUseItem(offhand, player);
            }
        }
    }

    public void tryCheckUseItem(ItemStack offhand, EntityPlayer player) {
        BlockPos pos;
        MovingObjectPosition mouseOver = this.mc.field_71476_x;
        boolean flag = true;
        if (mouseOver != null && mouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !player.field_70170_p.func_180495_p(pos = mouseOver.func_178782_a()).func_177230_c().isAir((IBlockAccess)player.field_70170_p, pos)) {
            int size = offhand.field_77994_a;
            EnumFacing i1 = mouseOver.field_178784_b;
            PlayerEventChild.UseOffhandItemEvent useItemEvent = new PlayerEventChild.UseOffhandItemEvent(new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, pos, i1, player.field_70170_p), offhand);
            if (!MinecraftForge.EVENT_BUS.post((Event)useItemEvent)) {
                BattlegearUtils.refreshAttributes(player);
                boolean result = this.onPlayerPlaceBlock(this.mc.field_71442_b, player, useItemEvent.offhand, pos, i1, mouseOver.field_72307_f);
                BattlegearUtils.refreshAttributes(player);
                if (result) {
                    if (useItemEvent.swingOffhand) {
                        BattlegearUtils.sendOffSwingEvent((PlayerEvent)useItemEvent.event, useItemEvent.offhand);
                    }
                    flag = false;
                }
            }
            if (useItemEvent.offhand.field_77994_a == 0) {
                BattlegearUtils.setPlayerOffhandItem(player, null);
            } else if (useItemEvent.offhand.field_77994_a != size || this.mc.field_71442_b.func_78758_h()) {
                ((IOffhandRender)this.mc.field_71460_t.field_78516_c).setEquippedProgress(0.0f);
            }
        }
        if (flag) {
            offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
            PlayerEventChild.UseOffhandItemEvent useItemEvent = new PlayerEventChild.UseOffhandItemEvent(new PlayerInteractEvent(player, PlayerInteractEvent.Action.RIGHT_CLICK_AIR, new BlockPos(0, 0, 0), null, player.field_70170_p), offhand);
            if (offhand != null && !MinecraftForge.EVENT_BUS.post((Event)useItemEvent) && !this.mc.field_71442_b.func_178887_k()) {
                Battlegear.packetHandler.sendPacketToServer(new OffhandPlaceBlockPacket(useItemEvent.offhand).generatePacket());
                if (useItemEvent.event.useItem != Event.Result.DENY) {
                    BattlegearUtils.refreshAttributes(player);
                    flag = BattlemodeHookContainerClass.tryUseItem(player, useItemEvent.offhand, Side.CLIENT);
                    BattlegearUtils.refreshAttributes(player);
                }
                if (flag) {
                    if (useItemEvent.swingOffhand) {
                        BattlegearUtils.sendOffSwingEvent((PlayerEvent)useItemEvent.event, useItemEvent.offhand);
                    }
                    ((IOffhandRender)this.mc.field_71460_t.field_78516_c).setEquippedProgress(0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.partialTick = event.renderTickTime;
            if (this.mc.field_71462_r instanceof GuiMainMenu) {
                Battlegear.battlegearEnabled = false;
                if (!this.renderPlayer.isEmpty()) {
                    for (RenderPlayer render : this.renderPlayer) {
                        Iterator iterator = render.field_177097_h.iterator();
                        while (iterator.hasNext()) {
                            Object object = iterator.next();
                            if (!(object instanceof LayerOffhandItem) && !(object instanceof LayerQuiver)) continue;
                            iterator.remove();
                        }
                    }
                    this.renderPlayer.clear();
                }
            }
        }
    }

    private boolean onPlayerPlaceBlock(PlayerControllerMP controller, EntityPlayer player, ItemStack offhand, BlockPos pos, EnumFacing l, Vec3 hitVec) {
        World worldObj = player.field_70170_p;
        if (!worldObj.func_175723_af().func_177746_a(pos)) {
            return false;
        }
        float f = (float)hitVec.field_72450_a - (float)pos.func_177958_n();
        float f1 = (float)hitVec.field_72448_b - (float)pos.func_177956_o();
        float f2 = (float)hitVec.field_72449_c - (float)pos.func_177952_p();
        boolean flag = false;
        if (!controller.func_178887_k()) {
            ItemBlock itemblock;
            IBlockState b;
            if (offhand.func_77973_b().onItemUseFirst(offhand, player, worldObj, pos, l, f, f1, f2)) {
                return true;
            }
            if ((!player.func_70093_af() || player.func_71045_bC() == null || player.func_71045_bC().func_77973_b().doesSneakBypassUse(worldObj, pos, player)) && !(b = worldObj.func_180495_p(pos)).func_177230_c().isAir((IBlockAccess)worldObj, pos) && b.func_177230_c().func_180639_a(worldObj, pos, b, player, l, f, f1, f2)) {
                flag = true;
            }
            if (!flag && offhand.func_77973_b() instanceof ItemBlock && !(itemblock = (ItemBlock)offhand.func_77973_b()).func_179222_a(worldObj, pos, l, player, offhand)) {
                return false;
            }
        }
        Battlegear.packetHandler.sendPacketToServer(new OffhandPlaceBlockPacket(pos, l, offhand, f, f1, f2).generatePacket());
        if (flag || controller.func_178887_k()) {
            return true;
        }
        if (offhand == null) {
            return false;
        }
        if (controller.func_78758_h()) {
            int i1 = offhand.func_77960_j();
            int j1 = offhand.field_77994_a;
            boolean flag1 = offhand.func_179546_a(player, worldObj, pos, l, f, f1, f2);
            offhand.func_77964_b(i1);
            offhand.field_77994_a = j1;
            return flag1;
        }
        if (!offhand.func_179546_a(player, worldObj, pos, l, f, f1, f2)) {
            return false;
        }
        if (offhand.field_77994_a <= 0) {
            ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)offhand);
        }
        return true;
    }

    public void tickEnd(EntityPlayer player) {
        Entity target;
        MovingObjectPosition mouseOver;
        double extendedReach;
        ItemStack offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
        Battlegear.proxy.tryUseDynamicLight(player, offhand);
        if (offhand != null && offhand.func_77973_b() instanceof IShield && this.mc.field_71474_y.field_74313_G.func_151470_d() && !player.field_82175_bq && this.blockBar > 0.0f) {
            player.field_70159_w /= 5.0;
            player.field_70179_y /= 5.0;
        }
        if (player.field_110158_av == 1 && !player.func_175149_v() && (extendedReach = BattlemodeHookContainerClass.INSTANCE.maxReachDistance(player)) > (double)BattlemodeHookContainerClass.defaultReachDistance(player.field_71075_bZ.field_75098_d) && (mouseOver = Battlegear.proxy.getMouseOver(extendedReach)) != null && mouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && (target = mouseOver.field_72308_g) instanceof EntityLivingBase && target != player && player.func_70032_d(target) > this.mc.field_71442_b.func_78757_d() && target.field_70172_ad != ((EntityLivingBase)target).field_70771_an) {
            player.func_71059_n(target);
            Battlegear.packetHandler.sendPacketToServer(new ReachTargetPacket(target).generatePacket());
        }
    }

    public static void resetFlash() {
        BattlegearClientTickHandeler.INSTANCE.flashTimer = 30;
    }

    public static int getFlashTimer() {
        return BattlegearClientTickHandeler.INSTANCE.flashTimer;
    }

    public static float getBlockTime() {
        return BattlegearClientTickHandeler.INSTANCE.blockBar;
    }

    public static void reduceBlockTime(float value) {
        BattlegearClientTickHandeler.INSTANCE.blockBar -= value;
    }

    public static float getPartialTick() {
        return BattlegearClientTickHandeler.INSTANCE.partialTick;
    }

    public static ItemStack getPreviousMainhand(EntityPlayer player) {
        return player.field_71071_by.func_70301_a(BattlegearClientTickHandeler.INSTANCE.previousBattlemode);
    }

    public static ItemStack getPreviousOffhand(EntityPlayer player) {
        return player.field_71071_by.func_70301_a(BattlegearClientTickHandeler.INSTANCE.previousBattlemode + InventoryPlayerBattle.WEAPON_SETS);
    }
}

