/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import java.util.Map;
import mods.battlegear2.CommandWeaponWield;
import mods.battlegear2.CommonProxy;
import mods.battlegear2.api.quiver.IArrowFireHandler;
import mods.battlegear2.api.quiver.IQuiverSelection;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.weapons.WeaponRegistry;
import mods.battlegear2.gui.BattlegearGUIHandeler;
import mods.battlegear2.packet.BattlegearPacketHandeler;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.command.ICommand;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="battlegear2", version="1.8", guiFactory="mods.battlegear2.gui.BattlegearGuiFactory", acceptedMinecraftVersions="[1.8]")
public class Battlegear {
    public static final String MODID = "battlegear2";
    public static final String imageFolder = "battlegear2:textures/";
    public static final String CUSTOM_DAMAGE_SOURCE = "battlegearExtra";
    @Mod.Instance(value="battlegear2")
    public static Battlegear INSTANCE;
    @SidedProxy(modId="battlegear2", clientSide="mods.battlegear2.client.ClientProxy", serverSide="mods.battlegear2.CommonProxy")
    public static CommonProxy proxy;
    public static ItemArmor.ArmorMaterial knightArmourMaterial;
    public static boolean battlegearEnabled;
    public static boolean debug;
    public static Logger logger;
    public static BattlegearPacketHandeler packetHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        knightArmourMaterial = EnumHelper.addArmorMaterial((String)"knights.armour", (String)"", (int)25, (int[])new int[]{3, 7, 5, 3}, (int)15);
        BattlegearConfig.getConfig(new Configuration(event.getSuggestedConfigurationFile()));
        if ((event.getSourceFile().getName().endsWith(".jar") || debug) && event.getSide().isClient()) {
            try {
                Class.forName("mods.mud.ModUpdateDetector").getDeclaredMethod("registerMod", ModContainer.class, String.class, String.class).invoke(null, FMLCommonHandler.instance().findContainerFor((Object)this), "https://raw.github.com/Mine-and-blade-admin/Battlegear2/master/battlegear_update.xml", "https://raw.github.com/Mine-and-blade-admin/Battlegear2/master/changelog.md");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        proxy.registerHandlers();
        FMLInterModComms.IMCEvent imc = new FMLInterModComms.IMCEvent();
        imc.applyModContainer(Loader.instance().activeModContainer());
        this.onMessage(imc);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        QuiverArrowRegistry.addArrowToRegistry(Items.field_151032_g, EntityArrow.class);
        proxy.registerItemRenderers();
        BattlegearConfig.registerRecipes();
        packetHandler = new BattlegearPacketHandeler();
        packetHandler.register();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new BattlegearGUIHandeler());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            proxy.tryUseTConstruct();
        }
        if (Loader.isModLoaded((String)"DynamicLights_thePlayer")) {
            proxy.tryUseDynamicLight(null, null);
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)CommandWeaponWield.INSTANCE);
    }

    @Mod.EventHandler
    public void onMessage(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            boolean success;
            block21: {
                if (message == null) continue;
                success = false;
                if (message.isItemStackMessage()) {
                    ItemStack stack = message.getItemStackValue();
                    if (stack != null) {
                        if (WeaponRegistry.setWeapon(message.key, stack)) {
                            success = true;
                        } else if (message.key.startsWith("Arrow")) {
                            Class<?> clazz = null;
                            try {
                                if (message.key.indexOf(":") > 0) {
                                    clazz = Class.forName(message.key.split(":")[1]);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (clazz != null && EntityArrow.class.isAssignableFrom(clazz)) {
                                QuiverArrowRegistry.addArrowToRegistry(stack, clazz);
                                success = true;
                            } else {
                                QuiverArrowRegistry.addArrowToRegistry(stack);
                                success = true;
                            }
                        }
                    }
                } else if (message.isStringMessage()) {
                    try {
                        Class<?> clazz = Class.forName(message.getStringValue());
                        if (clazz == null) break block21;
                        if (message.key.equals("QuiverSelection") && IQuiverSelection.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addQuiverSelection((IQuiverSelection)clazz.newInstance());
                            success = true;
                        } else if (message.key.equals("FireHandler") && IArrowFireHandler.class.isAssignableFrom(clazz)) {
                            QuiverArrowRegistry.addArrowFireHandler((IArrowFireHandler)clazz.newInstance());
                            success = true;
                        }
                    }
                    catch (Exception exception) {}
                } else if (message.isNBTMessage() && Loader.instance().hasReachedState(LoaderState.PREINITIALIZATION) && !Loader.instance().hasReachedState(LoaderState.INITIALIZATION) && BattlegearConfig.initItemFromNBT(message.getNBTValue())) {
                    success = true;
                }
            }
            if (success) {
                logger.trace("Mine&Blade:Battlegear2 successfully managed message from " + message.getSender());
                continue;
            }
            logger.warn(message.getSender() + " tried to communicate with Mine&Blade:Battlegear2, but message was not supported!");
        }
    }

    @Mod.EventHandler
    public void onRemapId(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            if (!BattlegearConfig.remap(mapping)) continue;
            logger.warn("ReMapped: " + mapping.name);
        }
    }

    @NetworkCheckHandler
    public boolean checkRemote(Map<String, String> mods, Side remoteParty) {
        String remoteVersion;
        if (mods.containsKey(MODID) && (remoteVersion = mods.get(MODID)) != null) {
            String internalVersion = FMLCommonHandler.instance().findContainerFor((Object)this).getVersion();
            if (remoteVersion.equals(internalVersion)) {
                return true;
            }
            internalVersion = internalVersion.substring(0, internalVersion.lastIndexOf("."));
            remoteVersion = remoteVersion.substring(0, remoteVersion.lastIndexOf("."));
            return remoteVersion.equals(internalVersion);
        }
        return false;
    }

    static {
        battlegearEnabled = true;
        debug = false;
    }
}

