/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import mods.battlegear2.client.utils.BattlegearRenderHelper;
import mods.battlegear2.items.ItemShield;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ShieldRenderer
implements IItemRenderer {
    private RenderItem itemRenderer;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP && item != null && item.func_77973_b() instanceof ItemShield;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && (helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.itemRenderer == null) {
            this.itemRenderer = new RenderItem();
        }
        ItemShield shield = (ItemShield)item.func_77973_b();
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        int col = shield.getColor(item);
        float red = (float)(col >> 16 & 0xFF) / 255.0f;
        float green = (float)(col >> 8 & 0xFF) / 255.0f;
        float blue = (float)(col & 0xFF) / 255.0f;
        IIcon icon = item.getIconIndex();
        switch (type) {
            case ENTITY: {
                GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0f);
                GL11.glColor3f((float)red, (float)green, (float)blue);
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
                if (!shield.enumShield.getName().equals("wood")) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.0625f);
                icon = shield.getBackIcon();
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.00390625f);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.09375f);
                icon = shield.getTrimIcon();
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.09375f);
                if (!item.hasEffect(0)) break;
                BattlegearRenderHelper.renderEnchantmentEffects((Tessellator)tessellator);
                break;
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                GL11.glColor3f((float)red, (float)green, (float)blue);
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
                if (!shield.enumShield.getName().equals("wood")) {
                    GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.00390625f);
                icon = shield.getBackIcon();
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.00390625f);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.00390625f);
                icon = shield.getTrimIcon();
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.09375f);
                if (!item.hasEffect(0)) break;
                BattlegearRenderHelper.renderEnchantmentEffects((Tessellator)tessellator);
                break;
            }
            case INVENTORY: {
                GL11.glColor3f((float)red, (float)green, (float)blue);
                GL11.glEnable((int)3008);
                this.itemRenderer.renderIcon(0, 0, icon, 16, 16);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                icon = shield.getTrimIcon();
                this.itemRenderer.renderIcon(0, 0, icon, 16, 16);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)3042);
                if (!item.hasEffect(0)) break;
                this.itemRenderer.renderEffect(Minecraft.func_71410_x().func_110434_K(), 0, 0);
            }
        }
        BattlegearRenderHelper.renderArrows(item, type == IItemRenderer.ItemRenderType.ENTITY);
        GL11.glPopMatrix();
    }
}

