/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.gui.controls;

import java.util.List;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.input.Mouse;

public abstract class GUIScrollList {
    protected final int listWidth;
    protected final int top;
    protected final int bottom;
    private final int right;
    protected final int left;
    protected final int slotHeight;
    private int scrollUpActionId;
    private int scrollDownActionId;
    protected int mouseX;
    protected int mouseY;
    private float initialMouseClickY = -2.0f;
    private float scrollFactor;
    private float scrollDistance;
    private int selectedIndex = -1;
    private long lastClickTime = 0L;
    private boolean highlightSelected = true;
    private boolean hasHeader;
    private int headerHeight;
    public boolean drawList = true;

    public GUIScrollList(int width, int top, int bottom, int left, int entryHeight) {
        this.listWidth = width;
        this.top = top;
        this.bottom = bottom;
        this.slotHeight = entryHeight;
        this.left = left;
        this.right = width + this.left;
    }

    public void func_27258_a(boolean p_27258_1_) {
        this.highlightSelected = p_27258_1_;
    }

    protected void setHeaderInfo(boolean p_27259_1_, int p_27259_2_) {
        this.hasHeader = p_27259_1_;
        this.headerHeight = p_27259_2_;
        if (!p_27259_1_) {
            this.headerHeight = 0;
        }
    }

    protected abstract int getSize();

    protected abstract void elementClicked(int var1, boolean var2);

    protected abstract boolean isSelected(int var1);

    protected int getContentHeight() {
        return this.getSize() * this.slotHeight + this.headerHeight;
    }

    protected abstract void drawBackground();

    protected abstract void drawSlot(int var1, int var2, int var3, int var4, Tessellator var5);

    protected void drawHeader(int entryRight, int relativeY, Tessellator tess) {
    }

    protected void drawScreen(int mouseX, int mouseY) {
    }

    public int func_27256_c(int p_27256_1_, int p_27256_2_) {
        int var3 = this.left + 1;
        int var4 = this.left + this.listWidth - 7;
        int var5 = p_27256_2_ - this.top - this.headerHeight + (int)this.scrollDistance - 4;
        int var6 = var5 / this.slotHeight;
        return p_27256_1_ >= var3 && p_27256_1_ <= var4 && var6 >= 0 && var5 >= 0 && var6 < this.getSize() ? var6 : -1;
    }

    public void registerScrollButtons(List p_22240_1_, int p_22240_2_, int p_22240_3_) {
        this.scrollUpActionId = p_22240_2_;
        this.scrollDownActionId = p_22240_3_;
    }

    private void applyScrollLimits() {
        int var1 = this.getContentHeight() - (this.bottom - this.top - 4);
        if (var1 < 0) {
            var1 /= 2;
        }
        if (this.scrollDistance < 0.0f) {
            this.scrollDistance = 0.0f;
        }
        if (this.scrollDistance > (float)var1) {
            this.scrollDistance = var1;
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.field_146124_l && this.drawList) {
            if (button.field_146127_k == this.scrollUpActionId) {
                this.scrollDistance -= (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            } else if (button.field_146127_k == this.scrollDownActionId) {
                this.scrollDistance += (float)(this.slotHeight * 2 / 3);
                this.initialMouseClickY = -2.0f;
                this.applyScrollLimits();
            }
        }
    }

    public void drawScreen(int mouseX, int mouseY, float p_22243_3_) {
        if (this.drawList) {
            int var13;
            int var19;
            int var11;
            int var10;
            this.mouseX = mouseX;
            this.mouseY = mouseY;
            this.drawBackground();
            int listLength = this.getSize();
            int scrollBarXStart = this.left + this.listWidth - 6;
            int scrollBarXEnd = scrollBarXStart + 6;
            int boxLeft = this.left;
            int boxRight = scrollBarXStart - 1;
            if (Mouse.isButtonDown((int)0)) {
                if (this.initialMouseClickY == -1.0f) {
                    boolean var7 = true;
                    if (mouseY >= this.top && mouseY <= this.bottom) {
                        var10 = mouseY - this.top - this.headerHeight + (int)this.scrollDistance - 4;
                        var11 = var10 / this.slotHeight;
                        if (mouseX >= boxLeft && mouseX <= boxRight && var11 >= 0 && var10 >= 0 && var11 < listLength) {
                            boolean var12 = var11 == this.selectedIndex && System.currentTimeMillis() - this.lastClickTime < 250L;
                            this.elementClicked(var11, var12);
                            this.selectedIndex = var11;
                            this.lastClickTime = System.currentTimeMillis();
                        } else if (mouseX >= boxLeft && mouseX <= boxRight && var10 < 0) {
                            var7 = false;
                        }
                        if (mouseX >= scrollBarXStart && mouseX <= scrollBarXEnd) {
                            this.scrollFactor = -1.0f;
                            var19 = this.getContentHeight() - (this.bottom - this.top - 4);
                            if (var19 < 1) {
                                var19 = 1;
                            }
                            if ((var13 = (int)((float)((this.bottom - this.top) * (this.bottom - this.top)) / (float)this.getContentHeight())) < 32) {
                                var13 = 32;
                            }
                            if (var13 > this.bottom - this.top - 8) {
                                var13 = this.bottom - this.top - 8;
                            }
                            this.scrollFactor /= (float)(this.bottom - this.top - var13) / (float)var19;
                        } else {
                            this.scrollFactor = 1.0f;
                        }
                        this.initialMouseClickY = var7 ? (float)mouseY : -2.0f;
                    } else {
                        this.initialMouseClickY = -2.0f;
                    }
                } else if (this.initialMouseClickY >= 0.0f) {
                    this.scrollDistance -= ((float)mouseY - this.initialMouseClickY) * this.scrollFactor;
                    this.initialMouseClickY = mouseY;
                }
            } else {
                while (Mouse.next()) {
                    int var16 = Mouse.getEventDWheel();
                    if (var16 == 0) continue;
                    if (var16 > 0) {
                        var16 = -1;
                    } else if (var16 < 0) {
                        var16 = 1;
                    }
                    this.scrollDistance += (float)(var16 * this.slotHeight / 2);
                }
                this.initialMouseClickY = -1.0f;
            }
            this.applyScrollLimits();
            GlStateManager.func_179140_f();
            GlStateManager.func_179106_n();
            Tessellator var18 = Tessellator.func_178181_a();
            var10 = this.top + 4 - (int)this.scrollDistance;
            if (this.hasHeader) {
                this.drawHeader(boxRight, var10, var18);
            }
            for (var11 = 0; var11 < listLength; ++var11) {
                var19 = var10 + var11 * this.slotHeight + this.headerHeight;
                var13 = this.slotHeight - 4;
                if (var19 > this.bottom || var19 + var13 < this.top) continue;
                if (this.highlightSelected && this.isSelected(var11)) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179090_x();
                    var18.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    var18.func_178180_c().func_181662_b((double)boxLeft, (double)(var19 + var13 + 2), 0.0).func_181673_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    var18.func_178180_c().func_181662_b((double)boxRight, (double)(var19 + var13 + 2), 0.0).func_181673_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    var18.func_178180_c().func_181662_b((double)boxRight, (double)(var19 - 2), 0.0).func_181673_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    var18.func_178180_c().func_181662_b((double)boxLeft, (double)(var19 - 2), 0.0).func_181673_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                    var18.func_178180_c().func_181662_b((double)(boxLeft + 1), (double)(var19 + var13 + 1), 0.0).func_181673_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    var18.func_178180_c().func_181662_b((double)(boxRight - 1), (double)(var19 + var13 + 1), 0.0).func_181673_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    var18.func_178180_c().func_181662_b((double)(boxRight - 1), (double)(var19 - 1), 0.0).func_181673_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    var18.func_178180_c().func_181662_b((double)(boxLeft + 1), (double)(var19 - 1), 0.0).func_181673_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    var18.func_78381_a();
                    GlStateManager.func_179098_w();
                }
                this.drawSlot(var11, boxRight, var19, var13, var18);
            }
            GlStateManager.func_179097_i();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179118_c();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179090_x();
            var19 = this.getContentHeight() - (this.bottom - this.top - 4);
            if (var19 > 0) {
                int var14;
                var13 = (this.bottom - this.top) * (this.bottom - this.top) / this.getContentHeight();
                if (var13 < 32) {
                    var13 = 32;
                }
                if (var13 > this.bottom - this.top - 8) {
                    var13 = this.bottom - this.top - 8;
                }
                if ((var14 = (int)this.scrollDistance * (this.bottom - this.top - var13) / var19 + this.top) < this.top) {
                    var14 = this.top;
                }
                var18.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
                var18.func_178180_c().func_181662_b((double)scrollBarXStart, (double)this.bottom, 0.0).func_181673_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)scrollBarXEnd, (double)this.bottom, 0.0).func_181673_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)scrollBarXEnd, (double)this.top, 0.0).func_181673_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)scrollBarXStart, (double)this.top, 0.0).func_181673_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                var18.func_78381_a();
                var18.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
                var18.func_178180_c().func_181662_b((double)scrollBarXStart, (double)(var14 + var13), 0.0).func_181673_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)scrollBarXEnd, (double)(var14 + var13), 0.0).func_181673_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)scrollBarXEnd, (double)var14, 0.0).func_181673_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)scrollBarXStart, (double)var14, 0.0).func_181673_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
                var18.func_78381_a();
                var18.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181709_i);
                var18.func_178180_c().func_181662_b((double)scrollBarXStart, (double)(var14 + var13 - 1), 0.0).func_181673_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)(scrollBarXEnd - 1), (double)(var14 + var13 - 1), 0.0).func_181673_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)(scrollBarXEnd - 1), (double)var14, 0.0).func_181673_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                var18.func_178180_c().func_181662_b((double)scrollBarXStart, (double)var14, 0.0).func_181673_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
                var18.func_78381_a();
            }
            this.drawScreen(mouseX, mouseY);
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
        }
    }

    public void drawTexturedModalRect(Tessellator tessellator, int x, int y, int width, int height, int zLevel) {
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_181662_b((double)x, (double)(y + height), (double)zLevel).func_181673_a(0.0, 1.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_181673_a(1.0, 1.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)(x + width), (double)y, (double)zLevel).func_181673_a(1.0, 0.0).func_181675_d();
        tessellator.func_178180_c().func_181662_b((double)x, (double)y, (double)zLevel).func_181673_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawRect(int x1, int y1, int x2, int y2, int col) {
        Gui.func_73734_a((int)x1, (int)y1, (int)x2, (int)y2, (int)col);
    }
}

