/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.core;

import mods.battlegear2.api.core.InventorySlotType;
import mods.battlegear2.api.core.UnhandledInventoryItemEvent;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InventoryPlayerBattle
extends InventoryPlayer {
    public boolean hasChanged = true;
    public static int ARMOR_OFFSET = 100;
    public static int OFFSET = 150;
    public static int WEAPON_SETS = 3;
    public static int EXTRA_ITEMS = WEAPON_SETS * 2;
    public ItemStack[] extraItems = new ItemStack[EXTRA_ITEMS];

    public InventoryPlayerBattle(EntityPlayer entityPlayer) {
        super(entityPlayer);
    }

    public boolean isBattlemode() {
        return this.field_70461_c >= OFFSET && this.field_70461_c < OFFSET + EXTRA_ITEMS;
    }

    public void resizeExtra() {
        if (EXTRA_ITEMS < this.extraItems.length) {
            EXTRA_ITEMS = this.extraItems.length;
        }
    }

    public int requestNewSlot(InventorySlotType type) {
        switch (type) {
            case MAIN: {
                if (this.field_70462_a.length + 1 >= ARMOR_OFFSET) break;
                ItemStack[] temp = new ItemStack[this.field_70462_a.length + 1];
                System.arraycopy(this.field_70462_a, 0, temp, 0, this.field_70462_a.length);
                this.field_70462_a = temp;
                return this.field_70462_a.length - 1;
            }
            case ARMOR: {
                if (ARMOR_OFFSET + this.field_70460_b.length + 1 >= OFFSET) break;
                ItemStack[] temp = new ItemStack[this.field_70460_b.length + 1];
                System.arraycopy(this.field_70460_b, 0, temp, 0, this.field_70460_b.length);
                this.field_70460_b = temp;
                return ARMOR_OFFSET + this.field_70460_b.length - 1;
            }
            case BATTLE: {
                ItemStack[] temp = new ItemStack[this.extraItems.length + 1];
                System.arraycopy(this.extraItems, 0, temp, 0, this.extraItems.length);
                this.extraItems = temp;
                this.resizeExtra();
                return OFFSET + this.extraItems.length - 1;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static boolean isValidSwitch(int id) {
        return id >= 0 && id < InventoryPlayerBattle.func_70451_h() || id >= OFFSET && id < OFFSET + EXTRA_ITEMS;
    }

    private int getInventorySlotContainItem(Item par1) {
        for (int j = 0; j < this.extraItems.length; ++j) {
            if (this.extraItems[j] == null || this.extraItems[j].func_77973_b() != par1) continue;
            return j;
        }
        return -1;
    }

    public ItemStack func_70448_g() {
        return this.isBattlemode() ? this.extraItems[this.field_70461_c - OFFSET] : super.func_70448_g();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_146030_a(Item targetItem, int targetDamage, boolean compareWithDamage, boolean forceInEmptySlots) {
        if (!this.isBattlemode()) {
            super.func_146030_a(targetItem, targetDamage, compareWithDamage, forceInEmptySlots);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70453_c(int direction) {
        if (this.isBattlemode()) {
            if (direction > 0) {
                --this.field_70461_c;
            } else if (direction != 0) {
                ++this.field_70461_c;
            }
            if (this.field_70461_c < OFFSET) {
                this.field_70461_c = OFFSET + WEAPON_SETS - 1;
            } else if (this.field_70461_c >= OFFSET + WEAPON_SETS) {
                this.field_70461_c = OFFSET;
            }
        } else {
            super.func_70453_c(direction);
        }
    }

    public int func_174925_a(Item targetId, int targetDamage, int amount, NBTTagCompound targetNBT) {
        int stacks = super.func_174925_a(targetId, targetDamage, amount, targetNBT);
        if (amount > 0 && stacks >= amount) {
            return stacks;
        }
        for (int i = 0; i < this.extraItems.length; ++i) {
            ItemStack stack = this.extraItems[i];
            if (stack == null || targetId != null && stack.func_77973_b() != targetId || targetDamage > -1 && stack.func_77960_j() != targetDamage || targetNBT != null && !NBTUtil.func_181123_a((NBTBase)targetNBT, (NBTBase)stack.func_77978_p(), (boolean)true)) continue;
            int temp = amount <= 0 ? stack.field_77994_a : Math.min(amount - stacks, stack.field_77994_a);
            stacks += temp;
            if (amount == 0) continue;
            this.extraItems[i].field_77994_a -= temp;
            if (this.extraItems[i].field_77994_a == 0) {
                this.extraItems[i] = null;
                this.hasChanged = true;
            }
            if (amount <= 0 || stacks < amount) continue;
            return stacks;
        }
        return stacks;
    }

    public void func_70429_k() {
        super.func_70429_k();
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null) continue;
            this.extraItems[i].func_77945_a(this.field_70458_d.field_70170_p, (Entity)this.field_70458_d, i + OFFSET, this.field_70461_c == i + OFFSET);
        }
    }

    public boolean func_146026_a(Item par1) {
        int j = this.getInventorySlotContainItem(par1);
        if (j < 0) {
            return super.func_146026_a(par1);
        }
        this.hasChanged = true;
        if (--this.extraItems[j].field_77994_a <= 0) {
            this.extraItems[j] = null;
        }
        return true;
    }

    public boolean func_146028_b(Item par1) {
        if (super.func_146028_b(par1)) {
            return true;
        }
        int j = this.getInventorySlotContainItem(par1);
        return j >= 0;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (slot >= OFFSET) {
            ItemStack targetStack = this.extraItems[slot - OFFSET];
            if (targetStack != null) {
                this.hasChanged = true;
                if (targetStack.field_77994_a <= amount) {
                    this.extraItems[slot - InventoryPlayerBattle.OFFSET] = null;
                    return targetStack;
                }
                targetStack = this.extraItems[slot - OFFSET].func_77979_a(amount);
                if (this.extraItems[slot - InventoryPlayerBattle.OFFSET].field_77994_a == 0) {
                    this.extraItems[slot - InventoryPlayerBattle.OFFSET] = null;
                }
                return targetStack;
            }
            return null;
        }
        return super.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack result = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        return result;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.setInventorySlotContents(slot, itemStack, true);
    }

    public void setInventorySlotContents(int slot, ItemStack itemStack, boolean changed) {
        if (slot >= OFFSET) {
            this.hasChanged = changed;
            this.extraItems[slot - InventoryPlayerBattle.OFFSET] = itemStack;
        } else {
            super.func_70299_a(slot, itemStack);
        }
    }

    public float func_146023_a(Block block) {
        if (this.isBattlemode()) {
            ItemStack currentItemStack = this.func_70448_g();
            return currentItemStack != null ? currentItemStack.func_150997_a(block) : 1.0f;
        }
        return super.func_146023_a(block);
    }

    public NBTTagList func_70442_a(NBTTagList par1nbtTagList) {
        NBTTagList nbtList = super.func_70442_a(par1nbtTagList);
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)(i + OFFSET));
            this.extraItems[i].func_77955_b(nbttagcompound);
            nbtList.func_74742_a((NBTBase)nbttagcompound);
        }
        return nbtList;
    }

    public void func_70443_b(NBTTagList nbtTagList) {
        int j;
        NBTTagCompound nbttagcompound;
        int i;
        int highestMain = this.field_70462_a.length;
        int highestArmor = this.field_70460_b.length;
        int highestExtra = this.extraItems.length;
        for (i = 0; i < nbtTagList.func_74745_c(); ++i) {
            nbttagcompound = nbtTagList.func_150305_b(i);
            j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= 0 && j < ARMOR_OFFSET) {
                if (j < highestMain) continue;
                highestMain = j + 1;
                continue;
            }
            if (j >= ARMOR_OFFSET && j < OFFSET) {
                if (j - ARMOR_OFFSET < highestArmor) continue;
                highestArmor = j + 1 - ARMOR_OFFSET;
                continue;
            }
            if (j < OFFSET || j >= 255 || j - OFFSET < highestExtra) continue;
            highestExtra = j + 1 - OFFSET;
        }
        this.field_70462_a = new ItemStack[highestMain];
        this.field_70460_b = new ItemStack[highestArmor];
        this.extraItems = new ItemStack[highestExtra];
        for (i = 0; i < nbtTagList.func_74745_c(); ++i) {
            nbttagcompound = nbtTagList.func_150305_b(i);
            j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            if (itemstack == null) continue;
            if (j >= 0 && j < this.field_70462_a.length) {
                this.field_70462_a[j] = itemstack;
                continue;
            }
            if (j >= ARMOR_OFFSET && j - ARMOR_OFFSET < this.field_70460_b.length) {
                this.field_70460_b[j - InventoryPlayerBattle.ARMOR_OFFSET] = itemstack;
                continue;
            }
            if (j >= OFFSET && j - OFFSET < this.extraItems.length) {
                this.extraItems[j - InventoryPlayerBattle.OFFSET] = itemstack;
                continue;
            }
            MinecraftForge.EVENT_BUS.post((Event)new UnhandledInventoryItemEvent(this.field_70458_d, j, itemstack));
        }
        this.resizeExtra();
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= OFFSET) {
            return this.extraItems[slot - OFFSET];
        }
        return super.func_70301_a(slot);
    }

    public int func_70302_i_() {
        return this.field_70462_a.length + this.field_70460_b.length;
    }

    public void func_70436_m() {
        this.hasChanged = true;
        super.func_70436_m();
        for (int i = 0; i < this.extraItems.length; ++i) {
            if (this.extraItems[i] == null) continue;
            this.field_70458_d.func_146097_a(this.extraItems[i], true, false);
            this.extraItems[i] = null;
        }
    }

    public void func_70455_b(InventoryPlayer par1InventoryPlayer) {
        this.field_70462_a = new ItemStack[par1InventoryPlayer.field_70462_a.length];
        this.field_70460_b = new ItemStack[par1InventoryPlayer.field_70460_b.length];
        super.func_70455_b(par1InventoryPlayer);
        if (par1InventoryPlayer instanceof InventoryPlayerBattle) {
            this.extraItems = new ItemStack[((InventoryPlayerBattle)par1InventoryPlayer).extraItems.length];
            for (int i = 0; i < this.extraItems.length; ++i) {
                this.extraItems[i] = ItemStack.func_77944_b((ItemStack)par1InventoryPlayer.func_70301_a(i + OFFSET));
            }
        }
    }

    public void func_174888_l() {
        super.func_174888_l();
        for (int i = 0; i < this.extraItems.length; ++i) {
            this.extraItems[i] = null;
        }
    }

    public ItemStack getCurrentOffhandWeapon() {
        if (this.isBattlemode()) {
            if (this.isOffset()) {
                return this.func_70301_a(this.field_70461_c);
            }
            return this.func_70301_a(this.field_70461_c + WEAPON_SETS);
        }
        return null;
    }

    public ItemStack getCurrentOppositeHand() {
        if (this.isBattlemode()) {
            if (this.isOffset()) {
                return this.func_70301_a(this.field_70461_c - WEAPON_SETS);
            }
            return this.func_70301_a(this.field_70461_c + WEAPON_SETS);
        }
        return null;
    }

    public int swapHandItem() {
        if (this.isBattlemode()) {
            this.field_70461_c = this.isOffset() ? (this.field_70461_c -= WEAPON_SETS) : (this.field_70461_c += WEAPON_SETS);
        }
        return this.field_70461_c;
    }

    public boolean isOffset() {
        return this.field_70461_c + WEAPON_SETS >= OFFSET + EXTRA_ITEMS;
    }
}

