/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.core;

import java.io.Closeable;
import java.io.IOException;
import mods.battlegear2.api.IAllowItem;
import mods.battlegear2.api.IOffhandWield;
import mods.battlegear2.api.IUsableItem;
import mods.battlegear2.api.IWield;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.core.InventorySlotType;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.ISpecialBow;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import mods.battlegear2.api.weapons.WeaponRegistry;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemEnderPearl;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemSnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;

public class BattlegearUtils {
    public static final EventBus RENDER_BUS = new EventBus();
    private static String[] itemBlackListMethodNames = new String[]{BattlegearTranslator.getMapedMethodName("func_180614_a", "onItemUse"), BattlegearTranslator.getMapedMethodName("onItemUseFirst", "onItemUseFirst"), BattlegearTranslator.getMapedMethodName("func_77659_a", "onItemRightClick")};
    private static Class[][] itemBlackListMethodParams = new Class[][]{{ItemStack.class, EntityPlayer.class, World.class, BlockPos.class, EnumFacing.class, Float.TYPE, Float.TYPE, Float.TYPE}, {ItemStack.class, EntityPlayer.class, World.class, BlockPos.class, EnumFacing.class, Float.TYPE, Float.TYPE, Float.TYPE}, {ItemStack.class, World.class, EntityPlayer.class}};
    private static ItemStack prevNotWieldable;
    private static String genericAttack;

    public static boolean canBlockWithShield(EntityPlayer player) {
        if (!(player.field_71071_by instanceof InventoryPlayerBattle)) {
            return false;
        }
        ItemStack offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
        return offhand != null && offhand.func_77973_b() instanceof IShield;
    }

    public static boolean isBlockingWithShield(EntityPlayer player) {
        return ((IBattlePlayer)player).isBlockingWithShield();
    }

    public static boolean isPlayerInBattlemode(EntityPlayer player) {
        return player.field_71071_by instanceof InventoryPlayerBattle && ((InventoryPlayerBattle)player.field_71071_by).isBattlemode();
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack, int offset) {
        ((InventoryPlayerBattle)player.field_71071_by).setInventorySlotContents(player.field_71071_by.field_70461_c + offset, stack, false);
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack) {
        BattlegearUtils.setPlayerCurrentItem(player, stack, 0);
    }

    public static void setPlayerOffhandItem(EntityPlayer player, ItemStack stack) {
        if (BattlegearUtils.isPlayerInBattlemode(player)) {
            BattlegearUtils.setPlayerCurrentItem(player, stack, InventoryPlayerBattle.WEAPON_SETS);
        }
    }

    public static boolean isWeapon(ItemStack main) {
        if (main.func_77973_b() instanceof IBattlegearWeapon) {
            return true;
        }
        if (main.func_77976_d() == 1 && main.func_77958_k() > 0 && !main.func_77981_g()) {
            return true;
        }
        if (main == prevNotWieldable) {
            return false;
        }
        if (WeaponRegistry.isWeapon(main)) {
            return true;
        }
        if (!BattlegearUtils.checkForRightClickFunction(main)) {
            WeaponRegistry.addDualWeapon(main);
            return true;
        }
        WeaponRegistry.addDualUsable(main);
        prevNotWieldable = main;
        return false;
    }

    public static boolean isMainHand(ItemStack main, ItemStack off, EntityPlayer wielder) {
        if (main == null) {
            return true;
        }
        if (main.func_77973_b() instanceof IWield && !((IWield)main.func_77973_b()).getWieldStyle(main, wielder).isMainhand()) {
            return false;
        }
        if (main.func_77973_b() instanceof IAllowItem) {
            return ((IAllowItem)main.func_77973_b()).allowOffhand(main, off, wielder);
        }
        if (main.func_77973_b() instanceof IShield) {
            return false;
        }
        if (main.func_77973_b() instanceof IArrowContainer2) {
            return true;
        }
        if (BattlegearUtils.usagePriorAttack(main, wielder, false)) {
            return off == null || !BattlegearUtils.usagePriorAttack(off, wielder, true);
        }
        if (BattlegearUtils.isWeapon(main)) {
            return main.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isMainHand(main);
        }
        return false;
    }

    public static boolean isOffHand(ItemStack off, ItemStack main, EntityPlayer wielder) {
        if (off == null) {
            return true;
        }
        if (off.func_77973_b() instanceof IWield && !((IWield)off.func_77973_b()).getWieldStyle(off, wielder).isOffhand()) {
            return false;
        }
        if (off.func_77973_b() instanceof IOffhandWield && !((IOffhandWield)off.func_77973_b()).isOffhandWieldable(off, wielder)) {
            return false;
        }
        if (off.func_77973_b() instanceof IAllowItem) {
            return ((IAllowItem)off.func_77973_b()).allowOffhand(off, main, wielder);
        }
        if (off.func_77973_b() instanceof IShield || off.func_77973_b() instanceof IArrowContainer2 || BattlegearUtils.usagePriorAttack(off, wielder, true)) {
            return true;
        }
        if (BattlegearUtils.isWeapon(off)) {
            return off.func_111283_C().containsKey((Object)genericAttack) || WeaponRegistry.isOffHand(off);
        }
        return false;
    }

    public static boolean usagePriorAttack(ItemStack itemStack, EntityPlayer wielder, boolean off) {
        if (itemStack.func_77973_b() instanceof IUsableItem) {
            return ((IUsableItem)itemStack.func_77973_b()).isUsedOverAttack(itemStack, wielder);
        }
        EnumAction useAction = itemStack.func_77975_n();
        return useAction == EnumAction.BOW || useAction == EnumAction.DRINK || useAction == EnumAction.EAT || BattlegearUtils.isCommonlyUsable(itemStack.func_77973_b()) || WeaponRegistry.useOverAttack(itemStack, off);
    }

    public static boolean isCommonlyUsable(Item item) {
        return BattlegearUtils.isBow(item) || item instanceof ItemBlock || item instanceof ItemFlintAndSteel || item instanceof ItemFireball || item instanceof ItemBucket || item instanceof ItemSnowball || item instanceof ItemEnderPearl;
    }

    public static boolean isBow(Item item) {
        return item instanceof ItemBow || item instanceof ISpecialBow;
    }

    public static boolean checkForRightClickFunction(ItemStack stack) {
        if (stack.func_77975_n() == EnumAction.BLOCK || stack.func_77975_n() == EnumAction.NONE) {
            Class<?> c = stack.func_77973_b().getClass();
            while (!c.equals(Item.class)) {
                if (c.equals(ItemTool.class) || c.equals(ItemSword.class)) {
                    return false;
                }
                if (BattlegearUtils.getBlackListedMethodIn(c)) {
                    return true;
                }
                c = c.getSuperclass();
            }
            return stack.func_77988_m() > 0;
        }
        return true;
    }

    private static boolean getBlackListedMethodIn(Class<?> c) {
        for (int i = 0; i < itemBlackListMethodNames.length; ++i) {
            try {
                c.getDeclaredMethod(itemBlackListMethodNames[i], itemBlackListMethodParams[i]);
                return true;
            }
            catch (NoSuchMethodException noMethod) {
                continue;
            }
            catch (Throwable ignored) {
                return true;
            }
        }
        return false;
    }

    public static InventoryPlayer replaceInventory(EntityPlayer entityPlayer) {
        return new InventoryPlayerBattle(entityPlayer);
    }

    public static int requestInventorySpace(EntityPlayer entityPlayer, InventorySlotType type) {
        return ((InventoryPlayerBattle)entityPlayer.field_71071_by).requestNewSlot(type);
    }

    public static void attackTargetEntityWithCurrentOffItem(EntityPlayer player, Entity target) {
        BattlegearUtils.refreshAttributes(player);
        if (!ForgeHooks.onPlayerAttackTarget((EntityPlayer)player, (Entity)target)) {
            BattlegearUtils.refreshAttributes(player);
            return;
        }
        if (target.func_70075_an() && !target.func_85031_j((Entity)player)) {
            float f = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = EnchantmentHelper.func_77501_a((EntityLivingBase)player);
            float f1 = 0.0f;
            f1 = target instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)player.func_70694_bm(), (EnumCreatureAttribute)((EntityLivingBase)target).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)player.func_70694_bm(), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            if (player.func_70051_ag()) {
                ++i;
            }
            if (f > 0.0f || f1 > 0.0f) {
                boolean flag;
                boolean bl = flag = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && target instanceof EntityLivingBase;
                if (flag && f > 0.0f) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag1 = false;
                int j = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (target instanceof EntityLivingBase && j > 0 && !target.func_70027_ad()) {
                    flag1 = true;
                    target.func_70015_d(1);
                }
                double d0 = target.field_70159_w;
                double d1 = target.field_70181_x;
                double d2 = target.field_70179_y;
                boolean flag2 = target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), f);
                if (flag2) {
                    if (i > 0) {
                        target.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (target instanceof EntityPlayerMP && target.field_70133_I) {
                        ((EntityPlayerMP)target).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(target));
                        target.field_70133_I = false;
                        target.field_70159_w = d0;
                        target.field_70181_x = d1;
                        target.field_70179_y = d2;
                    }
                    if (flag) {
                        player.func_71009_b(target);
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(target);
                    }
                    if (f >= 18.0f) {
                        player.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    player.func_130011_c(target);
                    if (target instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)target), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)target);
                    ItemStack itemstack = player.func_71045_bC();
                    if (itemstack != null) {
                        IEntityMultiPart ientitymultipart;
                        Entity object = target;
                        if (target instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)target).field_70259_a) != null && ientitymultipart instanceof EntityLivingBase) {
                            object = ientitymultipart;
                        }
                        if (object instanceof EntityLivingBase) {
                            itemstack.func_77961_a((EntityLivingBase)object, player);
                            if (itemstack.field_77994_a <= 0) {
                                player.func_71028_bD();
                            }
                        }
                    }
                    if (target instanceof EntityLivingBase) {
                        player.func_71064_a(StatList.field_75951_w, Math.round(f * 10.0f));
                        if (j > 0) {
                            target.func_70015_d(j * 4);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else if (flag1) {
                    target.func_70066_B();
                }
            }
        }
        BattlegearUtils.refreshAttributes(player);
    }

    public static boolean interactWith(EntityPlayer entityPlayer, Entity entity) {
        if (entityPlayer.func_175149_v()) {
            if (entity instanceof IInventory) {
                entityPlayer.func_71007_a((IInventory)entity);
            }
            return false;
        }
        EntityInteractEvent event = new EntityInteractEvent(entityPlayer, entity);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        ItemStack itemstack = entityPlayer.func_71045_bC();
        boolean offset = false;
        ItemStack copyStack = itemstack != null ? itemstack.func_77946_l() : null;
        boolean entityInteract = entity.func_130002_c(entityPlayer);
        if (!entityInteract && BattlegearUtils.isPlayerInBattlemode(entityPlayer)) {
            offset = true;
            itemstack = BattlegearUtils.refreshAttributes(entityPlayer);
            copyStack = itemstack != null ? itemstack.func_77946_l() : null;
            entityInteract = entity.func_130002_c(entityPlayer);
        }
        if (!entityInteract) {
            ItemStack offhandItem;
            PlayerEventChild.OffhandAttackEvent offAttackEvent;
            boolean itemInteract = false;
            if (itemstack != null && entity instanceof EntityLivingBase) {
                if (entityPlayer.field_71075_bZ.field_75098_d) {
                    itemstack = copyStack;
                }
                if (!(itemInteract = itemstack.func_111282_a(entityPlayer, (EntityLivingBase)entity)) && !offset && BattlegearUtils.isPlayerInBattlemode(entityPlayer)) {
                    offset = true;
                    itemstack = BattlegearUtils.refreshAttributes(entityPlayer);
                    if (itemstack != null) {
                        itemInteract = itemstack.func_111282_a(entityPlayer, (EntityLivingBase)entity);
                    }
                }
                if (itemInteract && itemstack.field_77994_a <= 0 && !entityPlayer.field_71075_bZ.field_75098_d) {
                    entityPlayer.func_71028_bD();
                }
            }
            if (offset) {
                BattlegearUtils.refreshAttributes(entityPlayer);
            }
            if (!itemInteract && BattlegearUtils.isPlayerInBattlemode(entityPlayer) && !MinecraftForge.EVENT_BUS.post((Event)(offAttackEvent = new PlayerEventChild.OffhandAttackEvent(event, offhandItem = ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon())))) {
                if (offAttackEvent.swingOffhand) {
                    BattlegearUtils.sendOffSwingEvent((PlayerEvent)event, offAttackEvent.offHand);
                }
                if (offAttackEvent.shouldAttack) {
                    ((IBattlePlayer)entityPlayer).attackTargetEntityWithCurrentOffItem(offAttackEvent.getTarget());
                }
                if (offAttackEvent.cancelParent) {
                    return true;
                }
            }
            return itemInteract;
        }
        if (itemstack != null && itemstack == entityPlayer.func_71045_bC()) {
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                if (itemstack.field_77994_a <= 0) {
                    entityPlayer.func_71028_bD();
                }
            } else if (itemstack.field_77994_a < copyStack.field_77994_a) {
                itemstack.field_77994_a = copyStack.field_77994_a;
            }
        }
        if (offset) {
            BattlegearUtils.refreshAttributes(entityPlayer);
        }
        return true;
    }

    public static void sendOffSwingEvent(PlayerEvent event, ItemStack offhandItem) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new PlayerEventChild.OffhandSwingEvent(event, offhandItem))) {
            ((IBattlePlayer)event.entityPlayer).swingOffItem();
        }
    }

    public static ItemStack refreshAttributes(EntityPlayer entityPlayer) {
        ItemStack oldItem = entityPlayer.func_71045_bC();
        ((InventoryPlayerBattle)entityPlayer.field_71071_by).swapHandItem();
        ItemStack newStack = entityPlayer.func_71045_bC();
        BattlegearUtils.refreshAttributes(entityPlayer.func_110140_aT(), oldItem, newStack);
        return newStack;
    }

    public static void refreshAttributes(BaseAttributeMap attributeMap, ItemStack oldItem, ItemStack currentItem) {
        if (oldItem != null) {
            attributeMap.func_111148_a(oldItem.func_111283_C());
        }
        if (currentItem != null) {
            attributeMap.func_111147_b(currentItem.func_111283_C());
        }
    }

    public static void closeStream(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ItemStack beforeFinishUseEvent(EntityPlayer entityPlayer, ItemStack itemInUse, int itemInUseCount, ItemStack result, int previousStackSize) {
        result = ForgeEventFactory.onItemUseFinish((EntityPlayer)entityPlayer, (ItemStack)itemInUse, (int)itemInUseCount, (ItemStack)result);
        if (BattlegearUtils.isPlayerInBattlemode(entityPlayer)) {
            if (result != itemInUse || result != null && result.field_77994_a != previousStackSize) {
                if (itemInUse == entityPlayer.func_71045_bC()) {
                    if (result != null && result.field_77994_a == 0) {
                        BattlegearUtils.setPlayerCurrentItem(entityPlayer, null);
                    } else {
                        BattlegearUtils.setPlayerCurrentItem(entityPlayer, result);
                    }
                } else if (itemInUse == ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon()) {
                    if (result != null && result.field_77994_a == 0) {
                        BattlegearUtils.setPlayerOffhandItem(entityPlayer, null);
                    } else {
                        BattlegearUtils.setPlayerOffhandItem(entityPlayer, result);
                    }
                }
            }
            entityPlayer.func_71041_bz();
            return null;
        }
        return result;
    }

    public static ItemStack getCurrentItemOnUpdate(EntityPlayer entityPlayer, ItemStack itemInUse) {
        ItemStack itemStack;
        if (BattlegearUtils.isPlayerInBattlemode(entityPlayer) && itemInUse == (itemStack = ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon())) {
            return itemStack;
        }
        return entityPlayer.func_71045_bC();
    }

    public static void onBowStackDepleted(EntityPlayer entityPlayer, ItemStack itemStack) {
        if (itemStack == entityPlayer.func_71045_bC()) {
            entityPlayer.func_71028_bD();
        } else {
            ItemStack orig = ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon();
            if (orig == itemStack) {
                BattlegearUtils.setPlayerOffhandItem(entityPlayer, null);
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)entityPlayer, (ItemStack)orig);
            }
        }
    }

    static {
        genericAttack = SharedMonsterAttributes.field_111264_e.func_111108_a();
    }
}

