/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import mods.battlegear2.Battlegear;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.packet.BattlegearSyncItemPacket;
import mods.battlegear2.packet.LoginPacket;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public final class BattlegearTickHandeler {
    public static final BattlegearTickHandeler INSTANCE = new BattlegearTickHandeler();

    private BattlegearTickHandeler() {
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart(event.player);
        } else {
            this.tickEnd(event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            Battlegear.packetHandler.sendPacketToPlayer(new LoginPacket().generatePacket(), (EntityPlayerMP)event.player);
        }
    }

    public void tickStart(EntityPlayer entityPlayer) {
        if (!entityPlayer.field_70170_p.field_72995_K && entityPlayer.field_70170_p instanceof WorldServer) {
            if (((InventoryPlayerBattle)entityPlayer.field_71071_by).hasChanged) {
                ((WorldServer)entityPlayer.field_70170_p).func_73039_n().func_151248_b((Entity)entityPlayer, (Packet)new BattlegearSyncItemPacket(entityPlayer).generatePacket());
                ((IBattlePlayer)entityPlayer).setSpecialActionTimer(0);
                ((InventoryPlayerBattle)entityPlayer.field_71071_by).hasChanged = entityPlayer.field_70173_aa < 10;
            } else if (((IBattlePlayer)entityPlayer).isBattlemode() && entityPlayer.field_70173_aa % BattlegearConfig.updateRate == 0 && !entityPlayer.func_71039_bw()) {
                ((WorldServer)entityPlayer.field_70170_p).func_73039_n().func_151248_b((Entity)entityPlayer, (Packet)new BattlegearSyncItemPacket(entityPlayer).generatePacket());
            }
        }
    }

    public void tickEnd(EntityPlayer entityPlayer) {
        int timer = ((IBattlePlayer)entityPlayer).getSpecialActionTimer();
        if (timer > 0) {
            ((IBattlePlayer)entityPlayer).setSpecialActionTimer(timer - 1);
            int targetTime = -1;
            ItemStack offhand = ((InventoryPlayerBattle)entityPlayer.field_71071_by).getCurrentOffhandWeapon();
            if (offhand != null && offhand.func_77973_b() instanceof IShield) {
                targetTime = ((IShield)offhand.func_77973_b()).getBashTimer(offhand) / 2;
            } else {
                offhand = QuiverArrowRegistry.getArrowContainer(entityPlayer);
                if (offhand != null) {
                    targetTime = 0;
                }
            }
            if (timer - 1 == targetTime) {
                Battlegear.proxy.doSpecialAction(entityPlayer, offhand);
            }
        }
    }
}

