/*
 * Decompiled with CFR 0.152.
 */
package mods.mud.gui;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import mods.mud.ModUpdateDetector;
import mods.mud.Release;
import mods.mud.UpdateChecker;
import mods.mud.UpdateEntry;
import mods.mud.gui.GuiSlotModList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;

public class GuiChangelogDownload
extends GuiScreen {
    private GuiSlotModList modList;
    private int selected = -1;
    private UpdateEntry selectedMod;
    private ArrayList<UpdateEntry> entries;
    private String[] changelog;
    int lineStart = 0;
    private GuiButton disable;
    private GuiButton download;
    private GuiButton close1;
    private GuiButton ok;
    private GuiButton urlButton;
    private boolean isDownloading = false;
    private boolean downloadComplete = false;
    private boolean downloadFailed = false;
    private float downloadPercent;
    private String message;
    private GuiScreen parent;
    private char[] bullets = new char[]{'\u2219', '\u25e6', '\u2023'};
    private int[] bulletWidth = new int[3];
    private Thread getChangeLogThread;

    public GuiChangelogDownload(GuiScreen parent) {
        this.parent = parent;
        this.changelog = new String[]{StatCollector.func_74838_a((String)"log.message.loading")};
        this.entries = new ArrayList<UpdateEntry>(ModUpdateDetector.getAllUpdateEntries());
        if (!ModUpdateDetector.hasChecked && !ModUpdateDetector.isChecking()) {
            Thread thread = new Thread(new UpdateChecker(this.entries));
            thread.setDaemon(true);
            thread.start();
        }
    }

    public GuiChangelogDownload() {
        this(null);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.modList = new GuiSlotModList(this, this.entries, 100);
        this.modList.registerScrollButtons(this.field_146292_n, 1, 2);
        for (int i = 0; i < this.bullets.length; ++i) {
            this.bulletWidth[i] = this.field_146289_q.func_78256_a(this.bullets[i] + " ");
        }
        this.disable = new GuiButton(3, 15, 10, 125, 20, StatCollector.func_74837_a((String)"mud.disable", (Object[])new Object[]{!ModUpdateDetector.enabled}));
        this.download = new GuiButton(4, 15, this.field_146295_m - 35, 125, 20, StatCollector.func_74838_a((String)"button.download.latest"));
        this.download.field_146124_l = false;
        this.close1 = new GuiButton(5, this.field_146294_l - 140, this.field_146295_m - 35, 125, 20, StatCollector.func_74838_a((String)"gui.done"));
        this.ok = new GuiButton(6, (this.field_146294_l - 200) / 2 + 5, (this.field_146295_m - 150) / 2 + 115, 190, 20, StatCollector.func_74838_a((String)"button.ok"));
        this.urlButton = new GuiButton(7, (this.field_146294_l - 125) / 2, this.field_146295_m - 35, 125, 20, StatCollector.func_74838_a((String)"button.url"));
        this.urlButton.field_146124_l = false;
        this.ok.field_146125_m = this.isDownloading;
        this.ok.field_146124_l = this.downloadComplete || this.downloadFailed;
        this.field_146292_n.add(this.disable);
        this.field_146292_n.add(this.download);
        this.field_146292_n.add(this.close1);
        this.field_146292_n.add(this.ok);
        this.field_146292_n.add(this.urlButton);
    }

    protected void func_73869_a(char par1, int par2) {
        if (!this.isDownloading && par2 == 1) {
            this.field_146297_k.func_147108_a(this.parent);
            this.field_146297_k.func_71381_h();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l && (!this.isDownloading || this.downloadFailed || this.downloadComplete)) {
            switch (button.field_146127_k) {
                case 3: {
                    this.isDownloading = false;
                    this.close1.field_146124_l = true;
                    ModUpdateDetector.toggleState();
                    this.disable.field_146126_j = StatCollector.func_74837_a((String)"mud.disable", (Object[])new Object[]{!ModUpdateDetector.enabled});
                    return;
                }
                case 4: {
                    if (this.selectedMod.getLatest() != null) {
                        File mcSource = this.selectedMod.getMc().getSource();
                        String filename = this.selectedMod.getFileName("1.8");
                        File newFile = new File(mcSource.getParent(), filename);
                        Thread t = new Thread(new Downloader(this.selectedMod.getLatest(), newFile, mcSource));
                        t.start();
                        this.isDownloading = true;
                        this.ok.field_146125_m = true;
                        this.close1.field_146124_l = false;
                        this.download.field_146124_l = false;
                        this.urlButton.field_146124_l = false;
                    }
                    return;
                }
                case 5: {
                    this.field_146297_k.func_147108_a(this.parent);
                    return;
                }
                case 6: {
                    this.isDownloading = false;
                    this.downloadComplete = false;
                    this.downloadFailed = false;
                    this.ok.field_146125_m = false;
                    this.close1.field_146124_l = true;
                    this.urlButton.field_146124_l = true;
                    return;
                }
                case 7: {
                    if (this.selectedMod != null && this.selectedMod.getLatest() != null && this.selectedMod.getLatest().url != null) {
                        try {
                            Desktop.getDesktop().browse(new URI(this.selectedMod.getLatest().url));
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                    return;
                }
            }
        }
        super.func_146284_a(button);
    }

    public void func_146276_q_() {
        super.func_146278_c(0);
    }

    public void func_73863_a(int p_571_1_, int p_571_2_, float p_571_3_) {
        if (this.modList != null) {
            this.modList.drawScreen(p_571_1_, p_571_2_, p_571_3_);
        }
        if (this.selectedMod != null) {
            int start = 32;
            for (int i = this.lineStart; i < this.changelog.length && start < this.field_146295_m - 52; ++i) {
                start = this.drawText(this.changelog[i], start);
            }
        }
        int mouse_x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouse_y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (mouse_x > 125 && mouse_y > 35 && mouse_y < this.field_146295_m - 50) {
            int scroll = Mouse.getDWheel();
            if (scroll < 0 && this.lineStart < this.changelog.length - 15) {
                ++this.lineStart;
            }
            if (scroll > 0 && this.lineStart > 0) {
                --this.lineStart;
            }
        }
        if (this.isDownloading) {
            this.ok.field_146125_m = true;
            int x = (this.field_146294_l - 200) / 2;
            int y = (this.field_146295_m - 150) / 2;
            GuiChangelogDownload.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 201), (int)(y + 151), (int)-1);
            GuiChangelogDownload.func_73734_a((int)x, (int)y, (int)(x + 200), (int)(y + 150), (int)-16777216);
            this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)"gui.downloading"), this.field_146294_l / 2, y + 15, -256);
            GuiChangelogDownload.func_73734_a((int)(x + 24), (int)(y + 39), (int)(x + 176), (int)(y + 56), (int)-1);
            GuiChangelogDownload.func_73734_a((int)(x + 25), (int)(y + 40), (int)(x + 25 + 150), (int)(y + 55), (int)-16777216);
            GuiChangelogDownload.func_73734_a((int)(x + 25), (int)(y + 40), (int)((int)((float)(x + 25) + 150.0f * this.downloadPercent)), (int)(y + 55), (int)-4144960);
            this.func_73728_b((int)((float)(x + 25) + 150.0f * this.downloadPercent) - 1, y + 39, y + 55, -8355712);
            this.func_73730_a(x + 25, (int)((float)(x + 25) + 150.0f * this.downloadPercent) - 1, y + 54, -8355712);
            if (this.downloadComplete) {
                this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)"gui.download.complete"), this.field_146294_l / 2, y + 70, -12255420);
            }
            if (this.downloadFailed) {
                this.func_73732_a(this.field_146289_q, StatCollector.func_74838_a((String)"gui.download.failed"), this.field_146294_l / 2, y + 70, -65536);
            }
            if (this.message != null) {
                this.func_73732_a(this.field_146289_q, this.message, this.field_146294_l / 2, y + 85, -1);
            }
            this.ok.func_146112_a(this.field_146297_k, p_571_1_, p_571_2_);
        }
        super.func_73863_a(p_571_1_, p_571_2_, p_571_3_);
    }

    private int drawText(String line, int start) {
        int startX = 125;
        if (line == null) {
            return 5;
        }
        if (line.startsWith("==") && line.substring(2).contains("==")) {
            String main = line.substring(2, line.lastIndexOf("==")).trim();
            float scale = 1.0f;
            GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            this.func_73731_b(this.field_146289_q, main.replaceAll("=", "").trim(), (int)((float)startX * scale), (int)((float)start * scale), -256);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (line.lastIndexOf("==") + 2 <= line.length()) {
                String sub = line.substring(line.lastIndexOf("==") + 2, line.length()).trim();
                GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
                this.func_73731_b(this.field_146289_q, sub.replaceAll("=", "").trim(), (int)((float)(startX + this.field_146289_q.func_78256_a(main + "   ")) * scale), (int)((float)start * scale), -14540033);
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            }
            return (int)(1.0f / scale * 10.0f) + start;
        }
        if (line.trim().startsWith("**") && line.trim().endsWith("**")) {
            float scale = 1.1f;
            GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            this.func_73731_b(this.field_146289_q, line.replaceAll("\\*\\*", "").trim(), (int)((float)startX * scale), (int)((float)start * scale), -1);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            return (int)(1.0f / scale * 10.0f) + start;
        }
        float scale = 1.2f;
        GlStateManager.func_179152_a((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        int bullet = -1;
        while (line.startsWith("*")) {
            startX += 10;
            line = line.substring(1).trim();
            ++bullet;
        }
        if (bullet > 3) {
            bullet = 3;
        }
        List lineList = this.field_146289_q.func_78271_c(line, this.field_146294_l - 10 - startX);
        Iterator it = lineList.iterator();
        int i = 0;
        while (it.hasNext()) {
            String subline = ((String)it.next()).trim();
            if (i == 0 && bullet > -1) {
                subline = this.bullets[bullet] + " " + subline;
            } else if (bullet > -1) {
                startX += this.bulletWidth[bullet];
            }
            this.func_73731_b(this.field_146289_q, subline, (int)((float)startX * scale), (int)((float)start * scale), -1);
            start += (int)(1.0f / scale * 10.0f);
            ++i;
        }
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        return start;
    }

    Minecraft getMinecraftInstance() {
        return this.field_146297_k;
    }

    FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public void selectModIndex(int var1) {
        if (this.getChangeLogThread == null || !this.getChangeLogThread.isAlive()) {
            this.selected = var1;
            this.selectedMod = var1 >= 0 && var1 <= this.entries.size() ? this.entries.get(this.selected) : null;
            boolean bl = this.urlButton.field_146124_l = this.selectedMod != null && this.selectedMod.getLatest() != null && this.selectedMod.getLatest().url != null;
            if (this.selectedMod != null) {
                if (this.selectedMod.getChangelogURL() == null) {
                    this.changelog = new String[]{StatCollector.func_74838_a((String)"log.message.none")};
                } else {
                    this.getChangeLogThread = new Thread(new ChangelogLoader(this.selectedMod.getChangelogURL()));
                    this.getChangeLogThread.start();
                    this.changelog = new String[]{StatCollector.func_74838_a((String)"log.message.loading")};
                }
                try {
                    if (!this.selectedMod.isUpToDate()) {
                        this.download.field_146124_l = true;
                        this.download.field_146126_j = StatCollector.func_74838_a((String)"button.download.latest");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean modIndexSelected(int var1) {
        return var1 == this.selected;
    }

    String bytArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    static /* synthetic */ String[] access$102(GuiChangelogDownload x0, String[] x1) {
        x0.changelog = x1;
        return x1;
    }

    private class StreamDrain
    implements Runnable {
        private final InputStream stream;

        StreamDrain(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            BufferedReader br = null;
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(this.stream));
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (Throwable e) {
                System.out.println(e.getLocalizedMessage());
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception line) {}
                }
            }
        }
    }

    private class Downloader
    implements Runnable {
        private String downloadUrl = "";
        private File file;
        private File original;
        private byte[] expectedMd5;
        private final boolean sameName;

        public Downloader(Release latest, File location, File originalFile) {
            this(latest.download, location, originalFile, latest.md5);
        }

        public Downloader(String url, File location, File originalFile, String md5) {
            if (url == null || location == null || originalFile == null) {
                throw new IllegalArgumentException("Download url or file locations can't be null");
            }
            this.downloadUrl = url;
            this.file = location;
            this.original = originalFile;
            this.sameName = location.getName().equals(originalFile.getName());
            if (md5 != null) {
                try {
                    this.expectedMd5 = DatatypeConverter.parseHexBinary((String)md5.toUpperCase(Locale.ENGLISH));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    this.expectedMd5 = null;
                }
            }
        }

        @Override
        public void run() {
            try {
                block14: {
                    int i;
                    GuiChangelogDownload.this.isDownloading = true;
                    if (this.file.exists()) {
                        this.file.delete();
                    }
                    this.file.createNewFile();
                    URLConnection connection = new URL(this.downloadUrl).openConnection();
                    int filesize = connection.getContentLength();
                    float totalDataRead = 0.0f;
                    BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                    FileOutputStream fos = new FileOutputStream(this.file);
                    BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
                    byte[] data = new byte[1024];
                    while ((i = in.read(data, 0, 1024)) >= 0) {
                        bout.write(data, 0, i);
                        GuiChangelogDownload.this.downloadPercent = (totalDataRead += (float)i) / (float)filesize;
                    }
                    bout.close();
                    in.close();
                    if (this.expectedMd5 != null) {
                        FilterInputStream dis = null;
                        try {
                            MessageDigest md = MessageDigest.getInstance("MD5");
                            byte[] fileData = new byte[(int)this.file.length()];
                            dis = new DataInputStream(new FileInputStream(this.file));
                            ((DataInputStream)dis).readFully(fileData);
                            dis.close();
                            byte[] md5 = md.digest(fileData);
                            ModUpdateDetector.logger.trace("Expected MD5: " + GuiChangelogDownload.this.bytArrayToHex(this.expectedMd5));
                            ModUpdateDetector.logger.trace("File MD5: " + GuiChangelogDownload.this.bytArrayToHex(md5));
                            if (Arrays.equals(md5, this.expectedMd5)) {
                                GuiChangelogDownload.this.downloadComplete = true;
                                ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_146124_l = true;
                                GuiChangelogDownload.this.message = StatCollector.func_74838_a((String)"gui.restart");
                                break block14;
                            }
                            GuiChangelogDownload.this.downloadComplete = false;
                            GuiChangelogDownload.this.downloadFailed = true;
                            ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_146124_l = true;
                            GuiChangelogDownload.this.message = StatCollector.func_74838_a((String)"gui.md5.fail");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (dis != null) {
                                try {
                                    dis.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            GuiChangelogDownload.this.downloadFailed = true;
                            ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_146124_l = true;
                        }
                    } else {
                        GuiChangelogDownload.this.downloadComplete = true;
                        ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_146124_l = true;
                        GuiChangelogDownload.this.message = StatCollector.func_74838_a((String)"gui.restart");
                    }
                }
                if (GuiChangelogDownload.this.downloadComplete && ModUpdateDetector.deleteOnComplete()) {
                    this.forceDeleting(this.original, this.file.getAbsolutePath());
                }
                if (GuiChangelogDownload.this.downloadFailed && ModUpdateDetector.deleteOnFailure()) {
                    this.forceDeleting(this.file, this.original.getAbsolutePath());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                GuiChangelogDownload.this.message = StatCollector.func_74838_a((String)e.getLocalizedMessage());
                GuiChangelogDownload.this.downloadFailed = true;
                ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_146124_l = true;
            }
        }

        private void forceDeleting(File fileToDelete, String classPath) {
            if (fileToDelete != null && fileToDelete.exists() && !this.sameName && !fileToDelete.isDirectory()) {
                ModUpdateDetector.logger.trace("Deleting: " + fileToDelete.getAbsolutePath());
                if (!fileToDelete.delete()) {
                    ModUpdateDetector.logger.trace("Deleting failed, spawning new process to delete");
                    String[] cmd = new String[]{"java", "-classpath", classPath, "mods.mud.utils.FileDeleter", fileToDelete.getAbsolutePath()};
                    try {
                        Process proc = new ProcessBuilder(cmd).redirectErrorStream(true).start();
                        new Thread(new StreamDrain(proc.getInputStream())).start();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class ChangelogLoader
    implements Runnable {
        private final URL changelogURL;

        private ChangelogLoader(URL changelogURL) {
            if (changelogURL == null) {
                throw new IllegalArgumentException("Changelog URL can't be null");
            }
            this.changelogURL = changelogURL;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.changelogURL.openStream()));
                String line = br.readLine();
                ArrayList<String> lines = new ArrayList<String>(100);
                while (line != null) {
                    lines.add(line);
                    line = br.readLine();
                }
                lines.trimToSize();
                GuiChangelogDownload.access$102(GuiChangelogDownload.this, lines.toArray(new String[lines.size()]));
            }
            catch (Throwable e) {
                e.printStackTrace();
                GuiChangelogDownload.access$102(GuiChangelogDownload.this, new String[]{StatCollector.func_74838_a((String)"log.message.fail")});
            }
        }
    }
}

