/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.items;

import java.util.List;
import mods.battlegear2.api.EnchantmentHelper;
import mods.battlegear2.api.IDyable;
import mods.battlegear2.api.IEnchantable;
import mods.battlegear2.api.ISheathed;
import mods.battlegear2.api.shield.IArrowCatcher;
import mods.battlegear2.api.shield.IArrowDisplay;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.api.shield.ShieldType;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemShield
extends Item
implements IShield,
IDyable,
IEnchantable,
ISheathed,
IArrowCatcher,
IArrowDisplay,
IFuelHandler {
    public ShieldType enumShield;

    public ItemShield(ShieldType enumShield) {
        this.func_77637_a(BattlegearConfig.customTab);
        this.enumShield = enumShield;
        this.func_77655_b("battlegear2:shield." + enumShield.getName());
        this.func_77656_e(enumShield.getMaxDamage());
        this.func_77625_d(1);
        this.func_77627_a(false);
        GameRegistry.registerItem((Item)this, (String)("shield." + enumShield.getName()));
    }

    @Override
    public boolean catchArrow(ItemStack shield, EntityPlayer player, IProjectile arrow) {
        if (arrow instanceof EntityArrow) {
            this.setArrowCount(shield, this.getArrowCount(shield) + 1);
            player.func_85034_r(player.func_85035_bI() - 1);
            ((EntityArrow)arrow).func_70106_y();
            return true;
        }
        return false;
    }

    @Override
    public int getArrowCount(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("arrows")) {
            return stack.func_77978_p().func_74765_d("arrows");
        }
        return 0;
    }

    @Override
    public void setArrowCount(ItemStack stack, int count) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (count > Short.MAX_VALUE) {
            count = Short.MAX_VALUE;
        }
        stack.func_77978_p().func_74777_a("arrows", (short)count);
    }

    @Override
    public float getDecayRate(ItemStack shield) {
        int use = EnchantmentHelper.getEnchantmentLevel(BaseEnchantment.shieldUsage, shield);
        return this.enumShield.getDecayRate() * (1.0f - (float)use * 0.1f);
    }

    @Override
    public float getRecoveryRate(ItemStack shield) {
        int recover = EnchantmentHelper.getEnchantmentLevel(BaseEnchantment.shieldRecover, shield);
        return 0.01f * (1.0f + (float)recover * 0.2f);
    }

    @Override
    public boolean canBlock(ItemStack shield, DamageSource source) {
        return !source.func_76363_c();
    }

    @Override
    public void blockAnimation(EntityPlayer player, float dmg) {
        player.field_70170_p.func_72956_a((Entity)player, "battlegear2:shield", 1.0f, 1.0f);
    }

    @Override
    public float getDamageReduction(ItemStack shield, DamageSource source) {
        return 0.0f;
    }

    @Override
    public float getDamageDecayRate(ItemStack shield, float amount) {
        return this.enumShield.getDamageDecay() * amount;
    }

    @Override
    public float getBlockAngle(ItemStack shield) {
        return 60.0f;
    }

    @Override
    public int getBashTimer(ItemStack shield) {
        return 10;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        par3List.add("");
        par3List.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"attribute.shield.block.time", (Object[])new Object[]{ItemStack.field_111284_a.format(1.0f / this.enumShield.getDecayRate() / 20.0f)}));
        int arrowCount = this.getArrowCount(par1ItemStack);
        if (arrowCount > 0) {
            par3List.add(EnumChatFormatting.GOLD + StatCollector.func_74837_a((String)"attribute.shield.arrow.count", (Object[])new Object[]{arrowCount}));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        if (renderPass == 0 || this.enumShield == ShieldType.WOOD && renderPass < 2) {
            return this.getColor(stack);
        }
        return super.func_82790_a(stack, renderPass);
    }

    @Override
    public boolean hasColor(ItemStack par1ItemStack) {
        return par1ItemStack.func_77942_o() && par1ItemStack.func_77978_p().func_74764_b("display") && par1ItemStack.func_77978_p().func_74775_l("display").func_74764_b("color");
    }

    @Override
    public int getColor(ItemStack par1ItemStack) {
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound == null) {
            return this.getDefaultColor(par1ItemStack);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        return nbttagcompound1 == null ? this.getDefaultColor(par1ItemStack) : (nbttagcompound1.func_74764_b("color") ? nbttagcompound1.func_74762_e("color") : this.getDefaultColor(par1ItemStack));
    }

    @Override
    public void removeColor(ItemStack par1ItemStack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")).func_74764_b("color")) {
            nbttagcompound1.func_82580_o("color");
        }
    }

    @Override
    public int getDefaultColor(ItemStack par1ItemStack) {
        return this.enumShield.getDefaultRGB();
    }

    @Override
    public void setColor(ItemStack par1ItemStack, int par2) {
        NBTTagCompound nbttagcompound = par1ItemStack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            par1ItemStack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_74764_b("display")) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", par2);
    }

    @Override
    public boolean isEnchantable(Enchantment baseEnchantment, ItemStack stack) {
        return baseEnchantment.field_77351_y == EnumEnchantmentType.ALL;
    }

    public int func_77619_b() {
        return this.enumShield.getEnchantability();
    }

    @Override
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack repair) {
        return this.enumShield.canBeRepairedWith(repair);
    }

    public int getBurnTime(ItemStack fuel) {
        if (fuel.func_77973_b() == this) {
            return 300;
        }
        return 0;
    }
}

