/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.List;
import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerBase;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class NetServerHandlerTransformer
extends TransformerBase {
    private String packet16BlockItemSwitchClassName;
    private String entityPlayerMPClassName;
    private String entityPlayerClassName;
    private String netServiceHandelerClassName;
    private String inventoryPlayerClassName;
    private String itemStackClassName;
    private String slotClassName;
    private String playerInventoryFieldName;
    private String getItemSwitchId;
    private String netServiceHandelerPlayerField;
    private String handleBlockSwitchMethodName;
    private String handleBlockSwitchMethodDesc;
    private String handlePlaceMethodName;
    private String handlePlaceMethodDesc;
    private String inventoryGetCurrentMethodName;
    private String inventoryGetCurrentMethodDesc;
    private String itemStackCopyStackMethodName;
    private String itemStackCopyStackMethodDesc;

    public NetServerHandlerTransformer() {
        super("net.minecraft.network.NetHandlerPlayServer");
        this.setDebug(true);
    }

    @Override
    boolean processMethods(List<MethodNode> methods) {
        int found = 0;
        for (MethodNode mn : methods) {
            if (mn.name.equals(this.handleBlockSwitchMethodName) && mn.desc.equals(this.handleBlockSwitchMethodDesc)) {
                if (!this.processSwitchBlockMethod(mn)) continue;
                ++found;
                continue;
            }
            if (!mn.name.equals(this.handlePlaceMethodName) || !mn.desc.equals(this.handlePlaceMethodDesc) || !this.processPlaceMethod(mn)) continue;
            ++found;
        }
        return found == 2;
    }

    private boolean processPlaceMethod(MethodNode mn) {
        this.sendPatchLog("processPlayerBlockPlacement");
        InsnList newList = new InsnList();
        ListIterator it = mn.instructions.iterator();
        int fieldCount = 0;
        while (it.hasNext()) {
            AbstractInsnNode nextNode = (AbstractInsnNode)it.next();
            if (nextNode instanceof FieldInsnNode && ((FieldInsnNode)nextNode).owner.equals(this.entityPlayerMPClassName) && ((FieldInsnNode)nextNode).name.equals(this.playerInventoryFieldName)) {
                if (++fieldCount == 3) {
                    while (it.hasNext() && nextNode.getOpcode() != 1) {
                        nextNode = (AbstractInsnNode)it.next();
                    }
                    newList.add(nextNode);
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "setPlayerCurrentItem", "(L" + this.entityPlayerClassName + ";L" + this.itemStackClassName + ";)V"));
                    it.next();
                    continue;
                }
                if (fieldCount == 4) {
                    while (it.hasNext() && nextNode.getOpcode() != 83) {
                        nextNode = (AbstractInsnNode)it.next();
                    }
                    newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newList.add((AbstractInsnNode)new FieldInsnNode(180, this.netServiceHandelerClassName, this.netServiceHandelerPlayerField, "L" + this.entityPlayerMPClassName + ";"));
                    newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerMPClassName, this.playerInventoryFieldName, "L" + this.inventoryPlayerClassName + ";"));
                    newList.add((AbstractInsnNode)new MethodInsnNode(182, this.inventoryPlayerClassName, this.inventoryGetCurrentMethodName, this.inventoryGetCurrentMethodDesc));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, this.itemStackClassName, this.itemStackCopyStackMethodName, this.itemStackCopyStackMethodDesc));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "setPlayerCurrentItem", "(L" + this.entityPlayerClassName + ";L" + this.itemStackClassName + ";)V"));
                    if (FMLCommonHandler.instance().getModName().contains("mcpc") || Launch.blackboard.containsKey("IsForkage")) continue;
                    int slotIndex = 0;
                    while (it.hasNext()) {
                        nextNode = (AbstractInsnNode)it.next();
                        newList.add(nextNode);
                        if (nextNode instanceof VarInsnNode && nextNode.getOpcode() == 58) {
                            slotIndex = ((VarInsnNode)nextNode).var;
                        }
                        if (!(nextNode instanceof FieldInsnNode) || nextNode.getOpcode() != 181) continue;
                    }
                    newList.add((AbstractInsnNode)it.next());
                    nextNode = (AbstractInsnNode)it.next();
                    newList.add(nextNode);
                    if (nextNode instanceof LineNumberNode && slotIndex != 0) {
                        int line = ((LineNumberNode)nextNode).line;
                        LabelNode L0 = new LabelNode();
                        newList.add((AbstractInsnNode)new VarInsnNode(25, slotIndex));
                        newList.add((AbstractInsnNode)new JumpInsnNode(199, L0));
                        newList.add((AbstractInsnNode)new InsnNode(177));
                        newList.add((AbstractInsnNode)L0);
                        newList.add((AbstractInsnNode)new LineNumberNode(line + 1, L0));
                        newList.add((AbstractInsnNode)new FrameNode(1, 1, new Object[]{this.slotClassName}, 0, null));
                        continue;
                    }
                    return false;
                }
                newList.add(nextNode);
                continue;
            }
            newList.add(nextNode);
        }
        mn.instructions = newList;
        return fieldCount > 4;
    }

    private boolean processSwitchBlockMethod(MethodNode mn) {
        this.sendPatchLog("processHeldItemChange");
        InsnList newList = new InsnList();
        ListIterator it = mn.instructions.iterator();
        boolean done = false;
        block0: while (it.hasNext()) {
            AbstractInsnNode nextInsn = (AbstractInsnNode)it.next();
            newList.add(nextInsn);
            if (done || !(nextInsn instanceof MethodInsnNode) || nextInsn.getOpcode() != 182 || !((MethodInsnNode)nextInsn).owner.equals(this.packet16BlockItemSwitchClassName) || !((MethodInsnNode)nextInsn).name.equals(this.getItemSwitchId)) continue;
            newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/InventoryPlayerBattle", "isValidSwitch", "(I)Z"));
            while (it.hasNext()) {
                if (nextInsn instanceof JumpInsnNode && nextInsn.getOpcode() == 162) {
                    newList.add((AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)nextInsn).label));
                    done = true;
                    continue block0;
                }
                nextInsn = (AbstractInsnNode)it.next();
            }
        }
        mn.instructions = newList;
        return done;
    }

    @Override
    boolean processFields(List<FieldNode> fields) {
        return true;
    }

    @Override
    void setupMappings() {
        this.netServiceHandelerClassName = BattlegearTranslator.getMapedClassName("network.NetHandlerPlayServer");
        this.packet16BlockItemSwitchClassName = BattlegearTranslator.getMapedClassName("network.play.client.C09PacketHeldItemChange");
        this.entityPlayerMPClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayerMP");
        this.inventoryPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.InventoryPlayer");
        this.itemStackClassName = BattlegearTranslator.getMapedClassName("item.ItemStack");
        this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer");
        this.slotClassName = BattlegearTranslator.getMapedClassName("inventory.Slot");
        this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("field_71071_by", "inventory");
        this.netServiceHandelerPlayerField = BattlegearTranslator.getMapedFieldName("field_147369_b", "playerEntity");
        this.getItemSwitchId = BattlegearTranslator.getMapedMethodName("func_149614_c", "getSlotId");
        this.handleBlockSwitchMethodName = BattlegearTranslator.getMapedMethodName("func_147355_a", "processHeldItemChange");
        this.handleBlockSwitchMethodDesc = "(L" + this.packet16BlockItemSwitchClassName + ";)V";
        this.handlePlaceMethodName = BattlegearTranslator.getMapedMethodName("func_147346_a", "processPlayerBlockPlacement");
        this.handlePlaceMethodDesc = "(Lnet/minecraft/network/play/client/C08PacketPlayerBlockPlacement;)V";
        this.inventoryGetCurrentMethodName = BattlegearTranslator.getMapedMethodName("func_70448_g", "getCurrentItem");
        this.inventoryGetCurrentMethodDesc = "()L" + this.itemStackClassName + ";";
        this.itemStackCopyStackMethodName = BattlegearTranslator.getMapedMethodName("func_77944_b", "copyItemStack");
        this.itemStackCopyStackMethodDesc = "(L" + this.itemStackClassName + ";)L" + this.itemStackClassName + ";";
    }
}

