/*
 * Decompiled with CFR 0.152.
 */
package mods.mud.gui;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import mods.mud.ModUpdateDetector;
import mods.mud.UpdateChecker;
import mods.mud.UpdateEntry;
import mods.mud.gui.GuiSlotModList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiChangelogDownload
extends GuiScreen {
    private GuiSlotModList modList;
    private int selected = -1;
    private UpdateEntry selectedMod;
    private int listWidth;
    private ArrayList<UpdateEntry> entries;
    private String[] changelog;
    int lineStart = 0;
    int scrollbarHeight = 24;
    int scrollLocHeight;
    private GuiButton download;
    private GuiButton close1;
    private GuiButton ok;
    private GuiButton urlButton;
    private boolean isDownloading = false;
    private boolean downloadComplete = false;
    private boolean downloadFailed = false;
    private float downloadPercent;
    private String message;
    private GuiScreen parent;
    private char[] bullets = new char[]{'\u2219', '\u25e6', '\u2023'};
    private int[] bulletWidth = new int[3];
    private Thread getChangeLogThread;

    public GuiChangelogDownload(GuiScreen parent) {
        this.parent = parent;
        this.changelog = new String[]{"Loading Changelog from server"};
        if (!ModUpdateDetector.hasChecked) {
            new UpdateChecker(ModUpdateDetector.getAllUpdateEntries()).run();
        }
        this.entries = new ArrayList<UpdateEntry>(ModUpdateDetector.getAllUpdateEntries());
    }

    public GuiChangelogDownload() {
        this(null);
    }

    public void func_73866_w_() {
        this.listWidth = 100;
        this.field_73887_h.clear();
        this.modList = new GuiSlotModList(this, this.entries, this.listWidth);
        this.modList.registerScrollButtons(this.field_73887_h, 7, 8);
        for (int i = 0; i < this.bullets.length; ++i) {
            this.bulletWidth[i] = this.field_73886_k.func_78256_a(this.bullets[i] + " ");
        }
        this.download = new GuiButton(4, 15, this.field_73881_g - 35, 125, 20, StatCollector.func_74838_a((String)"button.download.latest"));
        this.download.field_73742_g = false;
        this.close1 = new GuiButton(5, this.field_73880_f - 15 - 125, this.field_73881_g - 35, 125, 20, StatCollector.func_74838_a((String)"button.close"));
        this.ok = new GuiButton(6, (this.field_73880_f - 200) / 2 + 5, (this.field_73881_g - 150) / 2 + 115, 190, 20, StatCollector.func_74838_a((String)"button.ok"));
        this.urlButton = new GuiButton(7, (this.field_73880_f - 125) / 2, this.field_73881_g - 35, 125, 20, StatCollector.func_74838_a((String)"button.url"));
        this.urlButton.field_73742_g = false;
        this.ok.field_73748_h = this.isDownloading;
        this.ok.field_73742_g = this.downloadComplete || this.downloadFailed;
        this.field_73887_h.add(this.download);
        this.field_73887_h.add(this.close1);
        this.field_73887_h.add(this.ok);
        this.field_73887_h.add(this.urlButton);
    }

    protected void func_73869_a(char par1, int par2) {
        if (!this.isDownloading && par2 == 1) {
            this.field_73882_e.func_71373_a(this.parent);
            this.field_73882_e.func_71381_h();
        }
    }

    protected void func_73875_a(GuiButton button) {
        if (button.field_73742_g && (!this.isDownloading || this.downloadFailed || this.downloadComplete)) {
            switch (button.field_73741_f) {
                case 4: {
                    ModContainer mc = this.selectedMod.getMc();
                    String filename = String.format("[%s] %s - %s.jar", Loader.instance().getMCVersionString().replaceAll("Minecraft", "").trim(), mc.getName(), this.selectedMod.getLatest().getVersionString());
                    File newFile = new File(mc.getSource().getParent(), filename);
                    Thread t = new Thread(new Downloader(this.selectedMod.getLatest().download, newFile, mc.getSource(), this.selectedMod.getLatest().md5));
                    t.start();
                    this.isDownloading = true;
                    this.ok.field_73748_h = true;
                    this.close1.field_73742_g = false;
                    this.download.field_73742_g = false;
                    this.urlButton.field_73742_g = false;
                    return;
                }
                case 5: {
                    this.field_73882_e.func_71373_a(this.parent);
                    return;
                }
                case 6: {
                    this.isDownloading = false;
                    this.downloadComplete = false;
                    this.downloadFailed = false;
                    this.ok.field_73748_h = false;
                    this.close1.field_73742_g = true;
                    this.urlButton.field_73742_g = true;
                    return;
                }
                case 7: {
                    if (this.selectedMod != null && this.selectedMod.getLatest() != null && this.selectedMod.getLatest().url != null) {
                        try {
                            Desktop.getDesktop().browse(new URI(this.selectedMod.getLatest().url));
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    return;
                }
            }
        }
        super.func_73875_a(button);
    }

    public void func_73867_d() {
        super.func_73867_d();
    }

    public void func_73873_v_() {
        super.func_73871_c(0);
    }

    public void func_73863_a(int p_571_1_, int p_571_2_, float p_571_3_) {
        if (this.modList != null) {
            this.modList.drawScreen(p_571_1_, p_571_2_, p_571_3_);
        }
        if (this.selectedMod != null) {
            int start = 32;
            for (int i = this.lineStart; i < this.changelog.length && start < this.field_73881_g - 52; ++i) {
                start = this.drawText(this.changelog[i], start);
            }
        }
        int mouse_x = Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c;
        int mouse_y = this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1;
        if (mouse_x > 125 && mouse_y > 35 && mouse_y < this.field_73881_g - 50) {
            int scroll = Mouse.getDWheel();
            if (scroll < 0 && this.lineStart < this.changelog.length - 15) {
                ++this.lineStart;
            }
            if (scroll > 0 && this.lineStart > 0) {
                --this.lineStart;
            }
        }
        if (this.isDownloading) {
            this.ok.field_73748_h = true;
            int x = (this.field_73880_f - 200) / 2;
            int y = (this.field_73881_g - 150) / 2;
            GuiChangelogDownload.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 201), (int)(y + 151), (int)-1);
            GuiChangelogDownload.func_73734_a((int)x, (int)y, (int)(x + 200), (int)(y + 150), (int)-16777216);
            this.func_73732_a(this.field_73886_k, StatCollector.func_74838_a((String)"gui.downloading"), this.field_73880_f / 2, y + 15, -256);
            GuiChangelogDownload.func_73734_a((int)(x + 24), (int)(y + 39), (int)(x + 176), (int)(y + 56), (int)-1);
            GuiChangelogDownload.func_73734_a((int)(x + 25), (int)(y + 40), (int)(x + 25 + 150), (int)(y + 55), (int)-16777216);
            GuiChangelogDownload.func_73734_a((int)(x + 25), (int)(y + 40), (int)((int)((float)(x + 25) + 150.0f * this.downloadPercent)), (int)(y + 55), (int)-4144960);
            this.func_73728_b((int)((float)(x + 25) + 150.0f * this.downloadPercent) - 1, y + 39, y + 55, -8355712);
            this.func_73730_a(x + 25, (int)((float)(x + 25) + 150.0f * this.downloadPercent) - 1, y + 54, -8355712);
            if (this.downloadComplete) {
                this.func_73732_a(this.field_73886_k, StatCollector.func_74838_a((String)"gui.download.complete"), this.field_73880_f / 2, y + 70, -12255420);
            }
            if (this.downloadFailed) {
                this.func_73732_a(this.field_73886_k, StatCollector.func_74838_a((String)"gui.download.failed"), this.field_73880_f / 2, y + 70, -65536);
            }
            if (this.message != null) {
                this.func_73732_a(this.field_73886_k, this.message, this.field_73880_f / 2, y + 85, -1);
            }
            this.ok.func_73737_a(this.field_73882_e, p_571_1_, p_571_2_);
        }
        super.func_73863_a(p_571_1_, p_571_2_, p_571_3_);
    }

    private int drawText(String line, int start) {
        int startX = 125;
        if (line == null) {
            return 5;
        }
        if (line.startsWith("==") && line.substring(2).contains("==")) {
            String main = line.substring(2, line.lastIndexOf("==")).trim();
            float scale = 1.0f;
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            this.func_73731_b(this.field_73886_k, main.replaceAll("=", "").trim(), (int)((float)startX * scale), (int)((float)start * scale), -256);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            if (line.lastIndexOf("==") + 2 <= line.length()) {
                String sub = line.substring(line.lastIndexOf("==") + 2, line.length()).trim();
                GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
                this.func_73731_b(this.field_73886_k, sub.replaceAll("=", "").trim(), (int)((float)(startX + this.field_73886_k.func_78256_a(main + "   ")) * scale), (int)((float)start * scale), -14540033);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
            }
            return (int)(1.0f / scale * 10.0f) + start;
        }
        if (line.startsWith("**") && line.endsWith("**")) {
            float scale = 1.1f;
            GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
            this.func_73731_b(this.field_73886_k, line.replaceAll("\\*\\*", "").trim(), (int)((float)startX * scale), (int)((float)start * scale), -1);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            return (int)(1.0f / scale * 10.0f) + start;
        }
        float scale = 1.2f;
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        int bullet = -1;
        while (line.startsWith("*")) {
            startX += 10;
            line = line.substring(1).trim();
            ++bullet;
        }
        if (bullet > 3) {
            bullet = 3;
        }
        List lineList = this.field_73886_k.func_78271_c(line, this.field_73880_f - 10 - startX);
        Iterator it = lineList.iterator();
        int i = 0;
        while (it.hasNext()) {
            String subline = ((String)it.next()).trim();
            if (i == 0 && bullet > -1) {
                subline = this.bullets[bullet] + " " + subline;
            } else if (bullet > -1) {
                startX += this.bulletWidth[bullet];
            }
            this.func_73731_b(this.field_73886_k, subline, (int)((float)startX * scale), (int)((float)start * scale), -1);
            start += (int)(1.0f / scale * 10.0f);
            ++i;
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        return start;
    }

    Minecraft getMinecraftInstance() {
        return this.field_73882_e;
    }

    FontRenderer getFontRenderer() {
        return this.field_73886_k;
    }

    public void selectModIndex(int var1) {
        if (this.getChangeLogThread == null || !this.getChangeLogThread.isAlive()) {
            this.selected = var1;
            this.selectedMod = var1 >= 0 && var1 <= this.entries.size() ? this.entries.get(this.selected) : null;
            boolean bl = this.urlButton.field_73742_g = this.selectedMod != null && this.selectedMod.getLatest() != null && this.selectedMod.getLatest().url != null;
            if (this.selectedMod.getChangelogURL() == null) {
                this.changelog = new String[]{"No Changelog Provided"};
            } else {
                this.getChangeLogThread = new Thread(new ChangelogLoader(this.selectedMod.getChangelogURL()));
                this.getChangeLogThread.start();
                this.changelog = new String[]{"Loading changelog from server"};
            }
            try {
                if (!this.selectedMod.isUpToDate()) {
                    this.download.field_73742_g = true;
                    this.download.field_73744_e = StatCollector.func_74838_a((String)"button.download.latest");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean modIndexSelected(int var1) {
        return var1 == this.selected;
    }

    String bytArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }

    static /* synthetic */ String[] access$102(GuiChangelogDownload x0, String[] x1) {
        x0.changelog = x1;
        return x1;
    }

    private class Downloader
    implements Runnable {
        private String downloadUrl = "";
        private File file = null;
        private File orginial;
        private byte[] expectedMd5;

        public Downloader(String url, File location, File originalFile, String md5) {
            this.downloadUrl = url;
            this.file = location;
            this.orginial = originalFile;
            if (md5 != null) {
                try {
                    this.expectedMd5 = DatatypeConverter.parseHexBinary((String)md5.toUpperCase());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.expectedMd5 = null;
                }
            }
            System.out.println(md5);
        }

        @Override
        public void run() {
            try {
                block14: {
                    int i;
                    GuiChangelogDownload.this.isDownloading = true;
                    if (this.file.exists()) {
                        this.file.delete();
                    }
                    this.file.createNewFile();
                    URL url = new URL(this.downloadUrl);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    int filesize = connection.getContentLength();
                    float totalDataRead = 0.0f;
                    BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
                    FileOutputStream fos = new FileOutputStream(this.file);
                    BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
                    byte[] data = new byte[1024];
                    while ((i = in.read(data, 0, 1024)) >= 0) {
                        bout.write(data, 0, i);
                        GuiChangelogDownload.this.downloadPercent = (totalDataRead += (float)i) / (float)filesize;
                    }
                    bout.close();
                    in.close();
                    if (this.expectedMd5 != null) {
                        FilterInputStream dis = null;
                        try {
                            MessageDigest md = MessageDigest.getInstance("MD5");
                            byte[] fileData = new byte[(int)this.file.length()];
                            dis = new DataInputStream(new FileInputStream(this.file));
                            ((DataInputStream)dis).readFully(fileData);
                            dis.close();
                            byte[] md5 = md.digest(fileData);
                            System.out.println("Expected MD5: " + GuiChangelogDownload.this.bytArrayToHex(this.expectedMd5));
                            System.out.println("File MD5: " + GuiChangelogDownload.this.bytArrayToHex(md5));
                            if (Arrays.equals(md5, this.expectedMd5)) {
                                GuiChangelogDownload.this.downloadComplete = true;
                                ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_73742_g = true;
                                GuiChangelogDownload.this.message = StatCollector.func_74838_a((String)"gui.restart");
                                break block14;
                            }
                            GuiChangelogDownload.this.downloadComplete = false;
                            GuiChangelogDownload.this.downloadFailed = true;
                            ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_73742_g = true;
                            GuiChangelogDownload.this.message = StatCollector.func_74838_a((String)"gui.md5.fail");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (dis != null) {
                                try {
                                    dis.close();
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            GuiChangelogDownload.this.downloadFailed = true;
                            ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_73742_g = true;
                        }
                    } else {
                        GuiChangelogDownload.this.downloadComplete = true;
                        ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_73742_g = true;
                        GuiChangelogDownload.this.message = StatCollector.func_74838_a((String)"gui.restart");
                    }
                }
                if (GuiChangelogDownload.this.downloadComplete && this.orginial.exists() && !this.orginial.getName().equals(this.file.getName()) && !this.orginial.isDirectory()) {
                    System.out.println("Deleting: " + this.orginial.getAbsolutePath());
                    if (!this.orginial.delete()) {
                        System.out.println("Deleting failed, spawning new process to delete");
                        String cmd = "java -classpath \"" + this.file.getAbsolutePath() + "\" mods.mud.utils.FileDeleter \"" + this.orginial.getAbsolutePath() + "\"";
                        System.out.println(cmd);
                        Runtime.getRuntime().exec(cmd);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("Download failed");
                GuiChangelogDownload.this.message = StatCollector.func_74838_a((String)e.getLocalizedMessage());
                GuiChangelogDownload.this.downloadFailed = true;
                ((GuiChangelogDownload)GuiChangelogDownload.this).ok.field_73742_g = true;
            }
        }
    }

    private class ChangelogLoader
    implements Runnable {
        URL changelogURL;

        private ChangelogLoader(URL changelogURL) {
            this.changelogURL = changelogURL;
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.changelogURL.openStream()));
                String line = br.readLine();
                ArrayList<String> lines = new ArrayList<String>(100);
                if (line != null) {
                    lines.add(line);
                }
                while (line != null) {
                    line = br.readLine();
                    lines.add(line);
                }
                GuiChangelogDownload.access$102(GuiChangelogDownload.this, lines.toArray(new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
                GuiChangelogDownload.access$102(GuiChangelogDownload.this, new String[]{"Failed to download changelog"});
            }
        }
    }
}

