/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.ListIterator;
import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NetServerHandlerTransformer
implements IClassTransformer {
    private String packet16BlockItemSwitchClassName;
    private String entityPlayerMPClassName;
    private String entityPlayerClassName;
    private String netServiceHandelerClassName;
    private String inventoryPlayerClassName;
    private String itemStackClassName;
    private String playerInventoryFieldName;
    private String packet16BlockItemSwitchId;
    private String netServiceHandelerPlayerField;
    private String handleBlockSwitchMethodName;
    private String handleBlockSwitchMethodDesc;
    private String handlePlaceMethodName;
    private String handlePlaceMethodDesc;
    private String inventoryGetCurrentMethodName;
    private String inventoryGetCurrentMethodDesc;
    private String itemStackCopyStackMethodName;
    private String itemStackCopyStackMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.network.NetServerHandler")) {
            System.out.println("M&B - Patching Class NetServiceHandeler (" + name + ")");
            this.netServiceHandelerClassName = BattlegearTranslator.getMapedClassName("NetServerHandler");
            this.packet16BlockItemSwitchClassName = BattlegearTranslator.getMapedClassName("Packet16BlockItemSwitch");
            this.entityPlayerMPClassName = BattlegearTranslator.getMapedClassName("EntityPlayerMP");
            this.inventoryPlayerClassName = BattlegearTranslator.getMapedClassName("InventoryPlayer");
            this.itemStackClassName = BattlegearTranslator.getMapedClassName("ItemStack");
            this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("EntityPlayer");
            this.packet16BlockItemSwitchId = BattlegearTranslator.getMapedFieldName("Packet16BlockItemSwitch", "field_73386_a");
            this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by");
            this.netServiceHandelerPlayerField = BattlegearTranslator.getMapedFieldName("NetServerHandler", "field_72574_e");
            this.handleBlockSwitchMethodName = BattlegearTranslator.getMapedMethodName("NetServerHandler", "func_72502_a");
            this.handleBlockSwitchMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetServerHandler", "func_72502_a");
            this.handlePlaceMethodName = BattlegearTranslator.getMapedMethodName("NetServerHandler", "func_72472_a");
            this.handlePlaceMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetServerHandler", "func_72472_a");
            this.inventoryGetCurrentMethodName = BattlegearTranslator.getMapedMethodName("InventoryPlayer", "func_70448_g");
            this.inventoryGetCurrentMethodDesc = BattlegearTranslator.getMapedMethodDesc("InventoryPlayer", "func_70448_g");
            this.itemStackCopyStackMethodName = BattlegearTranslator.getMapedMethodName("ItemStack", "func_77944_b");
            this.itemStackCopyStackMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemStack", "func_77944_b");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            for (Object mnObj : cn.methods) {
                MethodNode mn = (MethodNode)mnObj;
                if (mn.name.equals(this.handleBlockSwitchMethodName) && mn.desc.equals(this.handleBlockSwitchMethodDesc)) {
                    this.processSwitchBlockMethod(mn);
                    continue;
                }
                if (!mn.name.equals(this.handlePlaceMethodName) || !mn.desc.equals(this.handlePlaceMethodDesc)) continue;
                this.processPlaceMethod(mn);
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class NetServiceHandeler done");
            if (BattlegearLoadingPlugin.debug) {
                TransformerUtils.writeClassFile(cw, name);
            }
            return cw.toByteArray();
        }
        return bytes;
    }

    private void processPlaceMethod(MethodNode mn) {
        System.out.println("\tPatching method handlePlace in NetServiceHandler");
        InsnList newList = new InsnList();
        ListIterator it = mn.instructions.iterator();
        int fieldCount = 0;
        while (it.hasNext()) {
            AbstractInsnNode nextNode = (AbstractInsnNode)it.next();
            if (nextNode instanceof FieldInsnNode && ((FieldInsnNode)nextNode).owner.equals(this.entityPlayerMPClassName) && ((FieldInsnNode)nextNode).name.equals(this.playerInventoryFieldName)) {
                if (++fieldCount == 3) {
                    while (it.hasNext() && nextNode.getOpcode() != 1) {
                        nextNode = (AbstractInsnNode)it.next();
                    }
                    newList.add(nextNode);
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/utils/BattlegearUtils", "setPlayerCurrentItem", "(L" + BattlegearTranslator.getMapedClassName("EntityPlayer") + ";L" + BattlegearTranslator.getMapedClassName("ItemStack") + ";)V"));
                    it.next();
                    continue;
                }
                if (fieldCount == 4) {
                    while (it.hasNext() && nextNode.getOpcode() != 83) {
                        nextNode = (AbstractInsnNode)it.next();
                    }
                    newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newList.add((AbstractInsnNode)new FieldInsnNode(180, this.netServiceHandelerClassName, this.netServiceHandelerPlayerField, "L" + this.entityPlayerMPClassName + ";"));
                    newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerMPClassName, this.playerInventoryFieldName, "L" + this.inventoryPlayerClassName + ";"));
                    newList.add((AbstractInsnNode)new MethodInsnNode(182, this.inventoryPlayerClassName, this.inventoryGetCurrentMethodName, this.inventoryGetCurrentMethodDesc));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, this.itemStackClassName, this.itemStackCopyStackMethodName, this.itemStackCopyStackMethodDesc));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/utils/BattlegearUtils", "setPlayerCurrentItem", "(L" + this.entityPlayerClassName + ";L" + this.itemStackClassName + ";)V"));
                    continue;
                }
                newList.add(nextNode);
                continue;
            }
            newList.add(nextNode);
        }
        mn.instructions = newList;
    }

    private void processSwitchBlockMethod(MethodNode mn) {
        System.out.println("\tPatching method handleBlockItemSwitch in NetServiceHandler");
        InsnList newList = new InsnList();
        ListIterator it = mn.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode nextInsn = (AbstractInsnNode)it.next();
            newList.add(nextInsn);
            if (!(nextInsn instanceof FieldInsnNode) || nextInsn.getOpcode() != 180 || !((FieldInsnNode)nextInsn).owner.equals(this.packet16BlockItemSwitchClassName) || !((FieldInsnNode)nextInsn).name.equals(this.packet16BlockItemSwitchId)) continue;
            newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/inventory/InventoryPlayerBattle", "isValidSwitch", "(I)Z"));
            nextInsn = (AbstractInsnNode)it.next();
            while (it.hasNext() && (!(nextInsn instanceof JumpInsnNode) || nextInsn.getOpcode() != 162)) {
                System.out.println(nextInsn.getClass());
                nextInsn = (AbstractInsnNode)it.next();
            }
            newList.add((AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)nextInsn).label));
            while (it.hasNext()) {
                nextInsn = (AbstractInsnNode)it.next();
                newList.add(nextInsn);
            }
        }
        mn.instructions = newList;
    }
}

