/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class MinecraftTransformer
implements IClassTransformer {
    private String entityClientPlayerClass;
    private String playerInventoryFieldName;
    private String clickMouseMethodName;
    private String clickMouseMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.client.Minecraft")) {
            this.entityClientPlayerClass = BattlegearTranslator.getMapedClassName("EntityClientPlayerMP");
            this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by");
            this.clickMouseMethodName = BattlegearTranslator.getMapedMethodName("Minecraft", "func_71402_c");
            this.clickMouseMethodDesc = BattlegearTranslator.getMapedMethodDesc("Minecraft", "func_71402_c");
            System.out.println("M&B - Patching Class Minecraft (" + name + ")");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            for (Object mnObj : cn.methods) {
                MethodNode method = (MethodNode)mnObj;
                if (!method.name.equals(this.clickMouseMethodName) || !method.desc.equals(this.clickMouseMethodDesc)) continue;
                System.out.println("\tPatching method Click Mouse in Minecraft");
                TransformerUtils.replaceInventoryArrayAccess(method, this.entityClientPlayerClass, this.playerInventoryFieldName, 5, 9, 10);
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class Minecraft (" + name + ") done");
            if (BattlegearLoadingPlugin.debug) {
                TransformerUtils.writeClassFile(cw, name);
            }
            return cw.toByteArray();
        }
        return bytes;
    }
}

