/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import mods.battlegear2.coremod.BattlegearLoadingPlugin;
import mods.battlegear2.coremod.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ItemInWorldTransformer
implements IClassTransformer {
    private String entityPlayerClassName;
    private String inventoryPlayerClassName;
    private String itemStackClassName;
    private String entityOtherPlayerMPClassName;
    private String playerInventoryFieldName;
    private String mainInventoryArrayFieldName;
    private String tryUseItemMethodName;
    private String tryUseItemMethodDesc;
    private String setInventorySlotMethodName;
    private String setInventorySlotMethodDesc;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.item.ItemInWorldManager")) {
            System.out.println("M&B - Patching Class ItemInWorldManager (" + name + ")");
            this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("EntityPlayer");
            this.inventoryPlayerClassName = BattlegearTranslator.getMapedClassName("InventoryPlayer");
            this.itemStackClassName = BattlegearTranslator.getMapedClassName("ItemStack");
            this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by");
            this.mainInventoryArrayFieldName = BattlegearTranslator.getMapedFieldName("InventoryPlayer", "field_70462_a");
            this.tryUseItemMethodName = BattlegearTranslator.getMapedMethodName("ItemInWorldManager", "func_73085_a");
            this.tryUseItemMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemInWorldManager", "func_73085_a");
            this.setInventorySlotMethodName = BattlegearTranslator.getMapedMethodName("InventoryPlayer", "func_70299_a");
            this.setInventorySlotMethodDesc = BattlegearTranslator.getMapedMethodDesc("InventoryPlayer", "func_70299_a");
            ClassReader cr = new ClassReader(bytes);
            ClassNode cn = new ClassNode(262144);
            cr.accept((ClassVisitor)cn, 0);
            for (Object mnObj : cn.methods) {
                MethodNode mn = (MethodNode)mnObj;
                if (!mn.name.equals(this.tryUseItemMethodName) || !mn.desc.equals(this.tryUseItemMethodDesc)) continue;
                this.processTryUseItemMethod(mn);
            }
            ClassWriter cw = new ClassWriter(0);
            cn.accept((ClassVisitor)cw);
            System.out.println("M&B - Patching Class ItemInWorldManager done");
            if (BattlegearLoadingPlugin.debug) {
                TransformerUtils.writeClassFile(cw, name);
            }
            return cw.toByteArray();
        }
        return bytes;
    }

    private void processTryUseItemMethod(MethodNode mn) {
        System.out.println("\tPatching method tryUseItem in ItemInWorldManager");
        TransformerUtils.replaceInventoryArrayAccess(mn, this.entityPlayerClassName, this.playerInventoryFieldName, 5, 7);
        InsnList newList = new InsnList();
        for (AbstractInsnNode node : mn.instructions) {
            if (node instanceof FieldInsnNode && ((FieldInsnNode)node).owner.equals(this.inventoryPlayerClassName) && ((FieldInsnNode)node).name.equals(this.mainInventoryArrayFieldName) && ((FieldInsnNode)node).desc.equals("[L" + this.itemStackClassName + ";")) continue;
            if (node.getOpcode() == 83) {
                newList.add((AbstractInsnNode)new MethodInsnNode(182, this.itemStackClassName, this.setInventorySlotMethodName, this.setInventorySlotMethodDesc));
                continue;
            }
            newList.add(node);
        }
        mn.instructions = newList;
    }
}

