/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import mods.battlegear2.BowHookContainerClass2;
import mods.battlegear2.client.ClientProxy;
import mods.battlegear2.client.gui.BattlegearInGameGUI;
import mods.battlegear2.client.model.QuiverModel;
import mods.battlegear2.client.utils.BattlegearRenderHelper;
import mods.battlegear2.items.ItemQuiver2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.Event;
import net.minecraftforge.event.ForgeSubscribe;
import org.lwjgl.opengl.GL11;

public class BattlegearClientEvents {
    private BattlegearInGameGUI inGameGUI = new BattlegearInGameGUI();
    private QuiverModel quiverModel = new QuiverModel();
    private final ResourceLocation quiverDetails = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverDetails.png");
    private final ResourceLocation quiverBase = new ResourceLocation("battlegear2", "textures/armours/quiver/QuiverBase.png");
    public static final float[][] arrowPos = new float[0][];

    @ForgeSubscribe
    public void postRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            this.inGameGUI.renderGameOverlay(event.partialTicks);
        }
    }

    @ForgeSubscribe
    public void render3rdPersonBattlemode(RenderPlayerEvent.Specials.Post event) {
        ItemStack quiverStack;
        ModelBiped biped = BattlegearClientEvents.getModelBiped(event.renderer, 1);
        BattlegearRenderHelper.renderItemIn3rdPerson(event.entityPlayer, biped, event.partialTicks);
        ItemStack mainhand = event.entityPlayer.func_70694_bm();
        if (mainhand != null && (quiverStack = BowHookContainerClass2.getArrowContainer(mainhand, event.entityPlayer)) != null && quiverStack.func_77973_b() instanceof ItemQuiver2) {
            ItemQuiver2 quiver = (ItemQuiver2)quiverStack.func_77973_b();
            int col = quiver.getColor(quiverStack);
            float red = (float)(col >> 16 & 0xFF) / 255.0f;
            float green = (float)(col >> 8 & 0xFF) / 255.0f;
            float blue = (float)(col & 0xFF) / 255.0f;
            boolean hasArrows = false;
            int maxStack = quiver.getSlotCount(quiverStack);
            int arrowCount = 0;
            for (int i = 0; i < maxStack && !hasArrows; ++i) {
                arrowCount += quiver.getStackInSlot(quiverStack, i) == null ? 0 : 1;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.quiverDetails);
            GL11.glPushMatrix();
            biped.field_78115_e.func_78794_c(0.0625f);
            GL11.glScalef((float)1.05f, (float)1.05f, (float)1.05f);
            this.quiverModel.render(arrowCount, 0.0625f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.quiverBase);
            GL11.glColor3f((float)red, (float)green, (float)blue);
            this.quiverModel.render(0, 0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        event.setResult(Event.Result.ALLOW);
    }

    private float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }

    @ForgeSubscribe
    public void preStitch(TextureStitchEvent.Pre event) {
        if (event.map.field_94255_a == 1) {
            ClientProxy.backgroundIcon = new Icon[2];
            ClientProxy.backgroundIcon[0] = event.map.func_94245_a("battlegear2:slots/mainhand");
            ClientProxy.backgroundIcon[1] = event.map.func_94245_a("battlegear2:slots/offhand");
            ClientProxy.bowIcons = new Icon[3];
            ClientProxy.bowIcons[0] = event.map.func_94245_a("battlegear2:bow_pulling_0");
            ClientProxy.bowIcons[1] = event.map.func_94245_a("battlegear2:bow_pulling_1");
            ClientProxy.bowIcons[2] = event.map.func_94245_a("battlegear2:/bow_pulling_2");
        }
    }

    public static ModelBiped getModelBiped(RenderPlayer renderPlayer, int i) {
        return (ModelBiped)ObfuscationReflectionHelper.getPrivateValue(RenderPlayer.class, (Object)renderPlayer, (int)i);
    }

    @ForgeSubscribe
    public void onSoundLoad(SoundLoadEvent event) {
        try {
            for (int i = 0; i < 10; ++i) {
                event.manager.field_77379_b.func_77459_a(String.format("%s:%s%s.wav", "battlegear2", "shield", i));
            }
        }
        catch (Exception e) {
            System.err.println("Failed to register one or more sounds.");
        }
    }
}

