/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.utils;

import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.Arrays;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.shield.ShieldType;
import mods.battlegear2.heraldry.BlockFlagPole;
import mods.battlegear2.heraldry.ItemBlockFlagPole;
import mods.battlegear2.heraldry.KnightArmourRecipie;
import mods.battlegear2.heraldry.TileEntityFlagPole;
import mods.battlegear2.inventory.CreativeTabMB_B_2;
import mods.battlegear2.items.HeraldryCrest;
import mods.battlegear2.items.ItemDagger;
import mods.battlegear2.items.ItemKnightArmour;
import mods.battlegear2.items.ItemMBArrow;
import mods.battlegear2.items.ItemMace;
import mods.battlegear2.items.ItemQuiver;
import mods.battlegear2.items.ItemShield;
import mods.battlegear2.items.ItemSpear;
import mods.battlegear2.items.ItemWaraxe;
import mods.battlegear2.items.ItemWeapon;
import mods.battlegear2.recipies.DyeRecipie;
import mods.battlegear2.recipies.QuiverRecipie2;
import mods.battlegear2.recipies.ShieldRemoveArrowRecipie;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BattlegearConfig {
    private static Configuration file;
    public static final CreativeTabs customTab;
    public static boolean forceBackSheath;
    public static boolean arrowForceRendered;
    public static boolean enableSkeletonQuiver;
    public static boolean enableGUIKeys;
    public static boolean enableGuiButtons;
    public static final String[] itemNames;
    public static final String[] renderNames;
    public static final String[] toolTypes;
    public static final String[] shieldTypes;
    public static final String[] armourTypes;
    public static final String[] enchantsName;
    public static final int firstDefaultItemIndex = 26201;
    public static int[] itemOffests;
    public static int[] enchantsId;
    public static ItemWeapon[] dagger;
    public static ItemWeapon[] warAxe;
    public static ItemWeapon[] mace;
    public static ItemWeapon[] spear;
    public static ItemShield[] shield;
    public static Item chain;
    public static Item quiver;
    public static Item heradricItem;
    public static Item MbArrows;
    public static BlockFlagPole banner;
    public static ItemArmor[] knightArmor;
    private static String[] comments;
    public static String[] disabledItems;
    public static String[] disabledRecipies;
    public static String[] disabledRenderers;
    public static double[] skeletonArrowSpawnRate;
    public static int[] quiverBarOffset;
    public static int[] shieldBarOffset;
    public static int[] battleBarOffset;

    public static void getConfig(Configuration config) {
        int i;
        int i2;
        file = config;
        config.load();
        StringBuffer sb = new StringBuffer();
        sb.append("This will disable completely the provided item, along with their renderers and recipes including them.\n");
        sb.append("These should all be placed on separate lines between the provided '<' and '>'.  \n");
        sb.append("The valid values are: \n");
        int count = 0;
        for (i2 = 1; i2 < itemNames.length; ++i2) {
            sb.append(itemNames[i2]);
            sb.append(", ");
            if (++count % 5 != 0) continue;
            sb.append("\n");
        }
        BattlegearConfig.comments[0] = sb.toString();
        disabledItems = config.get("general", "Disabled Items", new String[0], comments[0]).getStringList();
        Arrays.sort(disabledItems);
        if (Arrays.binarySearch(disabledItems, itemNames[0]) < 0) {
            heradricItem = new HeraldryCrest(config.getItem(itemNames[0], 26201).getInt()).func_77637_a(customTab).func_77655_b("battlegear2:" + itemNames[0]).func_111206_d("battlegear2:bg-icon");
        }
        if (Arrays.binarySearch(disabledItems, itemNames[10]) < 0) {
            banner = (BlockFlagPole)new BlockFlagPole(config.getBlock(itemNames[10], 3336).getInt()).func_71849_a(customTab).func_71864_b("battlegear2:" + itemNames[10]);
            GameRegistry.registerBlock((Block)banner, ItemBlockFlagPole.class, (String)("battlegear2:" + itemNames[10]));
            GameRegistry.registerTileEntity(TileEntityFlagPole.class, (String)("battlegear2:" + itemNames[10]));
        }
        if (Arrays.binarySearch(disabledItems, itemNames[1]) < 0) {
            chain = new Item(config.getItem(itemNames[1], 26201 + itemOffests[1]).getInt());
            chain.func_77655_b("battlegear2:" + itemNames[1]).func_111206_d("battlegear2:" + itemNames[1]).func_77637_a(customTab);
        }
        enableGUIKeys = config.get("general", "Enable GUI Keys", false).getBoolean(false);
        enableGuiButtons = config.get("general", "Enable GUI Buttons", true).getBoolean(true);
        for (i2 = 0; i2 < enchantsName.length; ++i2) {
            BattlegearConfig.enchantsId[i2] = config.get("EnchantmentsID", enchantsName[i2], enchantsId[i2]).getInt();
        }
        config.get("Coremod", "ASM debug Mode", false, "Only use for advanced bug reporting when asked by a dev.");
        if (Arrays.binarySearch(disabledItems, itemNames[2]) < 0) {
            quiver = new ItemQuiver(config.getItem(itemNames[2], 26203).getInt());
            quiver.func_77655_b("battlegear2:" + itemNames[2]).func_111206_d("battlegear2:quiver/" + itemNames[2]).func_77637_a(customTab);
        }
        if (Arrays.binarySearch(disabledItems, itemNames[9]) < 0) {
            MbArrows = new ItemMBArrow(config.getItem(itemNames[9], 26201 + itemOffests[9]).getInt());
            MbArrows.func_77655_b("battlegear2:" + itemNames[9]).func_111206_d("battlegear2:" + itemNames[9]).func_77637_a(customTab).func_77642_a(Item.field_77704_l);
        }
        String category = "Skeleton CustomArrow Spawn Rate";
        config.addCustomCategoryComment(category, "The spawn rate (between 0 & 1) that Skeletons will spawn with Arrows provided from this mod");
        for (i = 0; i < ItemMBArrow.names.length; ++i) {
            BattlegearConfig.skeletonArrowSpawnRate[i] = config.get(category, ItemMBArrow.names[i], i != 1 && i != 5 ? (double)0.1f : 0.0).getDouble(i != 1 ? (double)0.1f : 0.0);
        }
        sb = new StringBuffer();
        sb.append("This will disable the crafting recipie for the provided item/blocks.\n");
        sb.append("It should be noted that this WILL NOT remove the item from the game, it will only disable the recipe.\n");
        sb.append("In this way the items may still be obtained through creative mode and cheats, but playes will be unable to craft them.\n");
        sb.append("These should all be placed on separate lines between the provided '<' and '>'. The valid values are: \n");
        count = 0;
        for (i = 1; i < itemNames.length; ++i) {
            if (i == 9) continue;
            sb.append(itemNames[i]);
            sb.append(", ");
            if (++count % 5 != 0) continue;
            sb.append("\n");
        }
        for (i = 0; i < ItemMBArrow.names.length; ++i) {
            sb.append(itemNames[9]);
            sb.append('.');
            sb.append(ItemMBArrow.names[i]);
            sb.append(", ");
            if (++count % 5 != 0) continue;
            sb.append("\n");
        }
        int last_comma = sb.lastIndexOf(",");
        if (last_comma > 0) {
            sb.deleteCharAt(last_comma);
        }
        BattlegearConfig.comments[1] = sb.toString();
        disabledRecipies = config.get("general", "Disabled Recipies", new String[0], comments[1]).getStringList();
        Arrays.sort(disabledRecipies);
        category = "Rendering";
        config.addCustomCategoryComment(category, "This category is client side, you don't have to sync its values with server in multiplayer.");
        sb = new StringBuffer();
        sb.append("This will disable the special rendering for the provided item.\n");
        sb.append("These should all be placed on separate lines between the provided '<' and '>'.  \n");
        sb.append("The valid values are: \n");
        for (int i3 = 0; i3 < renderNames.length; ++i3) {
            sb.append(renderNames[i3]);
            sb.append(", ");
        }
        disabledRenderers = config.get(category, "Disabled Renderers", new String[0], sb.toString()).getStringList();
        Arrays.sort(disabledRenderers);
        BattlegearConfig.comments[3] = "Change to move this bar in your gui";
        String[] pos = new String[]{"horizontal", "vertical"};
        for (int i4 = 0; i4 < 2; ++i4) {
            BattlegearConfig.quiverBarOffset[i4] = config.get(category, "Quiver hotbar relative " + pos[i4] + " position", 0, comments[3]).getInt();
            BattlegearConfig.shieldBarOffset[i4] = config.get(category, "Shield bar relative " + pos[i4] + " position", 0, comments[3]).getInt();
            BattlegearConfig.battleBarOffset[i4] = config.get(category, "Offhand hotbar relative " + pos[i4] + " position", 0, comments[3]).getInt();
            BattlegearConfig.battleBarOffset[i4 + 2] = config.get(category, "Mainhand hotbar relative " + pos[i4] + " position", 0, comments[3]).getInt();
        }
        arrowForceRendered = config.get(category, "Render arrow with bow uncharged", true).getBoolean(true);
        forceBackSheath = config.get(category, "Force Back Sheath", false).getBoolean(false);
        enableSkeletonQuiver = config.get(category, "Render quiver on skeleton back", true).getBoolean(true);
        ShieldType[] types = new ShieldType[]{ShieldType.WOOD, ShieldType.HIDE, ShieldType.IRON, ShieldType.DIAMOND, ShieldType.GOLD};
        for (int i5 = 0; i5 < 5; ++i5) {
            EnumToolMaterial material = EnumToolMaterial.values()[i5];
            if (Arrays.binarySearch(disabledItems, itemNames[4]) < 0) {
                BattlegearConfig.warAxe[i5] = new ItemWaraxe(config.getItem(itemNames[4] + toolTypes[i5], 26201 + itemOffests[4] + i5).getInt(), material, itemNames[4], i5 == 4 ? 2 : 1);
            }
            if (Arrays.binarySearch(disabledItems, itemNames[3]) < 0) {
                BattlegearConfig.dagger[i5] = new ItemDagger(config.getItem(itemNames[3] + "_" + toolTypes[i5], 26201 + itemOffests[3] + i5).getInt(), material, itemNames[3]);
            }
            if (Arrays.binarySearch(disabledItems, itemNames[5]) < 0) {
                BattlegearConfig.mace[i5] = new ItemMace(config.getItem(itemNames[5] + toolTypes[i5], 26201 + itemOffests[5] + i5).getInt(), material, itemNames[5], 0.05f + 0.05f * (float)i5);
            }
            if (Arrays.binarySearch(disabledItems, itemNames[6]) < 0) {
                BattlegearConfig.spear[i5] = new ItemSpear(config.getItem(itemNames[6] + toolTypes[i5], 26201 + itemOffests[6] + i5).getInt(), material, itemNames[6]);
            }
            if (Arrays.binarySearch(disabledItems, itemNames[7]) < 0) {
                BattlegearConfig.shield[i5] = new ItemShield(config.getItem(itemNames[7] + shieldTypes[i5], 26201 + itemOffests[7] + i5).getInt(), types[i5]);
            }
            if (i5 == 4 || Arrays.binarySearch(disabledItems, itemNames[8]) >= 0) continue;
            BattlegearConfig.knightArmor[i5] = new ItemKnightArmour(config.getItem(itemNames[8] + armourTypes[i5], 26201 + itemOffests[8] + i5).getInt(), i5);
        }
        if (config.hasChanged()) {
            config.save();
        }
        try {
            for (Field f : BattlegearConfig.class.getFields()) {
                Item it;
                if (!Item.class.isAssignableFrom(f.getType()) || (it = (Item)f.get(null)) == null) continue;
                GameRegistry.registerItem((Item)it, (String)it.func_77658_a());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void registerRecipes() {
        int i;
        if (chain != null) {
            if (Arrays.binarySearch(disabledRecipies, itemNames[1]) < 0) {
                GameRegistry.addShapedRecipe((ItemStack)new ItemStack(chain, 3), (Object[])new Object[]{"I", "I", Character.valueOf('I'), Item.field_77703_o});
            }
            if (Arrays.binarySearch(disabledRecipies, "chain.armour") < 0) {
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Item.field_77694_Z), (Object[])new Object[]{"LLL", "L L", Character.valueOf('L'), chain});
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Item.field_77814_aa), (Object[])new Object[]{"L L", "LLL", "LLL", Character.valueOf('L'), chain});
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Item.field_77816_ab), (Object[])new Object[]{"LLL", "L L", "L L", Character.valueOf('L'), chain});
                GameRegistry.addRecipe((ItemStack)new ItemStack((Item)Item.field_77810_ac), (Object[])new Object[]{"L L", "L L", Character.valueOf('L'), chain});
            }
        }
        if (quiver != null) {
            if (Arrays.binarySearch(disabledRecipies, itemNames[2]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(quiver), new Object[]{"X X", "X X", "XXX", Character.valueOf('X'), Item.field_77770_aF}));
            }
            RecipeSorter.register((String)"battlegear:quiverfilling", QuiverRecipie2.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)new QuiverRecipie2());
        }
        RecipeSorter.register((String)"battlegear:dyeing", DyeRecipie.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        GameRegistry.addRecipe((IRecipe)new DyeRecipie());
        String woodStack = "plankWood";
        for (i = 0; i < 5; ++i) {
            Item craftingMaterial = Item.field_77698_e[EnumToolMaterial.values()[i].func_82844_f()];
            if (warAxe[i] != null && Arrays.binarySearch(disabledRecipies, itemNames[4]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)warAxe[i]), new Object[]{"L L", "LSL", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('L'), i != 0 ? craftingMaterial : woodStack}));
            }
            if (mace[i] != null && Arrays.binarySearch(disabledRecipies, itemNames[5]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)mace[i]), new Object[]{" LL", " LL", "S  ", Character.valueOf('S'), "stickWood", Character.valueOf('L'), i != 0 ? craftingMaterial : woodStack}));
            }
            if (dagger[i] != null && Arrays.binarySearch(disabledRecipies, itemNames[3]) < 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)dagger[i]), new Object[]{"L", "S", Character.valueOf('S'), "stickWood", Character.valueOf('L'), i != 0 ? craftingMaterial : woodStack}));
            }
            if (spear[i] == null || Arrays.binarySearch(disabledRecipies, itemNames[6]) >= 0) continue;
            if (i == 0) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)spear[i]), new Object[]{"  S", " S ", "S  ", Character.valueOf('S'), "stickWood"}));
                continue;
            }
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)spear[i]), (Object[])new Object[]{" L", "S ", Character.valueOf('S'), spear[0], Character.valueOf('L'), craftingMaterial});
        }
        if (Arrays.binarySearch(disabledItems, itemNames[7]) < 0 && Arrays.binarySearch(disabledRecipies, itemNames[7]) < 0) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[0]), new Object[]{" W ", "WWW", " W ", Character.valueOf('W'), woodStack}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[1]), new Object[]{" H ", "HWH", " H ", Character.valueOf('W'), woodStack, Character.valueOf('H'), Item.field_77770_aF}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[2]), new Object[]{"I I", "IWI", " I ", Character.valueOf('W'), woodStack, Character.valueOf('I'), Item.field_77703_o}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[3]), new Object[]{"I I", "IWI", " I ", Character.valueOf('W'), woodStack, Character.valueOf('I'), Item.field_77702_n}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)shield[4]), new Object[]{"I I", "IWI", " I ", Character.valueOf('W'), woodStack, Character.valueOf('I'), Item.field_77717_p}));
            RecipeSorter.register((String)"battlegear:shieldarrowtaking", ShieldRemoveArrowRecipie.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
            GameRegistry.addRecipe((IRecipe)new ShieldRemoveArrowRecipie());
        }
        if (MbArrows != null) {
            for (i = 0; i < ItemMBArrow.component.length; ++i) {
                if (Arrays.binarySearch(disabledRecipies, itemNames[9] + "." + ItemMBArrow.names[i]) >= 0) continue;
                GameRegistry.addRecipe((ItemStack)new ItemStack(MbArrows, 1, i), (Object[])new Object[]{"G", "A", Character.valueOf('G'), ItemMBArrow.component[i], Character.valueOf('A'), Item.field_77704_l});
                if (i == 2 || i == 3) continue;
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ItemMBArrow.component[i]), (Object[])new Object[]{new ItemStack(MbArrows, 1, i)});
            }
        }
        RecipeSorter.register((String)"battlegear:knightarmor", KnightArmourRecipie.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        for (i = 0; i < 4; ++i) {
            GameRegistry.addRecipe((IRecipe)new KnightArmourRecipie(i));
        }
        if (banner != null) {
            for (i = 0; i < 5; ++i) {
                Item temp = i < 4 ? new ItemStack(Block.field_71951_J, 1, i) : Item.field_77703_o;
                GameRegistry.addRecipe((ItemStack)new ItemStack((Block)banner, 4, i), (Object[])new Object[]{"W", "W", "W", Character.valueOf('W'), temp});
            }
        }
    }

    public static void refreshConfig() {
        try {
            Arrays.sort(disabledRenderers);
            file.get("Rendering", "Disabled Renderers", new String[0], comments[2]).set(disabledRenderers);
            file.get("Rendering", "Render arrow with bow uncharged", true).set(arrowForceRendered);
            file.get("Rendering", "Force Back Sheath", false).set(forceBackSheath);
            file.get("Rendering", "Render quiver on skeleton back", true).set(enableSkeletonQuiver);
            file.get("general", "Enable GUI Keys", false).set(enableGUIKeys);
            file.get("general", "Enable GUI Buttons", true).set(enableGuiButtons);
            file.save();
            Battlegear.proxy.registerItemRenderers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void refreshGuiValues() {
        try {
            String[] pos = new String[]{"horizontal", "vertical"};
            for (int i = 0; i < 2; ++i) {
                file.get("Rendering", "Quiver hotbar relative " + pos[i] + " position", 0, comments[3]).set(quiverBarOffset[i]);
                file.get("Rendering", "Shield bar relative " + pos[i] + " position", 0, comments[3]).set(shieldBarOffset[i]);
                file.get("Rendering", "Offhand hotbar relative " + pos[i] + " position", 0, comments[3]).set(battleBarOffset[i]);
                file.get("Rendering", "Mainhand hotbar relative " + pos[i] + " position", 0, comments[3]).set(battleBarOffset[i + 2]);
            }
            file.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        customTab = new CreativeTabMB_B_2("Battlegear2");
        forceBackSheath = false;
        arrowForceRendered = true;
        enableSkeletonQuiver = true;
        enableGUIKeys = false;
        enableGuiButtons = true;
        itemNames = new String[]{"heraldric", "chain", "quiver", "dagger", "waraxe", "mace", "spear", "shield", "knight.armour", "mb.arrow", "flagpole"};
        renderNames = new String[]{"spear", "shield", "bow", "quiver", "flagpole"};
        toolTypes = new String[]{"wood", "stone", "iron", "diamond", "gold"};
        shieldTypes = new String[]{"wood", "hide", "iron", "diamond", "gold"};
        armourTypes = new String[]{"helmet", "plate", "legs", "boots"};
        enchantsName = new String[]{"BashWeight", "BashPower", "BashDamage", "ShieldUsage", "ShieldRecovery", "BowLoot", "BowCharge"};
        itemOffests = new int[]{0, 1, 2, 5, 10, 15, 20, 25, 30, 35};
        enchantsId = new int[]{125, 126, 127, 128, 129, 130, 131};
        dagger = new ItemWeapon[toolTypes.length];
        warAxe = new ItemWeapon[toolTypes.length];
        mace = new ItemWeapon[toolTypes.length];
        spear = new ItemWeapon[toolTypes.length];
        shield = new ItemShield[shieldTypes.length];
        knightArmor = new ItemArmor[armourTypes.length];
        comments = new String[4];
        disabledItems = new String[0];
        disabledRecipies = new String[0];
        disabledRenderers = new String[0];
        skeletonArrowSpawnRate = new double[ItemMBArrow.names.length];
        quiverBarOffset = new int[2];
        shieldBarOffset = new int[2];
        battleBarOffset = new int[4];
    }
}

