/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.List;
import java.util.UUID;
import mods.battlegear2.api.weapons.IBackStabbable;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import mods.battlegear2.api.weapons.IExtendedReachWeapon;
import mods.battlegear2.api.weapons.IHitTimeModifier;
import mods.battlegear2.api.weapons.IPenetrateWeapon;
import mods.battlegear2.api.weapons.ISpecialEffect;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public abstract class ItemWeapon
extends ItemSword
implements IBattlegearWeapon {
    public static final DecimalFormat decimal_format = new DecimalFormat("#.###");
    protected static final UUID penetrateArmourUUID = UUID.fromString("DB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final RangedAttribute armourPenetrate = new RangedAttribute("weapon.penetrateArmor", 0.0, 0.0, Double.MAX_VALUE);
    protected static final UUID dazeUUID = UUID.fromString("927f0df6-946e-4e78-a479-c2c13034edb5");
    protected static final RangedAttribute daze = new RangedAttribute("weapon.daze", 3.0, 0.0, Double.MAX_VALUE);
    protected static final UUID extendReachUUID = UUID.fromString("fb557a05-866e-4017-990b-aab8450bf41b");
    protected static final RangedAttribute extendedReach = new RangedAttribute("weapon.extendedReach", 2.0, 0.0, Double.MAX_VALUE);
    protected final EnumToolMaterial material;
    protected String name;
    protected float baseDamage;

    public ItemWeapon(int par1, EnumToolMaterial material, String named) {
        super(par1, material);
        this.material = material;
        this.func_77637_a(BattlegearConfig.customTab);
        this.name = material == EnumToolMaterial.EMERALD ? named + ".diamond" : named + "." + material.name().toLowerCase();
        this.func_77655_b("battlegear2:" + this.name);
        this.func_111206_d("battlegear2:" + this.name);
        this.baseDamage = 4.0f + material.func_78000_c();
    }

    public EnumToolMaterial getMaterial() {
        return this.material;
    }

    public Multimap func_111205_h() {
        HashMultimap map = HashMultimap.create();
        map.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.baseDamage, 0));
        return map;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        if (this instanceof IExtendedReachWeapon || this instanceof IPenetrateWeapon || this instanceof IHitTimeModifier || this instanceof ISpecialEffect) {
            par3List.add("");
            if (this instanceof IPenetrateWeapon) {
                par3List.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{decimal_format.format(((IPenetrateWeapon)((Object)this)).getPenetratingPower(par1ItemStack)), StatCollector.func_74838_a((String)"attribute.weapon.penetrateArmor")}));
            }
            if (this instanceof IExtendedReachWeapon) {
                float reach = ((IExtendedReachWeapon)((Object)this)).getReachModifierInBlocks(par1ItemStack);
                if (reach > 0.0f) {
                    par3List.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"attribute.modifier.plus.0", (Object[])new Object[]{decimal_format.format(reach), StatCollector.func_74838_a((String)"attribute.weapon.extendedReach")}));
                } else {
                    par3List.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"attribute.modifier.take.0", (Object[])new Object[]{decimal_format.format(-1.0f * reach), StatCollector.func_74838_a((String)"attribute.weapon.extendedReach")}));
                }
            }
            if (this instanceof IHitTimeModifier) {
                int hitMod = ((IHitTimeModifier)((Object)this)).getHitTime(par1ItemStack, null);
                if (hitMod > 0) {
                    par3List.add(EnumChatFormatting.RED + StatCollector.func_74837_a((String)"attribute.modifier.take.1", (Object[])new Object[]{decimal_format.format((float)hitMod / 10.0f * 100.0f), StatCollector.func_74838_a((String)"attribute.weapon.attackSpeed")}));
                } else {
                    par3List.add(EnumChatFormatting.DARK_GREEN + StatCollector.func_74837_a((String)"attribute.modifier.plus.1", (Object[])new Object[]{decimal_format.format(-((float)hitMod) / 10.0f * 100.0f), StatCollector.func_74838_a((String)"attribute.weapon.attackSpeed")}));
                }
            }
            if (this instanceof IBackStabbable) {
                par3List.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"attribute.weapon.backstab"));
            }
        }
    }
}

