/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.heraldry.IHeraldryItem;
import mods.battlegear2.api.heraldry.IHeraldyArmour;
import mods.battlegear2.api.heraldry.PatternStore;
import mods.battlegear2.client.heraldry.HeraldryArmourModel;
import mods.battlegear2.heraldry.SigilHelper;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ISpecialArmor;

public class ItemKnightArmour
extends ItemArmor
implements IHeraldyArmour,
ISpecialArmor {
    private Icon[] baseIcon;
    private Icon[] postRenderIcon;
    private Icon trimRenderIcon;
    private Object modelObject;

    public ItemKnightArmour(int id, int armourType) {
        super(id, Battlegear.knightArmourMaterial, 1, armourType);
        this.func_77637_a(BattlegearConfig.customTab);
        this.func_77655_b("battlegear2:knights_armour." + BattlegearConfig.armourTypes[armourType]);
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        if (this.field_77881_a == 0) {
            this.baseIcon = new Icon[4];
            this.postRenderIcon = new Icon[4];
            for (int i = 0; i < 4; ++i) {
                this.baseIcon[i] = par1IconRegister.func_94245_a("battlegear2:armours/knight-base-" + BattlegearConfig.armourTypes[this.field_77881_a] + "-" + i);
                this.postRenderIcon[i] = par1IconRegister.func_94245_a("battlegear2:armours/knight-post-" + BattlegearConfig.armourTypes[this.field_77881_a] + "-" + i);
            }
        } else {
            this.baseIcon = new Icon[1];
            this.postRenderIcon = new Icon[1];
            this.baseIcon[0] = par1IconRegister.func_94245_a("battlegear2:armours/knight-base-" + BattlegearConfig.armourTypes[this.field_77881_a]);
            this.postRenderIcon[0] = par1IconRegister.func_94245_a("battlegear2:armours/knight-post-" + BattlegearConfig.armourTypes[this.field_77881_a]);
        }
        if (this.field_77881_a == 2) {
            this.trimRenderIcon = par1IconRegister.func_94245_a("battlegear2:armours/knight-trim-" + BattlegearConfig.armourTypes[this.field_77881_a]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_77650_f(ItemStack stack) {
        return this.getPostRenderIcon(stack);
    }

    @Override
    public Icon getBaseIcon(ItemStack stack) {
        if (this.field_77881_a == 0) {
            return this.baseIcon[SigilHelper.getHelm(((IHeraldryItem)stack.func_77973_b()).getHeraldry(stack))];
        }
        return this.baseIcon[0];
    }

    @Override
    public Icon getPostRenderIcon(ItemStack stack) {
        return this.postRenderIcon[0];
    }

    @Override
    public Icon getTrimIcon(ItemStack stack) {
        return this.trimRenderIcon;
    }

    @Override
    public boolean hasHeraldry(ItemStack stack) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("heraldry")) {
                int oldcode = stack.func_77978_p().func_74762_e("heraldry");
                stack.func_77978_p().func_74773_a("hc2", SigilHelper.translate(oldcode));
                stack.func_77978_p().func_82580_o("heraldry");
                return true;
            }
            if (stack.func_77978_p().func_74764_b("hc2")) {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        par3List.add(String.format("%s +%d %s", EnumChatFormatting.BLUE, this.field_77879_b, StatCollector.func_74838_a((String)"tooltip.armour.points")));
    }

    @Override
    public byte[] getHeraldry(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b("hc2")) {
            stack.func_77978_p().func_74773_a("hc2", SigilHelper.getDefault());
            return SigilHelper.getDefault();
        }
        return stack.func_77978_p().func_74770_j("hc2");
    }

    @Override
    public void setHeraldry(ItemStack stack, byte[] code) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74773_a("hc2", code);
    }

    @Override
    public void removeHeraldry(ItemStack item) {
        if (item.func_77942_o()) {
            item.func_77978_p().func_74773_a("hc2", SigilHelper.getDefault());
        }
    }

    @Override
    public boolean shouldDoPass(IHeraldryItem.HeraldyRenderPassess pass) {
        if (pass.equals((Object)IHeraldryItem.HeraldyRenderPassess.Pattern) || pass.equals((Object)IHeraldryItem.HeraldyRenderPassess.SecondaryColourTrim) || pass.equals((Object)IHeraldryItem.HeraldyRenderPassess.PostRenderIcon)) {
            return true;
        }
        return this.field_77881_a == 1;
    }

    @Override
    public boolean useDefaultRenderer() {
        return true;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        return Battlegear.imageFolder + "armours/knights/knights-" + (slot == 2 ? 1 : 0) + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.modelObject == null) {
            this.modelObject = new HeraldryArmourModel(this.field_77881_a);
        }
        HeraldryArmourModel model = (HeraldryArmourModel)((Object)this.modelObject);
        model.setItemStack(itemStack);
        model.field_78116_c.field_78806_j = armorSlot == 0;
        model.field_78114_d.field_78806_j = false;
        model.field_78115_e.field_78806_j = armorSlot == 1 || armorSlot == 2;
        model.field_78112_f.field_78806_j = armorSlot == 1;
        model.field_78113_g.field_78806_j = armorSlot == 1;
        model.field_78123_h.field_78806_j = armorSlot == 2 || armorSlot == 3;
        boolean bl = model.field_78124_i.field_78806_j = armorSlot == 2 || armorSlot == 3;
        if (entityLiving != null) {
            int n = model.field_78120_m = entityLiving.func_70694_bm() == null ? 0 : 1;
            if (entityLiving instanceof EntityPlayer) {
                if (entityLiving.func_70694_bm() != null && ((EntityPlayer)entityLiving).func_71052_bv() > 0) {
                    EnumAction enumaction = entityLiving.func_70694_bm().func_77975_n();
                    if (enumaction == EnumAction.block) {
                        model.field_78120_m = 3;
                    }
                    model.field_78118_o = enumaction == EnumAction.bow;
                }
                model.field_78119_l = ((EntityPlayer)entityLiving).field_71071_by.func_70301_a(((EntityPlayer)entityLiving).field_71071_by.field_70461_c + InventoryPlayerBattle.WEAPON_SETS) == null ? 0 : 1;
            }
            model.field_78117_n = entityLiving.func_70093_af();
        }
        return model;
    }

    @Override
    public String getBaseArmourPath(int armourSlot) {
        return Battlegear.imageFolder + "armours/knights/knights-base-" + (armourSlot == 2 ? 1 : 0) + ".png";
    }

    @Override
    public String getPatternArmourPath(PatternStore pattern, int index, int armourSlot) {
        return Battlegear.imageFolder + "armours/knights/patterns/knights-pattern-" + (armourSlot == 2 ? 1 : 0) + "-" + index + ".png";
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (slot == 1 || slot == 2) {
            return new ISpecialArmor.ArmorProperties(1, 0.8, 10);
        }
        if (slot == 0) {
            return new ISpecialArmor.ArmorProperties(0, 0.6, 16);
        }
        if (slot == 3) {
            return new ISpecialArmor.ArmorProperties(0, 0.4, 8);
        }
        return null;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (slot == 1) {
            if (player.func_71124_b(1) != null && player.func_71124_b(1).func_77973_b() instanceof ItemKnightArmour && player.func_71124_b(3) != null && player.func_71124_b(3).func_77973_b() instanceof ItemKnightArmour && player.func_71124_b(4) != null && player.func_71124_b(4).func_77973_b() instanceof ItemKnightArmour) {
                return 9;
            }
            return 7;
        }
        if (slot == 2) {
            return 5;
        }
        if (slot == 0 || slot == 3) {
            return 3;
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a(damage, entity);
    }
}

