/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import cpw.mods.fml.common.FMLCommonHandler;
import java.util.List;
import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerBase;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class NetServerHandlerTransformer
extends TransformerBase {
    private String packet16BlockItemSwitchClassName;
    private String entityPlayerMPClassName;
    private String entityPlayerClassName;
    private String netServiceHandelerClassName;
    private String inventoryPlayerClassName;
    private String itemStackClassName;
    private String playerInventoryFieldName;
    private String packet16BlockItemSwitchId;
    private String netServiceHandelerPlayerField;
    private String handleBlockSwitchMethodName;
    private String handleBlockSwitchMethodDesc;
    private String handlePlaceMethodName;
    private String handlePlaceMethodDesc;
    private String inventoryGetCurrentMethodName;
    private String inventoryGetCurrentMethodDesc;
    private String itemStackCopyStackMethodName;
    private String itemStackCopyStackMethodDesc;

    public NetServerHandlerTransformer() {
        super("net.minecraft.network.NetServerHandler");
    }

    @Override
    boolean processMethods(List<MethodNode> methods) {
        int found = 0;
        for (MethodNode mn : methods) {
            if (mn.name.equals(this.handleBlockSwitchMethodName) && mn.desc.equals(this.handleBlockSwitchMethodDesc)) {
                this.processSwitchBlockMethod(mn);
                ++found;
                continue;
            }
            if (!mn.name.equals(this.handlePlaceMethodName) || !mn.desc.equals(this.handlePlaceMethodDesc)) continue;
            this.processPlaceMethod(mn);
            ++found;
        }
        return found == 2;
    }

    private void processPlaceMethod(MethodNode mn) {
        this.sendPatchLog("handlePlace");
        InsnList newList = new InsnList();
        ListIterator it = mn.instructions.iterator();
        int fieldCount = 0;
        while (it.hasNext()) {
            AbstractInsnNode nextNode = (AbstractInsnNode)it.next();
            if (nextNode instanceof FieldInsnNode && ((FieldInsnNode)nextNode).owner.equals(this.entityPlayerMPClassName) && ((FieldInsnNode)nextNode).name.equals(this.playerInventoryFieldName)) {
                if (++fieldCount == 3) {
                    while (it.hasNext() && nextNode.getOpcode() != 1) {
                        nextNode = (AbstractInsnNode)it.next();
                    }
                    newList.add(nextNode);
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "setPlayerCurrentItem", "(L" + this.entityPlayerClassName + ";L" + this.itemStackClassName + ";)V"));
                    it.next();
                    continue;
                }
                if (fieldCount == 4) {
                    while (it.hasNext() && nextNode.getOpcode() != 83) {
                        nextNode = (AbstractInsnNode)it.next();
                    }
                    newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    newList.add((AbstractInsnNode)new FieldInsnNode(180, this.netServiceHandelerClassName, this.netServiceHandelerPlayerField, "L" + this.entityPlayerMPClassName + ";"));
                    newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityPlayerMPClassName, this.playerInventoryFieldName, "L" + this.inventoryPlayerClassName + ";"));
                    newList.add((AbstractInsnNode)new MethodInsnNode(182, this.inventoryPlayerClassName, this.inventoryGetCurrentMethodName, this.inventoryGetCurrentMethodDesc));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, this.itemStackClassName, this.itemStackCopyStackMethodName, this.itemStackCopyStackMethodDesc));
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/BattlegearUtils", "setPlayerCurrentItem", "(L" + this.entityPlayerClassName + ";L" + this.itemStackClassName + ";)V"));
                    if (FMLCommonHandler.instance().getModName().contains("mcpc")) continue;
                    while (it.hasNext() && (!(nextNode instanceof JumpInsnNode) || nextNode.getOpcode() != 154)) {
                        nextNode = (AbstractInsnNode)it.next();
                        newList.add(nextNode);
                    }
                    newList.add((AbstractInsnNode)new VarInsnNode(25, 9));
                    newList.add((AbstractInsnNode)new JumpInsnNode(198, ((JumpInsnNode)nextNode).label));
                    continue;
                }
                newList.add(nextNode);
                continue;
            }
            newList.add(nextNode);
        }
        mn.instructions = newList;
    }

    private void processSwitchBlockMethod(MethodNode mn) {
        this.sendPatchLog("handleBlockItemSwitch");
        InsnList newList = new InsnList();
        ListIterator it = mn.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode nextInsn = (AbstractInsnNode)it.next();
            newList.add(nextInsn);
            if (!(nextInsn instanceof FieldInsnNode) || nextInsn.getOpcode() != 180 || !((FieldInsnNode)nextInsn).owner.equals(this.packet16BlockItemSwitchClassName) || !((FieldInsnNode)nextInsn).name.equals(this.packet16BlockItemSwitchId)) continue;
            newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/InventoryPlayerBattle", "isValidSwitch", "(I)Z"));
            nextInsn = (AbstractInsnNode)it.next();
            while (it.hasNext() && (!(nextInsn instanceof JumpInsnNode) || nextInsn.getOpcode() != 162)) {
                nextInsn = (AbstractInsnNode)it.next();
            }
            newList.add((AbstractInsnNode)new JumpInsnNode(153, ((JumpInsnNode)nextInsn).label));
            while (it.hasNext()) {
                nextInsn = (AbstractInsnNode)it.next();
                newList.add(nextInsn);
            }
        }
        mn.instructions = newList;
    }

    @Override
    boolean processFields(List<FieldNode> fields) {
        return true;
    }

    @Override
    void setupMappings() {
        this.netServiceHandelerClassName = BattlegearTranslator.getMapedClassName("network.NetServerHandler");
        this.packet16BlockItemSwitchClassName = BattlegearTranslator.getMapedClassName("network.packet.Packet16BlockItemSwitch");
        this.entityPlayerMPClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayerMP");
        this.inventoryPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.InventoryPlayer");
        this.itemStackClassName = BattlegearTranslator.getMapedClassName("item.ItemStack");
        this.entityPlayerClassName = BattlegearTranslator.getMapedClassName("entity.player.EntityPlayer");
        this.packet16BlockItemSwitchId = BattlegearTranslator.getMapedFieldName("Packet16BlockItemSwitch", "field_73386_a", "id");
        this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by", "inventory");
        this.netServiceHandelerPlayerField = BattlegearTranslator.getMapedFieldName("NetServerHandler", "field_72574_e", "playerEntity");
        this.handleBlockSwitchMethodName = BattlegearTranslator.getMapedMethodName("NetServerHandler", "func_72502_a", "handleBlockItemSwitch");
        this.handleBlockSwitchMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetServerHandler", "func_72502_a", "(L" + this.packet16BlockItemSwitchClassName + ";)V");
        this.handlePlaceMethodName = BattlegearTranslator.getMapedMethodName("NetServerHandler", "func_72472_a", "handlePlace");
        this.handlePlaceMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetServerHandler", "func_72472_a", "(Lnet/minecraft/network/packet/Packet15Place;)V");
        this.inventoryGetCurrentMethodName = BattlegearTranslator.getMapedMethodName("InventoryPlayer", "func_70448_g", "getCurrentItem");
        this.inventoryGetCurrentMethodDesc = BattlegearTranslator.getMapedMethodDesc("InventoryPlayer", "func_70448_g", "()L" + this.itemStackClassName + ";");
        this.itemStackCopyStackMethodName = BattlegearTranslator.getMapedMethodName("ItemStack", "func_77944_b", "copyItemStack");
        this.itemStackCopyStackMethodDesc = BattlegearTranslator.getMapedMethodDesc("ItemStack", "func_77944_b", "(L" + this.itemStackClassName + ";)L" + this.itemStackClassName + ";");
    }
}

