/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.List;
import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerBase;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class NetClientHandlerTransformer
extends TransformerBase {
    private String entityOtherPlayerMPClassName;
    private String playerInventoryFieldName;
    private String packet20NamedEntitySpawnClassName;
    private String netClientHandlerHandleNamedEntitySpawnMethodName;
    private String netClientHandlerHandleNamedEntitySpawnMethodDesc;
    private String netClientHandlerHandleBlockItemSwitchMethodName;
    private String netClientHandlerHandleBlockItemSwitchMethodDesc;

    public NetClientHandlerTransformer() {
        super("net.minecraft.client.multiplayer.NetClientHandler");
    }

    @Override
    boolean processMethods(List<MethodNode> methods) {
        int found = 0;
        for (MethodNode method : methods) {
            if (method.name.equals(this.netClientHandlerHandleNamedEntitySpawnMethodName) && method.desc.equals(this.netClientHandlerHandleNamedEntitySpawnMethodDesc)) {
                this.sendPatchLog("handleNamedEntitySpawn");
                NetClientHandlerTransformer.replaceInventoryArrayAccess(method, this.entityOtherPlayerMPClassName, this.playerInventoryFieldName, 9, 13);
                ++found;
                continue;
            }
            if (!method.name.equals(this.netClientHandlerHandleBlockItemSwitchMethodName) || !method.desc.equals(this.netClientHandlerHandleBlockItemSwitchMethodDesc)) continue;
            this.sendPatchLog("handleBlockItemSwitch");
            ListIterator insn = method.instructions.iterator();
            InsnList newList = new InsnList();
            while (insn.hasNext()) {
                AbstractInsnNode nextNode = (AbstractInsnNode)insn.next();
                if (nextNode instanceof JumpInsnNode && nextNode.getOpcode() == 155) {
                    LabelNode label = ((JumpInsnNode)nextNode).label;
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/InventoryPlayerBattle", "isValidSwitch", "(I)Z"));
                    newList.add((AbstractInsnNode)new JumpInsnNode(153, label));
                    nextNode = (AbstractInsnNode)insn.next();
                    while (insn.hasNext() && !(nextNode instanceof JumpInsnNode) && nextNode.getOpcode() != 162) {
                        nextNode = (AbstractInsnNode)insn.next();
                    }
                    continue;
                }
                newList.add(nextNode);
            }
            method.instructions = newList;
            ++found;
        }
        return found == 2;
    }

    @Override
    boolean processFields(List<FieldNode> fields) {
        return true;
    }

    @Override
    void setupMappings() {
        this.entityOtherPlayerMPClassName = BattlegearTranslator.getMapedClassName("client.entity.EntityOtherPlayerMP");
        this.packet20NamedEntitySpawnClassName = BattlegearTranslator.getMapedClassName("network.packet.Packet20NamedEntitySpawn");
        this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by", "inventory");
        this.netClientHandlerHandleNamedEntitySpawnMethodName = BattlegearTranslator.getMapedMethodName("NetClientHandler", "func_72518_a", "handleNamedEntitySpawn");
        this.netClientHandlerHandleNamedEntitySpawnMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetClientHandler", "func_72518_a", "(L" + this.packet20NamedEntitySpawnClassName + ";)V");
        this.netClientHandlerHandleBlockItemSwitchMethodName = BattlegearTranslator.getMapedMethodName("NetClientHandler", "func_72502_a", "handleBlockItemSwitch");
        this.netClientHandlerHandleBlockItemSwitchMethodDesc = BattlegearTranslator.getMapedMethodDesc("NetClientHandler", "func_72502_a", "(Lnet/minecraft/network/packet/Packet16BlockItemSwitch;)V");
    }
}

