/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.heraldry;

import java.awt.Color;
import mods.battlegear2.api.heraldry.HeraldryData;
import mods.battlegear2.api.heraldry.HeraldryPattern;
import mods.battlegear2.heraldry.HeraldryIcon;
import mods.battlegear2.heraldry.HeraldryPositions;

public class SigilHelper {
    public static final int COLOUR_PRIMARY = 0;
    public static final int COLOUR_SECONDARY = 1;
    public static final int COLOUR_SIGIL_PRIMARY = 2;
    public static final int COLOUR_SIGIL_SECONDARY = 3;
    public static final int length = 8;
    public static int[] colourTranslationMap = new int[]{986895, 0x4F4F4F, 0x8F8F8F, 0xCFCFCF, 0xFFFFFF, 0x7F0F0F, 0xFF0000, 0xFF7F7F, 0xFF7F0F, 0x7F7F0F, 0xFFFF0F, 0xFFFF80, 1015567, 1048335, 0x7FFF0F, 0x7FFF8F, 1048447, 1015679, 1048575, 0x7FFFFF, 987007, 987135, 1015807, 0x7F7FFF, 0x7F0FFF, 0x7F0F7F, 0xFF0FFF, 0xFF7FFF, 0xFF0F7F, 8343311, 13598479};

    public static byte[] getDefault() {
        return HeraldryData.getDefault().getByteArray();
    }

    public static short get12bitRGB(int rgb) {
        return (short)((rgb & 0xF00000) >> 12 | (rgb & 0xF000) >> 8 | (rgb & 0xF0) >> 4);
    }

    public static int extractBit(long code, int begin, int end) {
        return (int)(code << 63 - end >>> 63 + begin - end);
    }

    private static Color getColourFromBeginIndex(long code, int beginIndex) {
        return new Color((SigilHelper.extractBit(code, beginIndex + 8, beginIndex + 11) + 1) * 16 - 1, (SigilHelper.extractBit(code, beginIndex + 4, beginIndex + 7) + 1) * 16 - 1, (SigilHelper.extractBit(code, beginIndex, beginIndex + 3) + 1) * 16 - 1);
    }

    public static byte getHelm(byte[] code) {
        return (byte)(code[0] >> 2 & 3);
    }

    public static byte getBanner(byte[] code) {
        return (byte)(code[0] & 3);
    }

    public static Color getPrimaryColour(byte[] code) {
        return new Color((code[1] >> 4 & 0xF) * 16, (code[1] & 0xF) * 16, (code[2] >> 4 & 0xF) * 16);
    }

    public static float[] getPrimaryColourArray(byte[] code) {
        return new float[]{(float)(code[1] >> 4 & 0xF) / 16.0f, (float)(code[1] & 0xF) / 16.0f, (float)(code[2] >> 4 & 0xF) / 16.0f};
    }

    public static Color getSecondaryColour(byte[] code) {
        return new Color((code[2] & 0xF) * 16, (code[3] >> 4 & 0xF) * 16, (code[3] & 0xF) * 16);
    }

    public static float[] getSecondaryColourArray(byte[] code) {
        return new float[]{(float)(code[2] & 0xF) / 16.0f, (float)(code[3] >> 4 & 0xF) / 16.0f, (float)(code[3] & 0xF) / 16.0f};
    }

    public static HeraldryIcon getSigil(byte[] code) {
        return HeraldryIcon.values()[code[4] >> 3 & 0x1F];
    }

    public static HeraldryPositions getSigilPosition(byte[] code) {
        return HeraldryPositions.values()[code[4] & 7];
    }

    public static Color getSigilPrimaryColour(byte[] code) {
        return new Color((code[5] >> 4 & 0xF) * 16, (code[5] & 0xF) * 16, (code[6] >> 4 & 0xF) * 16);
    }

    public static float[] getSigilPrimaryColourArray(byte[] code) {
        return new float[]{(float)(code[5] >> 4 & 0xF) / 16.0f, (float)(code[5] & 0xF) / 16.0f, (float)(code[6] >> 4 & 0xF) / 16.0f};
    }

    public static Color getSigilSecondaryColour(byte[] code) {
        return new Color((code[6] & 0xF) * 16, (code[7] >> 4 & 0xF) * 16, (code[7] & 0xF) * 16);
    }

    public static float[] getSigilSecondaryColourArray(byte[] code) {
        return new float[]{(float)(code[6] & 0xF) / 16.0f, (float)(code[7] >> 4 & 0xF) / 16.0f, (float)(code[7] & 0xF) / 16.0f};
    }

    public static Color getColour(byte[] code, int colour) {
        switch (colour) {
            case 0: {
                return SigilHelper.getPrimaryColour(code);
            }
            case 1: {
                return SigilHelper.getSecondaryColour(code);
            }
            case 2: {
                return SigilHelper.getSigilPrimaryColour(code);
            }
            case 3: {
                return SigilHelper.getSigilSecondaryColour(code);
            }
        }
        return Color.WHITE;
    }

    public static float[] getColourArray(byte[] code, int colour) {
        switch (colour) {
            case 0: {
                return SigilHelper.getPrimaryColourArray(code);
            }
            case 1: {
                return SigilHelper.getSecondaryColourArray(code);
            }
            case 2: {
                return SigilHelper.getSigilPrimaryColourArray(code);
            }
            case 3: {
                return SigilHelper.getSigilSecondaryColourArray(code);
            }
        }
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public static byte[] updatePattern(byte[] code, HeraldryPattern newPatern) {
        code[0] = (byte)(HeraldryPattern.patterns.indexOf(newPatern) << 4 & 0xF0 | code[0] & 0xF);
        return code;
    }

    public static byte[] updateHelm(byte[] code, byte helm) {
        code[0] = (byte)(code[0] & 0xF3 | helm << 2 & 0xC);
        return code;
    }

    public static byte[] updateBanner(byte[] code, byte banner) {
        code[0] = (byte)(code[0] & 0xFC | banner & 3);
        return code;
    }

    public static byte[] updateSigil(byte[] code, HeraldryIcon newIcon) {
        code[4] = (byte)(newIcon.ordinal() << 3 & 0xF8 | code[4] & 7);
        return code;
    }

    public static byte[] updateSigilPos(byte[] code, HeraldryPositions newPos) {
        code[4] = (byte)(code[4] & 0xF8 | newPos.ordinal() & 7);
        return code;
    }

    public static byte[] updateColour(byte[] code, int rgb, int colour) {
        switch (colour) {
            case 0: {
                code[1] = (byte)(rgb >> 16 & 0xF0 | rgb >> 12 & 0xF);
                code[2] = (byte)(rgb & 0xF0 | code[2] & 0xF);
                break;
            }
            case 1: {
                code[2] = (byte)(rgb >> 20 & 0xF | code[2] & 0xF0);
                code[3] = (byte)(rgb >> 8 & 0xF0 | rgb >> 4 & 0xF);
                break;
            }
            case 2: {
                code[5] = (byte)(rgb >> 16 & 0xF0 | rgb >> 12 & 0xF);
                code[6] = (byte)(rgb & 0xF0 | code[6] & 0xF);
                break;
            }
            case 3: {
                code[6] = (byte)(rgb >> 20 & 0xF | code[6] & 0xF0);
                code[7] = (byte)(rgb >> 8 & 0xF0 | rgb >> 4 & 0xF);
            }
        }
        return code;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static int extractBitInt(int code, int begin, int end) {
        return code << 31 - end >>> 31 + begin - end;
    }
}

