/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.heraldry;

import java.util.List;
import mods.battlegear2.api.heraldry.IFlagHolder;
import mods.battlegear2.heraldry.TileEntityFlagPole;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFlagPole
extends BlockRotatedPillar {
    public static final PropertyEnum<Variants> VARIANT = PropertyEnum.func_177709_a((String)"variant", Variants.class);
    private static final float[] woodTexDims = new float[]{0.0f, 4.0f, 8.0f, 12.0f, 16.0f};
    private static final float[] ironTexDims = new float[]{1.0f, 4.5f, 8.0f, 11.5f, 15.0f};

    public BlockFlagPole() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y).func_177226_a(VARIANT, (Comparable)((Object)Variants.OAK)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List<ItemStack> par3List) {
        for (int i = 0; i < Variants.values().length; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof IFlagHolder) {
            int side = ((IFlagHolder)te).getOrientation();
            if (side == 1) {
                return state.func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Z);
            }
            if (side == 2) {
                return state.func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.X);
            }
        }
        return state.func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y);
    }

    public int func_180651_a(IBlockState state) {
        return ((Variants)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Variants.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Variants)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{field_176298_M, VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World world, BlockPos pos) {
        return this.func_180640_a(world, pos, null);
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IFlagHolder) {
            switch (((IFlagHolder)te).getOrientation()) {
                case 0: {
                    return new AxisAlignedBB((double)((float)pos.func_177958_n() + 0.375f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.375f), (double)((float)pos.func_177958_n() + 0.625f), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.625f));
                }
                case 1: {
                    return new AxisAlignedBB((double)((float)pos.func_177958_n() + 0.375f), (double)((float)pos.func_177956_o() + 0.8125f), (double)pos.func_177952_p(), (double)((float)pos.func_177958_n() + 0.625f), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
                }
                case 2: {
                    return new AxisAlignedBB((double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 0.8125f), (double)((float)pos.func_177952_p() + 0.375f), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + 0.625f));
                }
            }
        }
        return super.func_180640_a(world, pos, state);
    }

    public float getTextDim(int metadata, int section) {
        if (metadata % 7 == 4) {
            return ironTexDims[section];
        }
        return woodTexDims[section];
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }

    public int func_149645_b() {
        return 3;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState i) {
        return new TileEntityFlagPole();
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState par5) {
        TileEntity te;
        if (!par1World.field_72995_K && (te = par1World.func_175625_s(pos)) instanceof IFlagHolder) {
            List<ItemStack> flags = ((IFlagHolder)te).getFlags();
            for (ItemStack f : flags) {
                par1World.func_72838_d((Entity)new EntityItem(par1World, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), f));
            }
            ((IFlagHolder)te).clearFlags();
        }
        super.func_180663_b(par1World, pos, par5);
    }

    public static enum Variants implements IStringSerializable
    {
        OAK("oak"),
        SPRUCE("spruce"),
        BIRCH("birch"),
        JUNGLE("jungle"),
        IRON("iron"),
        ACACIA("acacia"),
        DARK_OAK("dark_oak");

        private final String name;

        private Variants(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static Variants byMetadata(int meta) {
            Variants[] vals = Variants.values();
            return vals[meta % vals.length];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

