/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import mods.battlegear2.api.DefaultMesh;
import mods.battlegear2.client.renderer.BaseModelLoader;
import mods.battlegear2.items.ItemShield;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.BlockPart;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderItemInFrameEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.util.vector.Vector3f;

public class ShieldModelLoader
extends BaseModelLoader {
    private final Vector3f backTranslation;
    private final Vector3f trimTranslation;
    private static final Pattern NUMBER = Pattern.compile("\\d");
    private static final String BACK_EXTENSION = ".back";
    private static final String TRIM_EXTENSION = ".trim";

    public ShieldModelLoader() {
        this(0.0f, 0.5f);
    }

    public ShieldModelLoader(float backWidth, float trimWidth) {
        this.backTranslation = new Vector3f(0.0f, 0.0f, backWidth);
        this.trimTranslation = new Vector3f(0.0f, 0.0f, trimWidth);
    }

    @SubscribeEvent
    public void onFrame(RenderItemInFrameEvent frameEvent) {
        if (frameEvent.item.func_77973_b() instanceof ItemShield) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            if (!Minecraft.func_71410_x().func_175599_af().func_175050_a(frameEvent.item)) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().func_175599_af().func_175049_a(frameEvent.item, null, ItemCameraTransforms.TransformType.GUI);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            frameEvent.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onModelBaked(ModelBakeEvent modelBakeEvent) {
        this.setLoader(modelBakeEvent.modelLoader);
        for (ItemShield shield : BattlegearConfig.shield) {
            IFlexibleBakedModel baked;
            ModelBlock front;
            ModelBlock internalFrontModel;
            ModelResourceLocation mainLoc;
            ResourceLocation itemLoc;
            IModel originalModel;
            if (shield == null || !((originalModel = this.getModel(itemLoc = new ResourceLocation((mainLoc = DefaultMesh.INVENTORY.func_178113_a(new ItemStack((Item)shield))).func_110624_b(), "item/" + mainLoc.func_110623_a()))) instanceof IRetexturableModel) || (internalFrontModel = this.getInternalModel(originalModel)) == null || (front = this.makeItem(internalFrontModel)) == null || (baked = this.wrap(this.join((IRetexturableModel)originalModel, front), (ResourceLocation)mainLoc)) == null) continue;
            modelBakeEvent.modelRegistry.func_82595_a((Object)mainLoc, (Object)baked);
        }
        this.setLoader(null);
    }

    private ModelBlock join(IRetexturableModel model, ModelBlock front) {
        HashMap temp = new HashMap();
        temp.putAll(front.field_178318_c);
        int backIndex = -1;
        int trimIndex = -1;
        HashMap copy = new HashMap();
        for (Map.Entry entry : temp.entrySet()) {
            String[] number;
            if (!((String)entry.getKey()).startsWith("layer")) continue;
            if (((String)entry.getValue()).endsWith(BACK_EXTENSION)) {
                number = NUMBER.split((CharSequence)entry.getKey(), 2);
                backIndex = Integer.valueOf(((String)entry.getKey()).substring(number[0].length()));
                continue;
            }
            if (!((String)entry.getValue()).endsWith(TRIM_EXTENSION)) continue;
            number = NUMBER.split((CharSequence)entry.getKey(), 2);
            trimIndex = Integer.valueOf(((String)entry.getKey()).substring(number[0].length()));
            copy.put("layer0", entry.getValue());
        }
        ArrayList<BlockPart> elements = new ArrayList<BlockPart>();
        if (trimIndex != -1) {
            ModelBlock trim;
            String trimTexture = (String)copy.get("layer0");
            for (String key : temp.keySet()) {
                copy.put(key, trimTexture);
            }
            ModelBlock internaltrim = this.getInternalModel(model.retexture(ImmutableMap.copyOf(copy)));
            if (internaltrim != null && (trim = this.makeItem(internaltrim)) != null) {
                for (BlockPart part : trim.func_178298_a()) {
                    part.field_178240_c.remove(EnumFacing.SOUTH);
                    HashMap faces = new HashMap();
                    for (Map.Entry entry : part.field_178240_c.entrySet()) {
                        if (entry.getValue() == null) continue;
                        faces.put(entry.getKey(), new BlockPartFace(null, trimIndex, "layer" + trimIndex, ((BlockPartFace)entry.getValue()).field_178243_e));
                    }
                    part.field_178240_c.putAll(faces);
                    Vector3f.sub((Vector3f)part.field_178241_a, (Vector3f)this.trimTranslation, (Vector3f)part.field_178241_a);
                    Vector3f.sub((Vector3f)part.field_178239_b, (Vector3f)this.trimTranslation, (Vector3f)part.field_178239_b);
                    Vector3f.sub((Vector3f)part.field_178239_b, (Vector3f)this.trimTranslation, (Vector3f)part.field_178239_b);
                    elements.add(part);
                }
            }
        }
        for (BlockPart part : front.func_178298_a()) {
            BlockPartFace face;
            if (trimIndex != -1 && (face = (BlockPartFace)part.field_178240_c.get(EnumFacing.NORTH)) != null && face.field_178245_c == trimIndex) continue;
            Vector3f.add((Vector3f)part.field_178239_b, (Vector3f)this.backTranslation, (Vector3f)part.field_178239_b);
            if (!(backIndex == -1 || (face = (BlockPartFace)part.field_178240_c.get(EnumFacing.SOUTH)) == null || face.field_178245_c == backIndex && face.field_178242_d != null && face.field_178242_d.equals("layer" + backIndex))) {
                part.field_178240_c.put(EnumFacing.SOUTH, new BlockPartFace(face.field_178244_b, backIndex, "layer" + backIndex, face.field_178243_e));
            }
            face = (BlockPartFace)part.field_178240_c.get(EnumFacing.NORTH);
            if (!(trimIndex == -1 || face == null || face.field_178245_c == trimIndex && face.field_178242_d != null && face.field_178242_d.equals("layer" + trimIndex))) {
                part.field_178240_c.put(EnumFacing.NORTH, new BlockPartFace(face.field_178244_b, trimIndex, "layer" + trimIndex, face.field_178243_e));
            }
            if (face != null && face.field_178242_d != null && ((String)temp.get(face.field_178242_d)).endsWith(BACK_EXTENSION)) {
                part.field_178240_c.put(EnumFacing.NORTH, new BlockPartFace(face.field_178244_b, 0, "layer0", face.field_178243_e));
            }
            if ((face = (BlockPartFace)part.field_178240_c.get(EnumFacing.SOUTH)) != null && face.field_178242_d != null && ((String)temp.get(face.field_178242_d)).endsWith(TRIM_EXTENSION)) {
                part.field_178240_c.put(EnumFacing.SOUTH, new BlockPartFace(face.field_178244_b, 0, "layer0", face.field_178243_e));
            }
            elements.add(part);
        }
        return new ModelBlock(null, elements, (Map)ImmutableMap.copyOf((Map)front.field_178318_c), false, false, front.func_181682_g());
    }
}

