/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.client.utils.BattlegearRenderHelper;
import mods.battlegear2.items.ItemQuiver;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class QuiverItremRenderer
implements IItemRenderer {
    private RenderItem itemRenderer;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type != IItemRenderer.ItemRenderType.FIRST_PERSON_MAP && item != null && item.func_77973_b() instanceof ItemQuiver;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return type == IItemRenderer.ItemRenderType.ENTITY && (helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.itemRenderer == null) {
            this.itemRenderer = new RenderItem();
        }
        ItemQuiver quiver = (ItemQuiver)item.func_77973_b();
        int col = quiver.getColor(item);
        float red = (float)(col >> 16 & 0xFF) / 255.0f;
        float green = (float)(col >> 8 & 0xFF) / 255.0f;
        float blue = (float)(col & 0xFF) / 255.0f;
        boolean hasArrows = false;
        int maxStack = quiver.getSlotCount(item);
        for (int i = 0; i < maxStack && !hasArrows; ++i) {
            hasArrows = quiver.getStackInSlot(item, i) != null;
        }
        IIcon icon = item.getIconIndex();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        switch (type) {
            case INVENTORY: {
                GL11.glColor3f((float)red, (float)green, (float)blue);
                GL11.glEnable((int)3008);
                this.itemRenderer.renderIcon(0, 0, icon, 16, 16);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                icon = quiver.quiverDetails;
                this.itemRenderer.renderIcon(0, 0, icon, 16, 16);
                if (!hasArrows) break;
                icon = quiver.quiverArrows;
                this.itemRenderer.renderIcon(0, 0, icon, 16, 16);
                break;
            }
            case ENTITY: {
                GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0f);
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                if (data.length > 1 && data[1] instanceof EntityLivingBase) {
                    EntityLivingBase livingBase = (EntityLivingBase)data[1];
                    if (livingBase == null || livingBase.equals((Object)BattlegearRenderHelper.dummyEntity)) {
                        GL11.glPopMatrix();
                        return;
                    }
                    if (livingBase instanceof IBattlePlayer && ((IBattlePlayer)livingBase).isBattlemode()) {
                        GL11.glPopMatrix();
                        return;
                    }
                }
                GL11.glColor3f((float)red, (float)green, (float)blue);
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                icon = quiver.quiverDetails;
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.0625f);
                if (!hasArrows) break;
                GL11.glTranslated((double)0.0, (double)0.0, (double)-0.015625);
                icon = quiver.quiverArrows;
                ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)icon.getMaxU(), (float)icon.getMinV(), (float)icon.getMinU(), (float)icon.getMaxV(), (int)icon.getIconWidth(), (int)icon.getIconHeight(), (float)0.03125f);
            }
        }
        GL11.glPopMatrix();
    }
}

