/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import java.util.List;
import mods.battlegear2.api.heraldry.IFlagHolder;
import mods.battlegear2.client.utils.ImageCache;
import mods.battlegear2.heraldry.TileEntityFlagPole;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;

public class FlagPoleTileRenderer
extends TileEntitySpecialRenderer<TileEntityFlagPole> {
    public static int period = 250;
    public static int flag_sections = 16;

    public static double getZLevel(float x, float size, long time) {
        return Math.pow(x, 0.5 / (double)(size / 5.0f)) * Math.sin(Math.PI * (double)(-x / size * 3.0f + (float)(time % (long)period) / (0.5f * (float)period))) / 4.0;
    }

    public void renderTileEntityAt(TileEntityFlagPole tileentity, double d0, double d1, double d2, float f, int damage) {
        IBlockState banner = tileentity.func_145831_w().func_180495_p(tileentity.func_174877_v());
        if (banner.func_177230_c() instanceof BlockAir) {
            return;
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int type = banner.func_177230_c().func_176201_c(banner);
        int side = tileentity.getOrientation();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)d0, (double)d1, (double)d2);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        float[] dims = new float[5];
        for (int i = 0; i < 5; ++i) {
            dims[i] = tileentity.getTextureDimensions(type, i);
        }
        switch (side) {
            case 0: {
                this.renderYFlag(tileentity, d0, d1, d2, f, type);
                break;
            }
            case 1: {
                this.renderZFlag(tileentity, d0, d1, d2, f, type);
                break;
            }
            case 2: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                this.renderZFlag(tileentity, d0, d1, d2, f, type);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void renderZFlag(IFlagHolder tileentity, double d0, double d1, double d2, float f, int type) {
        List<ItemStack> flags = tileentity.getFlags();
        if (flags.size() > 0) {
            Tessellator tess = Tessellator.func_178181_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int flagIndex = 0; flagIndex < flags.size(); ++flagIndex) {
                ItemStack flag = flags.get(flagIndex);
                ImageCache.setTexture(flag);
                if (flag_sections == 0) {
                    tess.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    tess.func_178180_c().func_181662_b(0.5, (double)((float)(-flagIndex + 1) - 0.125f), 0.0).func_181673_a(0.0, 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5, (double)((float)(-flagIndex) - 0.125f), 0.0).func_181673_a(1.0, 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5, (double)((float)(-flagIndex) - 0.125f), 1.0).func_181673_a(1.0, 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5, (double)((float)(-flagIndex + 1) - 0.125f), 1.0).func_181673_a(0.0, 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5, (double)((float)(-flagIndex + 1) - 0.125f), 1.0).func_181673_a(0.0, 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5, (double)((float)(-flagIndex) - 0.125f), 1.0).func_181673_a(1.0, 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5, (double)((float)(-flagIndex) - 0.125f), 0.0).func_181673_a(1.0, 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5, (double)((float)(-flagIndex + 1) - 0.125f), 0.0).func_181673_a(0.0, 0.001).func_181675_d();
                    tess.func_78381_a();
                    continue;
                }
                long time = System.currentTimeMillis();
                for (int i = 0; i < flag_sections; ++i) {
                    tess.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    double z1 = FlagPoleTileRenderer.getZLevel((float)(flag_sections - i) / (float)flag_sections + (float)flagIndex, 5.0f, time) / 5.0;
                    double z2 = FlagPoleTileRenderer.getZLevel((float)(flag_sections - i + 1) / (float)flag_sections + (float)flagIndex, 5.0f, time) / 5.0;
                    tess.func_178180_c().func_181662_b(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / (float)flag_sections - 0.125f), 0.0).func_181673_a((double)((float)(i + 1) / (float)flag_sections), 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5 + z2, (double)((float)(-flagIndex) + (float)i / (float)flag_sections - 0.125f), 0.0).func_181673_a((double)((float)i / (float)flag_sections), 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5 + z2, (double)((float)(-flagIndex) + (float)i / (float)flag_sections - 0.125f), 1.0).func_181673_a((double)((float)i / (float)flag_sections), 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / (float)flag_sections - 0.125f), 1.0).func_181673_a((double)((float)(i + 1) / (float)flag_sections), 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / (float)flag_sections - 0.125f), 1.0).func_181673_a((double)((float)(i + 1) / (float)flag_sections), 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5 + z2, (double)((float)(-flagIndex) + (float)i / (float)flag_sections - 0.125f), 1.0).func_181673_a((double)((float)i / (float)flag_sections), 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5 + z2, (double)((float)(-flagIndex) + (float)i / (float)flag_sections - 0.125f), 0.0).func_181673_a((double)((float)i / (float)flag_sections), 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / (float)flag_sections - 0.125f), 0.0).func_181673_a((double)((float)(i + 1) / (float)flag_sections), 0.999).func_181675_d();
                    tess.func_78381_a();
                }
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
        }
    }

    private void renderYFlag(IFlagHolder tileentity, double d0, double d1, double d2, float f, int type) {
        List<ItemStack> flags = tileentity.getFlags();
        if (flags.size() > 0) {
            Tessellator tess = Tessellator.func_178181_a();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179140_f();
            for (int flagIndex = 0; flagIndex < flags.size(); ++flagIndex) {
                ItemStack flag = flags.get(flagIndex);
                ImageCache.setTexture(flag);
                if (flag_sections == 0) {
                    tess.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)flagIndex), 0.0, 0.5).func_181673_a(0.0, 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)flagIndex - 1.0f), 0.0, 0.5).func_181673_a(1.0025, 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)flagIndex - 1.0f), 1.0, 0.5).func_181673_a(1.0025, 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)flagIndex), 1.0, 0.5).func_181673_a(0.0, 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)flagIndex), 1.0, 0.5).func_181673_a(0.0, 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)flagIndex - 1.0f), 1.0, 0.5).func_181673_a(1.0025, 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)flagIndex - 1.0f), 0.0, 0.5).func_181673_a(1.0025, 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)flagIndex), 0.0, 0.5).func_181673_a(0.0, 0.999).func_181675_d();
                    tess.func_78381_a();
                    continue;
                }
                long time = System.currentTimeMillis();
                for (int i = 0; i < flag_sections; ++i) {
                    tess.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    double z1 = FlagPoleTileRenderer.getZLevel((float)i / (float)flag_sections + (float)flagIndex, 3.0f, time);
                    double z2 = FlagPoleTileRenderer.getZLevel((float)(i + 1) / (float)flag_sections + (float)flagIndex, 3.0f, time);
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)i / (float)flag_sections - (float)flagIndex), 0.0, 0.5 + z1).func_181673_a((double)((float)i / (float)flag_sections), 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)(i + 1) / (float)flag_sections - (float)flagIndex), 0.0, 0.5 + z2).func_181673_a((double)((float)(i + 1) / (float)flag_sections), 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)(i + 1) / (float)flag_sections - (float)flagIndex), 1.0025, 0.5 + z2).func_181673_a((double)((float)(i + 1) / (float)flag_sections), 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)i / (float)flag_sections - (float)flagIndex), 1.0025, 0.5 + z1).func_181673_a((double)((float)i / (float)flag_sections), 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)i / (float)flag_sections - (float)flagIndex), 1.0025, 0.5 + z1).func_181673_a((double)((float)i / (float)flag_sections), 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)(i + 1) / (float)flag_sections - (float)flagIndex), 1.0025, 0.5 + z2).func_181673_a((double)((float)(i + 1) / (float)flag_sections), 0.001).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)(i + 1) / (float)flag_sections - (float)flagIndex), 0.0, 0.5 + z2).func_181673_a((double)((float)(i + 1) / (float)flag_sections), 0.999).func_181675_d();
                    tess.func_178180_c().func_181662_b((double)(0.4375f - (float)i / (float)flag_sections - (float)flagIndex), 0.0, 0.5 + z1).func_181673_a((double)((float)i / (float)flag_sections), 0.999).func_181675_d();
                    tess.func_78381_a();
                }
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179084_k();
        }
    }
}

