/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import com.google.common.base.Function;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import mods.battlegear2.Battlegear;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.animation.ModelBlockAnimation;

public class BaseModelLoader {
    protected static final String LAYER = "layer";
    protected static final String BASE_LAYER = "layer0";
    private ModelLoader manager;

    protected final void setLoader(ModelLoader loader) {
        this.manager = loader;
    }

    protected final IModel getModel(ResourceLocation location) {
        try {
            return this.manager.getModel(location);
        }
        catch (IOException e) {
            return null;
        }
    }

    protected final ModelBlock getInternalModel(IModel model) {
        try {
            Field[] fields;
            for (Field f : fields = model.getClass().getDeclaredFields()) {
                if (f.getType() != ModelBlock.class) continue;
                f.setAccessible(true);
                return (ModelBlock)f.get(model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected final IFlexibleBakedModel wrap(ModelBlock model, ResourceLocation modelLocation) {
        try {
            return new IFlexibleBakedModel.Wrapper(this.bakeModel(model), Attributes.DEFAULT_BAKED_FORMAT);
        }
        catch (Throwable vanillaIssue) {
            Battlegear.logger.warn(vanillaIssue.toString());
            Battlegear.logger.warn("Encountered issue while trying to load model, trying fallback.");
            try {
                Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

                    public TextureAtlasSprite apply(ResourceLocation location) {
                        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
                    }
                };
                Constructor<?> ctor = Class.forName("net.minecraftforge.client.model.ModelLoader$VanillaModelWrapper").getDeclaredConstructor(ModelLoader.class, ResourceLocation.class, ModelBlock.class, ModelBlockAnimation.class);
                ctor.setAccessible(true);
                String modelPath = modelLocation.func_110623_a();
                if (modelPath.startsWith("models/")) {
                    modelPath = modelPath.substring("models/".length());
                }
                ResourceLocation armatureLocation = new ResourceLocation(modelLocation.func_110624_b(), "armatures/" + modelPath + ".json");
                Object bakeable = ctor.newInstance(this.manager, null, model, Animation.INSTANCE.loadVanillaAnimation(armatureLocation));
                ctor.setAccessible(false);
                return ((IModel)bakeable).bake((IModelState)ModelRotation.X0_Y0, Attributes.DEFAULT_BAKED_FORMAT, (Function)textureGetter);
            }
            catch (Throwable forgeIssue) {
                Battlegear.logger.warn(forgeIssue.toString());
                Battlegear.logger.warn("Encountered issue while trying model loading fallback. Last fallback: crappy vanilla model. Sorry :(");
                return null;
            }
        }
    }

    protected final IBakedModel bakeModel(ModelBlock model) {
        return this.manager.func_177578_a(model, ModelRotation.X0_Y0, false);
    }

    protected final ModelBlock makeItem(ModelBlock model) {
        return this.manager.func_177582_d(model);
    }
}

