/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Map;
import mods.battlegear2.api.weapons.Attributes;
import mods.battlegear2.api.weapons.IBackStabbable;
import mods.battlegear2.api.weapons.IHitTimeModifier;
import mods.battlegear2.api.weapons.IPenetrateWeapon;
import mods.battlegear2.api.weapons.IPotionEffect;
import mods.battlegear2.api.weapons.ISpecialEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public final class WeaponHookContainerClass {
    public static final WeaponHookContainerClass INSTANCE = new WeaponHookContainerClass();
    public static final float backstabFuzzy = 0.01f;

    private WeaponHookContainerClass() {
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        EntityLivingBase entityHitting;
        ItemStack stack;
        Entity attacker;
        if (event.entityLiving instanceof EntityPlayer && ((EntityPlayer)event.entityLiving).field_71075_bZ.field_75098_d) {
            return;
        }
        EntityLivingBase entityHit = event.entityLiving;
        int hurtTimeTemp = entityHit.field_70737_aN;
        int hurtResistanceTimeTemp = entityHit.field_70172_ad;
        if (event.source instanceof EntityDamageSource && !event.source.field_76373_n.startsWith("battlegearExtra") && !(event.source instanceof EntityDamageSourceIndirect) && (attacker = event.source.func_76346_g()) instanceof EntityLivingBase && (stack = (entityHitting = (EntityLivingBase)attacker).func_70694_bm()) != null) {
            boolean hit = false;
            if (stack.func_77973_b() instanceof IBackStabbable) {
                hit = this.performBackStab(stack.func_77973_b(), entityHit, entityHitting);
            }
            if (stack.func_77973_b() instanceof ISpecialEffect) {
                boolean tempHit = ((ISpecialEffect)stack.func_77973_b()).performEffects(entityHit, entityHitting);
                if (!hit) {
                    hit = tempHit;
                }
            }
            if (stack.func_77973_b() instanceof IPotionEffect) {
                this.performEffects(((IPotionEffect)stack.func_77973_b()).getEffectsOnHit(entityHit, entityHitting), entityHit);
            }
            if (!entityHit.field_70170_p.field_72995_K) {
                if (stack.func_77973_b() instanceof IHitTimeModifier) {
                    if ((float)hurtResistanceTimeTemp > (float)entityHit.field_70771_an * 0.5f) {
                        boolean apply;
                        int timeModifier = ((IHitTimeModifier)stack.func_77973_b()).getHitTime(stack, entityHit);
                        boolean bl = apply = timeModifier != 0;
                        if (timeModifier < 0 && entityHit.func_70643_av() == entityHitting && entityHit.field_70173_aa - entityHit.func_142015_aE() < -timeModifier) {
                            apply = false;
                        }
                        if (apply) {
                            entityHit.field_70172_ad = hurtResistanceTimeTemp + timeModifier;
                            if (entityHit.field_70172_ad < 0) {
                                entityHit.field_70172_ad = 0;
                            }
                        }
                    }
                } else if (hit) {
                    entityHit.field_70737_aN = hurtTimeTemp;
                    entityHit.field_70172_ad = hurtResistanceTimeTemp;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent hurt) {
        if (hurt.source.func_76346_g() instanceof EntityLivingBase && hurt.source instanceof EntityDamageSource && hurt.entityLiving.field_70737_aN == 0) {
            ItemStack itemStack;
            float damage;
            int hurtResistanceTimeTemp = hurt.entityLiving.field_70172_ad;
            if (!hurt.source.field_76373_n.startsWith("battlegearExtra") && hurt.source.func_76346_g().func_70115_ae() && (damage = (float)((EntityLivingBase)hurt.source.func_76346_g()).func_110148_a((IAttribute)Attributes.mountedBonus).func_111126_e()) > 0.0f) {
                hurt.entityLiving.field_70172_ad = 0;
                hurt.entityLiving.func_70097_a((DamageSource)new EntityDamageSource("battlegearExtra.mounted", hurt.source.func_76346_g()), damage);
            }
            if ((itemStack = ((EntityLivingBase)hurt.source.func_76346_g()).func_70694_bm()) != null && itemStack.func_77973_b() instanceof IPenetrateWeapon) {
                hurt.entityLiving.field_70172_ad = 0;
                hurt.entityLiving.func_70097_a(DamageSource.field_76377_j, (float)((IPenetrateWeapon)itemStack.func_77973_b()).getPenetratingPower(itemStack));
            }
            hurt.entityLiving.field_70172_ad = hurtResistanceTimeTemp;
        }
    }

    @SubscribeEvent
    public void onLivingConstructor(EntityEvent.EntityConstructing constructing) {
        if (constructing.entity instanceof EntityLivingBase) {
            BaseAttributeMap attributeMap = ((EntityLivingBase)constructing.entity).func_110140_aT();
            attributeMap.func_111150_b((IAttribute)Attributes.armourPenetrate);
            attributeMap.func_111150_b((IAttribute)Attributes.daze);
            if (constructing.entity instanceof EntityPlayer) {
                attributeMap.func_111150_b((IAttribute)Attributes.extendedReach).func_111128_a(-2.2);
            }
            attributeMap.func_111150_b((IAttribute)Attributes.attackSpeed);
            attributeMap.func_111150_b((IAttribute)Attributes.mountedBonus);
        }
    }

    public boolean performBackStab(Item item, EntityLivingBase entityHit, EntityLivingBase entityHitting) {
        double[] victimView = new double[]{entityHit.func_70040_Z().field_72450_a, entityHit.func_70040_Z().field_72449_c};
        double[] dArray = new double[]{entityHitting.func_70040_Z().field_72450_a, entityHitting.func_70040_Z().field_72449_c};
        double[] murdererView = dArray;
        if (Math.abs(victimView[0] * murdererView[1] - victimView[1] * murdererView[0]) < (double)0.01f && Math.signum(victimView[0]) == Math.signum(murdererView[0]) && Math.signum(victimView[1]) == Math.signum(murdererView[1])) {
            return ((IBackStabbable)item).onBackStab(entityHit, entityHitting);
        }
        return false;
    }

    public void performEffects(Map<PotionEffect, Float> map, EntityLivingBase entityHit) {
        double roll = Math.random();
        for (PotionEffect effect : map.keySet()) {
            if (entityHit.func_82165_m(effect.func_76456_a()) || !((double)map.get(effect).floatValue() > roll)) continue;
            entityHit.func_70690_d(new PotionEffect(effect));
        }
    }
}

