/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import java.util.Map;
import mods.battlegear2.api.weapons.Attributes;
import mods.battlegear2.api.weapons.IBackStabbable;
import mods.battlegear2.api.weapons.IHitTimeModifier;
import mods.battlegear2.api.weapons.IPenetrateWeapon;
import mods.battlegear2.api.weapons.IPotionEffect;
import mods.battlegear2.api.weapons.ISpecialEffect;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.BaseAttributeMap;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerUseItemEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class WeaponHookContainerClass {
    public static final WeaponHookContainerClass INSTANCE = new WeaponHookContainerClass();
    private static final float backstabFuzzy = 0.01f;
    private static final int[] dazeEffects = new int[]{Potion.field_76421_d.func_76396_c(), Potion.field_76431_k.func_76396_c(), Potion.field_76440_q.func_76396_c(), Potion.field_76437_t.func_76396_c()};
    public boolean doBlocking = false;

    private WeaponHookContainerClass() {
    }

    @SubscribeEvent
    public void onAttack(LivingAttackEvent event) {
        EntityLivingBase entityHitting;
        ItemStack stack;
        Entity attacker;
        if (event.entityLiving instanceof EntityPlayer && ((EntityPlayer)event.entityLiving).field_71075_bZ.field_75098_d) {
            return;
        }
        EntityLivingBase entityHit = event.entityLiving;
        int hurtTimeTemp = entityHit.field_70737_aN;
        int hurtResistanceTimeTemp = entityHit.field_70172_ad;
        if (event.source instanceof EntityDamageSource && !event.source.field_76373_n.startsWith("battlegearExtra") && !(event.source instanceof EntityDamageSourceIndirect) && (attacker = event.source.func_76346_g()) instanceof EntityLivingBase && (stack = (entityHitting = (EntityLivingBase)attacker).func_70694_bm()) != null) {
            boolean hit = false;
            if (stack.func_77973_b() instanceof IBackStabbable) {
                hit = this.performBackStab(stack.func_77973_b(), entityHit, entityHitting);
            }
            if (stack.func_77973_b() instanceof ISpecialEffect) {
                boolean tempHit = ((ISpecialEffect)stack.func_77973_b()).performEffects(entityHit, entityHitting);
                if (!hit) {
                    hit = tempHit;
                }
            }
            if (stack.func_77973_b() instanceof IPotionEffect) {
                this.performEffects(((IPotionEffect)stack.func_77973_b()).getEffectsOnHit(entityHit, entityHitting), entityHit);
            }
            if (!entityHit.field_70170_p.field_72995_K) {
                int timeModifier = (int)(-entityHitting.func_110148_a((IAttribute)Attributes.attackSpeed).func_111126_e() * (double)entityHit.field_70771_an * 0.5);
                if (stack.func_77973_b() instanceof IHitTimeModifier) {
                    timeModifier = ((IHitTimeModifier)stack.func_77973_b()).getHitTime(stack, entityHit);
                }
                if (timeModifier != 0) {
                    if ((float)hurtResistanceTimeTemp > (float)entityHit.field_70771_an * 0.5f) {
                        if (timeModifier < 0 && entityHit.func_70643_av() == entityHitting && entityHit.field_70173_aa - entityHit.func_142013_aG() < -timeModifier) {
                            return;
                        }
                        entityHit.field_70172_ad = hurtResistanceTimeTemp + timeModifier;
                        if (entityHit.field_70172_ad < 0) {
                            entityHit.field_70172_ad = 0;
                        }
                    }
                } else if (hit) {
                    entityHit.field_70737_aN = hurtTimeTemp;
                    entityHit.field_70172_ad = hurtResistanceTimeTemp;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingHurt(LivingHurtEvent hurt) {
        if (hurt.source.func_76346_g() instanceof EntityLivingBase && hurt.source instanceof EntityDamageSource && hurt.entityLiving.field_70737_aN == 0) {
            float damage;
            EntityLivingBase source = (EntityLivingBase)hurt.source.func_76346_g();
            double chance = source.func_110148_a((IAttribute)Attributes.daze).func_111126_e();
            if (source.func_70681_au().nextDouble() < chance) {
                for (int effect : dazeEffects) {
                    if (hurt.entityLiving.func_82165_m(effect)) continue;
                    PotionEffect potion = new PotionEffect(effect, 60, 100);
                    potion.getCurativeItems().clear();
                    hurt.entityLiving.func_70690_d(potion);
                }
            }
            int hurtResistanceTimeTemp = hurt.entityLiving.field_70172_ad;
            if (!hurt.source.field_76373_n.startsWith("battlegearExtra") && source.func_70115_ae() && (damage = (float)source.func_110148_a((IAttribute)Attributes.mountedBonus).func_111126_e()) > 0.0f) {
                hurt.entityLiving.field_70172_ad = 0;
                hurt.entityLiving.func_70097_a((DamageSource)new EntityDamageSource("battlegearExtra.mounted", (Entity)source), damage);
            }
            damage = (float)source.func_110148_a((IAttribute)Attributes.armourPenetrate).func_111126_e();
            ItemStack itemStack = source.func_70694_bm();
            if (itemStack != null && itemStack.func_77973_b() instanceof IPenetrateWeapon) {
                damage = ((IPenetrateWeapon)itemStack.func_77973_b()).getPenetratingPower(itemStack);
            }
            if (damage > 0.0f) {
                hurt.entityLiving.field_70172_ad = 0;
                hurt.entityLiving.func_70097_a(DamageSource.field_76377_j, damage);
            }
            hurt.entityLiving.field_70172_ad = hurtResistanceTimeTemp;
        }
    }

    @SubscribeEvent
    public void onLivingConstructor(EntityEvent.EntityConstructing constructing) {
        if (constructing.entity instanceof EntityLivingBase) {
            BaseAttributeMap attributeMap = ((EntityLivingBase)constructing.entity).func_110140_aT();
            attributeMap.func_111150_b((IAttribute)Attributes.armourPenetrate);
            attributeMap.func_111150_b((IAttribute)Attributes.daze);
            if (constructing.entity instanceof EntityPlayer) {
                attributeMap.func_111150_b((IAttribute)Attributes.extendedReach).func_111128_a(-2.2);
            }
            attributeMap.func_111150_b((IAttribute)Attributes.attackSpeed);
            attributeMap.func_111150_b((IAttribute)Attributes.mountedBonus);
        }
    }

    public boolean performBackStab(Item item, EntityLivingBase entityHit, EntityLivingBase entityHitting) {
        double[] victimView = new double[]{entityHit.func_70040_Z().field_72450_a, entityHit.func_70040_Z().field_72449_c};
        double[] dArray = new double[]{entityHitting.func_70040_Z().field_72450_a, entityHitting.func_70040_Z().field_72449_c};
        double[] murdererView = dArray;
        if (Math.abs(victimView[0] * murdererView[1] - victimView[1] * murdererView[0]) < (double)0.01f && Math.signum(victimView[0]) == Math.signum(murdererView[0]) && Math.signum(victimView[1]) == Math.signum(murdererView[1])) {
            return ((IBackStabbable)item).onBackStab(entityHit, entityHitting);
        }
        return false;
    }

    public void performEffects(Map<PotionEffect, Float> map, EntityLivingBase entityHit) {
        double roll = Math.random();
        for (Map.Entry<PotionEffect, Float> effect : map.entrySet()) {
            if (entityHit.func_82165_m(effect.getKey().func_76456_a()) || !((double)effect.getValue().floatValue() > roll)) continue;
            entityHit.func_70690_d(new PotionEffect(effect.getKey()));
        }
    }

    @SubscribeEvent
    public void onBlock(PlayerUseItemEvent.Start use) {
        if (!this.doBlocking && use.duration > 0 && use.item.func_77975_n() == EnumAction.BLOCK) {
            use.setCanceled(true);
        }
    }
}

