/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2;

import java.util.List;
import mods.battlegear2.Battlegear;
import mods.battlegear2.api.EnchantmentHelper;
import mods.battlegear2.api.IHandListener;
import mods.battlegear2.api.IOffhandListener;
import mods.battlegear2.api.PlayerEventChild;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.IBattlePlayer;
import mods.battlegear2.api.core.InventoryExceptionEvent;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.heraldry.IFlagHolder;
import mods.battlegear2.api.heraldry.IHeraldryItem;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.shield.IArrowCatcher;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.api.weapons.Attributes;
import mods.battlegear2.api.weapons.IExtendedReachWeapon;
import mods.battlegear2.enchantments.BaseEnchantment;
import mods.battlegear2.packet.BattlegearShieldFlashPacket;
import mods.battlegear2.packet.BattlegearSyncItemPacket;
import mods.battlegear2.utils.EnumBGAnimations;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public final class BattlemodeHookContainerClass {
    public static final BattlemodeHookContainerClass INSTANCE = new BattlemodeHookContainerClass();

    private BattlemodeHookContainerClass() {
    }

    private boolean isFake(Entity entity) {
        return entity instanceof FakePlayer;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityPlayer && !this.isFake(event.entity)) {
            if (!(((EntityPlayer)event.entity).field_71071_by instanceof InventoryPlayerBattle) && !MinecraftForge.EVENT_BUS.post((Event)new InventoryExceptionEvent((EntityPlayer)event.entity))) {
                throw new RuntimeException("Player inventory has been replaced with " + ((EntityPlayer)event.entity).field_71071_by.getClass() + " which is incompatible with Mine & Blade:Battlegear.");
            }
            if (event.entity instanceof EntityPlayerMP) {
                Battlegear.packetHandler.sendPacketToPlayer(new BattlegearSyncItemPacket((EntityPlayer)event.entity).generatePacket(), (EntityPlayerMP)event.entity);
            }
        }
        if (event.entity instanceof EntityLivingBase) {
            ((EntityLivingBase)event.entity).func_110140_aT().func_111152_a(Attributes.daze.func_111108_a()).func_111128_a(0.0);
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent event) {
        if (((IBattlePlayer)event.entityPlayer).getSpecialActionTimer() > 0) {
            event.setCanceled(true);
            return;
        }
        double reachMod = this.maxReachDistance(event.entityPlayer);
        if (reachMod < (double)event.entityPlayer.func_70032_d(event.target)) {
            event.setCanceled(true);
        }
    }

    public double maxReachDistance(EntityPlayer player) {
        IAttributeInstance instance = player.func_110148_a((IAttribute)Attributes.extendedReach);
        double reachMod = 0.0;
        if (instance != null) {
            reachMod = instance.func_111126_e();
            ItemStack itemStack = player.func_71045_bC();
            if (itemStack != null) {
                reachMod = itemStack.func_77973_b() instanceof IExtendedReachWeapon && !itemStack.func_111283_C().containsKey((Object)Attributes.extendedReach.func_111108_a()) ? (double)((IExtendedReachWeapon)itemStack.func_77973_b()).getReachModifierInBlocks(itemStack) : (itemStack.func_77973_b() instanceof ItemBlock ? (reachMod += (double)0.1f) : (reachMod -= instance.func_111125_b()));
            }
        }
        return reachMod + (double)BattlemodeHookContainerClass.defaultReachDistance(player.field_71075_bZ.field_75098_d);
    }

    public static float defaultReachDistance(boolean creative) {
        return creative ? 5.0f : 4.5f;
    }

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        TileEntity tile;
        if (this.isFake((Entity)event.entityPlayer)) {
            return;
        }
        if (((IBattlePlayer)event.entityPlayer).getSpecialActionTimer() > 0) {
            event.setCanceled(true);
            event.entityPlayer.field_82175_bq = false;
        } else if (BattlegearUtils.isPlayerInBattlemode(event.entityPlayer)) {
            if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
                ItemStack mainHandItem = event.entityPlayer.func_71045_bC();
                if (mainHandItem != null && mainHandItem.func_77973_b() instanceof IHandListener) {
                    PlayerInteractEvent copy = BattlemodeHookContainerClass.copy(event);
                    copy.useItem = Event.Result.DENY;
                    Event.Result swing = ((IHandListener)mainHandItem.func_77973_b()).onClickBlock(copy, mainHandItem, ((InventoryPlayerBattle)event.entityPlayer.field_71071_by).getCurrentOffhandWeapon(), false);
                    if (swing != Event.Result.DEFAULT) {
                        event.entityPlayer.field_82175_bq = false;
                    }
                    if (swing == Event.Result.DENY) {
                        event.setCanceled(true);
                    } else {
                        event.useBlock = copy.useBlock;
                        event.useItem = copy.useItem;
                    }
                }
            } else {
                ItemStack mainHandItem;
                ItemStack offhandItem = ((InventoryPlayerBattle)event.entityPlayer.field_71071_by).getCurrentOffhandWeapon();
                if (offhandItem == null) {
                    BattlemodeHookContainerClass.sendOffSwingEvent(event, null, null);
                } else if (BattlegearUtils.usagePriorAttack(offhandItem, event.entityPlayer, true) && ((mainHandItem = event.entityPlayer.func_71045_bC()) == null || !BattlegearUtils.usagePriorAttack(mainHandItem, event.entityPlayer, false))) {
                    event.setCanceled(true);
                }
            }
        } else if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (tile = event.entityPlayer.field_70170_p.func_175625_s(event.pos)) != null && tile instanceof IFlagHolder) {
            ItemStack mainHandItem = event.entityPlayer.func_71045_bC();
            if (mainHandItem == null) {
                List<ItemStack> flags;
                if (!event.entityPlayer.field_70170_p.field_72995_K && (flags = ((IFlagHolder)tile).getFlags()).size() > 0) {
                    ItemStack flag = flags.remove(flags.size() - 1);
                    event.entityPlayer.field_71071_by.func_70299_a(event.entityPlayer.field_71071_by.field_70461_c, flag);
                    event.entityPlayer.field_70170_p.func_175689_h(event.pos);
                }
            } else if (mainHandItem.func_77973_b() instanceof IHeraldryItem) {
                if (event.entityPlayer.field_70170_p.field_72995_K) {
                    event.useItem = Event.Result.DENY;
                } else if (((IFlagHolder)tile).addFlag(mainHandItem)) {
                    if (!event.entityPlayer.field_71075_bZ.field_75098_d) {
                        event.entityPlayer.field_71071_by.func_70298_a(event.entityPlayer.field_71071_by.field_70461_c, 1);
                    }
                    event.entityPlayer.field_70170_p.func_175689_h(event.pos);
                    event.setCanceled(true);
                }
            }
        }
    }

    private static PlayerInteractEvent copy(PlayerInteractEvent event) {
        PlayerInteractEvent copy = new PlayerInteractEvent(event.entityPlayer, event.action, event.pos, event.face, event.world);
        if (event.isCanceled()) {
            copy.setCanceled(true);
        }
        copy.useItem = event.useItem;
        copy.useBlock = event.useBlock;
        return copy;
    }

    public static boolean tryUseItem(EntityPlayer entityPlayer, ItemStack itemStack, Side side) {
        int i = itemStack.field_77994_a;
        int j = itemStack.func_77960_j();
        ItemStack itemstack1 = itemStack.func_77957_a(entityPlayer.func_130014_f_(), entityPlayer);
        if (itemstack1 == itemStack && (itemstack1 == null || itemstack1.field_77994_a == i && (side.isClient() || itemstack1.func_77988_m() <= 0 && itemstack1.func_77960_j() == j))) {
            return false;
        }
        BattlegearUtils.setPlayerCurrentItem(entityPlayer, itemstack1);
        if (side.isServer() && ((EntityPlayerMP)entityPlayer).field_71134_c.func_73083_d()) {
            itemstack1.field_77994_a = i;
            if (itemstack1.func_77984_f()) {
                itemstack1.func_77964_b(j);
            }
        }
        if (itemstack1.field_77994_a <= 0) {
            entityPlayer.func_71028_bD();
        }
        if (side.isServer() && !entityPlayer.func_71039_bw()) {
            ((EntityPlayerMP)entityPlayer).func_71120_a(entityPlayer.field_71069_bz);
        }
        return true;
    }

    public static void sendOffSwingEvent(PlayerInteractEvent player, ItemStack mainHandItem, ItemStack offhandItem) {
        PlayerEventChild.OffhandSwingEvent event = new PlayerEventChild.OffhandSwingEvent((PlayerEvent)BattlemodeHookContainerClass.copy(player), offhandItem);
        if (event.mainHand != null && BattlegearUtils.usagePriorAttack(event.mainHand, event.getPlayer(), false)) {
            event.setCanceled(true);
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            ((IBattlePlayer)event.entityPlayer).swingOffItem();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onOffhandSwingLast(PlayerEventChild.OffhandSwingEvent event) {
        Battlegear.proxy.sendAnimationPacket(EnumBGAnimations.OffHandSwing, event.entityPlayer);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void playerInteractEntity(EntityInteractEvent event) {
        if (this.isFake((Entity)event.entityPlayer)) {
            return;
        }
        if (((IBattlePlayer)event.entityPlayer).getSpecialActionTimer() > 0) {
            event.setCanceled(true);
            event.entityPlayer.field_82175_bq = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onOffhandAttack(PlayerEventChild.OffhandAttackEvent event) {
        if (event.offHand != null) {
            if (event.offHand.func_77973_b() instanceof IOffhandListener) {
                ((IOffhandListener)event.offHand.func_77973_b()).onAttackEntity(event, true);
            } else if (event.offHand.func_77973_b() instanceof IShield || BattlegearUtils.usagePriorAttack(event.offHand, event.getPlayer(), true)) {
                event.swingOffhand = false;
                event.shouldAttack = false;
            } else if (event.offHand.func_77973_b() instanceof IArrowContainer2) {
                event.setCanceled(true);
            }
        }
        if (event.mainHand != null) {
            if (event.mainHand.func_77973_b() instanceof IOffhandListener) {
                ((IOffhandListener)event.mainHand.func_77973_b()).onAttackEntity(event, false);
            } else if (event.shouldAttack && !event.isCanceled() && BattlegearUtils.usagePriorAttack(event.mainHand, event.getPlayer(), false)) {
                event.cancelParent = false;
            }
        }
        if (event.shouldAttack && !event.entityPlayer.field_71075_bZ.field_75098_d && !event.entityPlayer.func_71039_bw() && Battlegear.proxy.handleAttack(event.entityPlayer)) {
            event.shouldAttack = false;
            event.swingOffhand = false;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onOffhandUse(PlayerEventChild.UseOffhandItemEvent offhandItemEvent) {
        ItemStack mainHand;
        if (offhandItemEvent.offhand != null) {
            Event.Result cancel;
            ItemStack offhandItem = offhandItemEvent.offhand;
            if (!BattlegearUtils.usagePriorAttack(offhandItem, offhandItemEvent.getPlayer(), true)) {
                offhandItemEvent.event.useItem = Event.Result.DENY;
                if (offhandItemEvent.onBlock()) {
                    offhandItemEvent.event.useBlock = Event.Result.DENY;
                }
            }
            if (offhandItem.func_77973_b() instanceof IShield || offhandItem.func_77973_b() instanceof IArrowContainer2 || BattlegearUtils.usagePriorAttack(offhandItem, offhandItemEvent.getPlayer(), true)) {
                offhandItemEvent.swingOffhand = false;
            }
            Event.Result result = cancel = offhandItemEvent.swingOffhand ? Event.Result.DEFAULT : Event.Result.ALLOW;
            if (offhandItem.func_77973_b() instanceof IHandListener) {
                if (offhandItemEvent.onBlock()) {
                    cancel = ((IHandListener)offhandItem.func_77973_b()).onClickBlock(offhandItemEvent.event, offhandItemEvent.getPlayer().func_71045_bC(), offhandItem, true);
                } else if (offhandItem.func_77973_b() instanceof IOffhandListener) {
                    cancel = ((IOffhandListener)offhandItem.func_77973_b()).onClickAir(offhandItemEvent.getPlayer(), offhandItemEvent.getPlayer().func_71045_bC(), offhandItem);
                }
            }
            if (cancel == Event.Result.DENY) {
                offhandItemEvent.setCanceled(true);
            } else if (cancel == Event.Result.DEFAULT) {
                offhandItemEvent.swingOffhand = true;
            }
        }
        if (!offhandItemEvent.isCanceled() && offhandItemEvent.swingOffhand && (mainHand = offhandItemEvent.getPlayer().func_71045_bC()) != null && BattlegearUtils.usagePriorAttack(mainHand, offhandItemEvent.getPlayer(), false)) {
            offhandItemEvent.swingOffhand = false;
        }
    }

    @SubscribeEvent
    public void shieldHook(LivingHurtEvent event) {
        if (this.isFake(event.entity)) {
            return;
        }
        if (event.entity instanceof IBattlePlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (((IBattlePlayer)player).getSpecialActionTimer() > 0) {
                event.setCanceled(true);
            } else if (((IBattlePlayer)player).isBlockingWithShield()) {
                ItemStack shield = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
                float dmg = event.ammount;
                if (((IShield)shield.func_77973_b()).canBlock(shield, event.source)) {
                    boolean shouldBlock = true;
                    Entity opponent = event.source.func_76346_g();
                    if (opponent != null) {
                        float blockAngle;
                        float yaw = this.getAngle(opponent, (Entity)player);
                        boolean bl = shouldBlock = yaw < (blockAngle = ((IShield)shield.func_77973_b()).getBlockAngle(shield)) && yaw > -blockAngle;
                    }
                    if (shouldBlock) {
                        float red;
                        PlayerEventChild.ShieldBlockEvent blockEvent = new PlayerEventChild.ShieldBlockEvent(new PlayerEvent(player), shield, event.source, dmg);
                        MinecraftForge.EVENT_BUS.post((Event)blockEvent);
                        if (blockEvent.ammountRemaining > 0.0f) {
                            event.ammount = blockEvent.ammountRemaining;
                        } else {
                            event.setCanceled(true);
                        }
                        if (blockEvent.performAnimation) {
                            Battlegear.packetHandler.sendPacketAround((Entity)player, 32.0, new BattlegearShieldFlashPacket(player, dmg).generatePacket());
                            ((IShield)shield.func_77973_b()).blockAnimation(player, dmg);
                        }
                        if (event.source.func_76352_a() && event.source.func_76364_f() instanceof IProjectile && shield.func_77973_b() instanceof IArrowCatcher && ((IArrowCatcher)shield.func_77973_b()).catchArrow(shield, player, (IProjectile)event.source.func_76364_f())) {
                            ((InventoryPlayerBattle)player.field_71071_by).hasChanged = true;
                        }
                        if (blockEvent.damageShield && !player.field_71075_bZ.field_75098_d && (red = ((IShield)shield.func_77973_b()).getDamageReduction(shield, event.source)) < dmg) {
                            ((InventoryPlayerBattle)player.field_71071_by).swapHandItem();
                            shield.func_77972_a(Math.round(dmg - red), (EntityLivingBase)player);
                            if (shield.field_77994_a <= 0) {
                                player.func_71028_bD();
                            }
                            ((InventoryPlayerBattle)player.field_71071_by).swapHandItem();
                        }
                    }
                }
            }
        }
    }

    private float getAngle(Entity opponent, Entity player) {
        double d0 = opponent.field_70165_t - player.field_70165_t;
        double d1 = opponent.field_70161_v - player.field_70161_v;
        while (d0 * d0 + d1 * d1 < 1.0E-4) {
            d0 = (Math.random() - Math.random()) * 0.01;
            d1 = (Math.random() - Math.random()) * 0.01;
        }
        float yaw = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - player.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }

    @SubscribeEvent
    public void onDrop(LivingDropsEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (BaseEnchantment.bowLoot.isPresent() && event.source.func_76352_a() && event.source.func_76346_g() instanceof EntityLivingBase && !this.addLootFromEnchant(stack = ((EntityLivingBase)event.source.func_76346_g()).func_70694_bm(), event.drops) && event.recentlyHit && event.source.func_76346_g() instanceof IBattlePlayer && !this.isFake(event.source.func_76346_g()) && BattlegearUtils.isPlayerInBattlemode(player = (EntityPlayer)event.source.func_76346_g())) {
            stack = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
            this.addLootFromEnchant(stack, event.drops);
        }
    }

    private boolean addLootFromEnchant(ItemStack bow, List<EntityItem> drops) {
        int lvl = EnchantmentHelper.getEnchantmentLevel(BaseEnchantment.bowLoot, bow);
        if (lvl > 0) {
            for (EntityItem items : drops) {
                ItemStack drop = items.func_92059_d();
                if (drop == null || drop.func_77976_d() < drop.field_77994_a + lvl) continue;
                drop.field_77994_a += lvl;
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void addTracking(PlayerEvent.StartTracking event) {
        if (event.target instanceof EntityPlayer && !this.isFake(event.target)) {
            ((EntityPlayerMP)event.entityPlayer).field_71135_a.func_147359_a((Packet)new BattlegearSyncItemPacket((EntityPlayer)event.target).generatePacket());
        }
    }
}

