/*
 * Decompiled with CFR 0.152.
 */
package mods.mud.gui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mods.mud.UpdateEntry;
import mods.mud.exceptions.UnknownVersionFormatException;
import mods.mud.gui.GuiChangelogDownload;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;

public class GuiSlotModList
extends GuiScrollingList {
    private GuiChangelogDownload parent;
    private List<UpdateEntry> entries;

    public GuiSlotModList(GuiChangelogDownload parent, Collection<UpdateEntry> entries, int listWidth) {
        super(parent.getMinecraftInstance(), listWidth, parent.field_146295_m, 32, parent.field_146295_m - 65 + 4, 10, 25);
        this.parent = parent;
        this.entries = new ArrayList<UpdateEntry>(entries);
    }

    protected int getSize() {
        return this.entries.size();
    }

    protected void elementClicked(int var1, boolean var2) {
        this.parent.selectModIndex(var1);
    }

    protected boolean isSelected(int var1) {
        return this.parent.modIndexSelected(var1);
    }

    protected void drawBackground() {
        this.parent.func_146276_q_();
    }

    protected int getContentHeight() {
        return this.getSize() * 25 + 1;
    }

    protected void drawSlot(int listIndex, int var2, int var3, int var4, Tessellator var5) {
        ModContainer mc = this.entries.get(listIndex).getMc();
        if (Loader.instance().getModState(mc) == LoaderState.ModState.DISABLED) {
            this.drawString(mc.getName(), this.left + 3, var3 + 2, 0xFF2222);
            this.drawString("DISABLED", this.left + 3, var3 + 12, 0xFF2222);
        } else {
            this.drawString(mc.getName(), this.left + 3, var3 + 2, 0xFFFFFF);
            try {
                if (this.entries.get(listIndex).isUpToDate()) {
                    this.drawString(I18n.func_135052_a((String)"mud.version.latest", (Object[])new Object[0]), this.left + 3, var3 + 12, -16711936);
                } else {
                    this.drawString(I18n.func_135052_a((String)"mud.version.out", (Object[])new Object[0]), this.left + 3, var3 + 12, -65536);
                }
            }
            catch (UnknownVersionFormatException unknownVersionFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected void drawString(String text, int left, int right, int color) {
        this.parent.getFontRenderer().func_78276_b(this.parent.getFontRenderer().func_78269_a(text, this.listWidth - 10), left, right, color);
    }
}

