/*
 * Decompiled with CFR 0.152.
 */
package mods.mud;

import java.util.Arrays;

public class Release
implements Comparable<Release> {
    public final int[] version;
    public final EnumReleaseType type;
    public String url;
    public String download;
    public String md5;

    public Release(EnumReleaseType type, String url, int[] version, String download) {
        this(type, url, version, download, null);
    }

    public Release(EnumReleaseType type, String url, int[] version, String download, String md5) {
        this.type = type;
        this.url = url;
        this.version = version;
        this.download = download;
        this.md5 = md5;
    }

    @Override
    public int compareTo(Release other) {
        for (int i = 0; i < this.version.length && i < other.version.length; ++i) {
            if (this.version[i] > other.version[i]) {
                return 1;
            }
            if (this.version[i] >= other.version[i]) continue;
            return -1;
        }
        return this.version.length - other.version.length;
    }

    public String getVersionString() {
        StringBuilder newVersionString = new StringBuilder();
        for (int i : this.version) {
            newVersionString.append(i).append(".");
        }
        newVersionString.deleteCharAt(newVersionString.lastIndexOf("."));
        return newVersionString.toString();
    }

    public String toString() {
        return "Release{type=" + (Object)((Object)this.type) + ", version=" + Arrays.toString(this.version) + ", url='" + this.url + '\'' + '}';
    }

    public static enum EnumReleaseType {
        Normal(1),
        Beta(2),
        Dev(3);

        public int level;

        private EnumReleaseType(int level) {
            this.level = level;
        }
    }
}

