/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mods.battlegear2.api.heraldry.IFlagHolder;
import mods.battlegear2.packet.AbstractMBPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public final class BattlegearBannerPacket
extends AbstractMBPacket {
    public static final String packetName = "MB2|Banner";
    private int posX;
    private int posY;
    private int posZ;
    private List<ItemStack> parts = new ArrayList<ItemStack>();

    public BattlegearBannerPacket() {
    }

    public BattlegearBannerPacket(int x, int y, int z, List<ItemStack> flags) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.parts = flags;
    }

    @Override
    public String getChannel() {
        return packetName;
    }

    @Override
    public void write(ByteBuf out) {
        out.writeInt(this.posX);
        out.writeInt(this.posY);
        out.writeInt(this.posZ);
        out.writeByte((int)((byte)this.parts.size()));
        for (ItemStack f : this.parts) {
            ByteBufUtils.writeItemStack((ByteBuf)out, (ItemStack)f);
        }
    }

    @Override
    public void process(ByteBuf in, EntityPlayer player) {
        try {
            this.posX = in.readInt();
            this.posY = in.readInt();
            this.posZ = in.readInt();
            int size = in.readByte();
            for (int i = 0; i < size; ++i) {
                this.parts.add(ByteBufUtils.readItemStack((ByteBuf)in));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TileEntity te = player.field_70170_p.func_175625_s(new BlockPos(this.posX, this.posY, this.posZ));
        if (te instanceof IFlagHolder) {
            ((IFlagHolder)te).clearFlags();
            for (ItemStack flag : this.parts) {
                ((IFlagHolder)te).addFlag(flag);
            }
        }
    }
}

