/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.List;
import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerBase;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class NetClientHandlerTransformer
extends TransformerBase {
    private String entityOtherPlayerMPClassName;
    private String playerInventoryFieldName;
    private String netClientHandlerHandleNamedEntitySpawnMethodName;
    private String netClientHandlerHandleNamedEntitySpawnMethodDesc;
    private String netClientHandlerHandleBlockItemSwitchMethodName;
    private String netClientHandlerHandleBlockItemSwitchMethodDesc;

    public NetClientHandlerTransformer() {
        super("net.minecraft.client.network.NetHandlerPlayClient");
    }

    @Override
    boolean processMethods(List<MethodNode> methods) {
        int found = 0;
        for (MethodNode method : methods) {
            if (method.name.equals(this.netClientHandlerHandleNamedEntitySpawnMethodName) && method.desc.equals(this.netClientHandlerHandleNamedEntitySpawnMethodDesc)) {
                this.sendPatchLog("handleSpawnPlayer");
                NetClientHandlerTransformer.replaceInventoryArrayAccess(method, this.entityOtherPlayerMPClassName, this.playerInventoryFieldName, 9, 13);
                ++found;
                continue;
            }
            if (!method.name.equals(this.netClientHandlerHandleBlockItemSwitchMethodName) || !method.desc.equals(this.netClientHandlerHandleBlockItemSwitchMethodDesc)) continue;
            this.sendPatchLog("handleHeldItemChange");
            ListIterator insn = method.instructions.iterator();
            InsnList newList = new InsnList();
            while (insn.hasNext()) {
                AbstractInsnNode nextNode = (AbstractInsnNode)insn.next();
                if (nextNode instanceof JumpInsnNode && nextNode.getOpcode() == 155) {
                    LabelNode label = ((JumpInsnNode)nextNode).label;
                    newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/api/core/InventoryPlayerBattle", "isValidSwitch", "(I)Z"));
                    newList.add((AbstractInsnNode)new JumpInsnNode(153, label));
                    ++found;
                    nextNode = (AbstractInsnNode)insn.next();
                    while (insn.hasNext() && !(nextNode instanceof JumpInsnNode) && nextNode.getOpcode() != 162) {
                        nextNode = (AbstractInsnNode)insn.next();
                    }
                    continue;
                }
                newList.add(nextNode);
            }
            method.instructions = newList;
        }
        return found == 2;
    }

    @Override
    boolean processFields(List<FieldNode> fields) {
        return true;
    }

    @Override
    void setupMappings() {
        this.entityOtherPlayerMPClassName = BattlegearTranslator.getMapedClassName("client.entity.EntityOtherPlayerMP");
        this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("field_71071_by", "inventory");
        this.netClientHandlerHandleNamedEntitySpawnMethodName = BattlegearTranslator.getMapedMethodName("func_147237_a", "handleSpawnPlayer");
        this.netClientHandlerHandleNamedEntitySpawnMethodDesc = "(Lnet/minecraft/network/play/server/S0CPacketSpawnPlayer;)V";
        this.netClientHandlerHandleBlockItemSwitchMethodName = BattlegearTranslator.getMapedMethodName("func_147257_a", "handleHeldItemChange");
        this.netClientHandlerHandleBlockItemSwitchMethodDesc = "(Lnet/minecraft/network/play/server/S09PacketHeldItemChange;)V";
    }
}

