/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.utils;

import mods.battlegear2.api.RenderItemBarEvent;
import mods.battlegear2.api.RenderPlayerEventChild;
import mods.battlegear2.api.core.BattlegearUtils;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.quiver.IArrowContainer2;
import mods.battlegear2.api.quiver.QuiverArrowRegistry;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public final class BattlegearClientUtils {
    public static boolean entityOtherPlayerIsItemInUseHook(EntityOtherPlayerMP player, boolean isItemInUse) {
        ItemStack offhand;
        ItemStack itemStack = player.func_71045_bC();
        if (BattlegearUtils.isPlayerInBattlemode((EntityPlayer)player) && (offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon()) != null && BattlegearUtils.usagePriorAttack(offhand, (EntityPlayer)player, true)) {
            itemStack = offhand;
        }
        if (!isItemInUse && player.func_70113_ah() && itemStack != null) {
            player.func_71008_a(itemStack, itemStack.func_77988_m());
            return true;
        }
        if (isItemInUse && !player.func_70113_ah()) {
            player.func_71041_bz();
            return false;
        }
        return isItemInUse;
    }

    private void onRenderSheathedItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBucket || stack.func_77973_b() instanceof ItemPotion || stack.func_77973_b() instanceof IArrowContainer2) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderOffhandItem(RenderPlayerEventChild.PreRenderPlayerElement preRender) {
        if (preRender.element != null) {
            if (preRender instanceof RenderPlayerEventChild.PreRenderSheathed) {
                this.onRenderSheathedItem(preRender.element);
            } else {
                ItemStack quiverStack;
                if (preRender.element.func_77973_b() instanceof IArrowContainer2 && ((IArrowContainer2)preRender.element.func_77973_b()).renderDefaultQuiverModel(preRender.element) && BattlegearConfig.hasRender("quiver") && preRender.element == (quiverStack = QuiverArrowRegistry.getArrowContainer(preRender.entityPlayer))) {
                    preRender.setCanceled(true);
                    return;
                }
                ItemStack inUse = preRender.entityPlayer.func_71011_bu();
                if (preRender.element != inUse && inUse != null && BattlegearUtils.isBow(inUse.func_77973_b())) {
                    preRender.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderBar(RenderItemBarEvent.BattleSlots event) {
        if (!event.isMainHand) {
            event.xOffset += BattlegearConfig.battleBarOffset[0];
            event.yOffset += BattlegearConfig.battleBarOffset[1];
        } else {
            event.xOffset += BattlegearConfig.battleBarOffset[2];
            event.yOffset += BattlegearConfig.battleBarOffset[3];
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderQuiver(RenderItemBarEvent.QuiverSlots event) {
        event.xOffset += BattlegearConfig.quiverBarOffset[0];
        event.yOffset += BattlegearConfig.quiverBarOffset[1];
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void postRenderShield(RenderItemBarEvent.ShieldBar event) {
        event.xOffset += BattlegearConfig.shieldBarOffset[0];
        event.yOffset += BattlegearConfig.shieldBarOffset[1];
    }
}

